/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Environment;
import cn.robotpen.utils.BitmapUtil;
import cn.robotpen.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class FileUtils {
    private static ArrayList<String> getDevMountList() {
        String[] toSearch = FileUtils.readFile("/system/etc/vold.fstab").split(" ");
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < toSearch.length; ++i) {
            if (!toSearch[i].contains("dev_mount") || !new File(toSearch[i + 2]).exists()) continue;
            out.add(toSearch[i + 2]);
        }
        return out;
    }

    public static String getExternalSdCardPath() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File sdCardFile = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
            return sdCardFile.getAbsolutePath();
        }
        String path = null;
        File sdCardFile = null;
        ArrayList<String> devMountList = FileUtils.getDevMountList();
        for (String devMount : devMountList) {
            File file = new File(devMount);
            if (!file.isDirectory() || !file.canWrite()) continue;
            path = file.getAbsolutePath();
            File testWritable = new File(path, "test_" + FileUtils.getDateFormatName());
            if (testWritable.mkdirs()) {
                testWritable.delete();
                continue;
            }
            path = null;
        }
        if (path != null) {
            sdCardFile = new File(path);
            return sdCardFile.getAbsolutePath();
        }
        return null;
    }

    public static boolean isDirectory(String dirPath) {
        File file = new File(dirPath);
        file.mkdirs();
        return file.isDirectory();
    }

    public static boolean fileRename(String oldPath, String newPath) {
        File newFile;
        boolean result = false;
        File file = new File(oldPath);
        if (file.exists() && !(newFile = new File(newPath)).exists()) {
            result = file.renameTo(newFile);
        }
        return result;
    }

    public static boolean deleteDirectory(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        File dirFile = new File(path);
        return FileUtils.deleteDirectory(dirFile);
    }

    public static boolean deleteDirectory(File dirFile) {
        File file;
        if (dirFile == null || !dirFile.exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] fileArray = dirFile.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n && (flag = (file = fileArray[i]).isDirectory() ? FileUtils.deleteDirectory(file) : FileUtils.deleteFile(file)); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.isFile() && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static String getDateFormatName() {
        return FileUtils.getDateFormatName("yyyyMMddHHmmss");
    }

    public static String getDateFormatName(String pattern) {
        return FileUtils.getDateFormatName(pattern, System.currentTimeMillis());
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getDateFormatName(String pattern, long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        String filename = String.valueOf(dateFormat.format(time));
        return filename;
    }

    public static boolean saveBitmap(Bitmap bitmap, String savePath) {
        return FileUtils.saveBitmap(bitmap, savePath, 100);
    }

    public static boolean saveBitmap(Bitmap bitmap, String savePath, int quality) {
        boolean result = false;
        if (bitmap != null) {
            byte[] imageData = BitmapUtil.bitmap2Bytes(bitmap, quality);
            result = FileUtils.saveByteData(imageData, savePath);
        }
        return result;
    }

    public static boolean saveByteData(byte[] data, String savePath) {
        boolean result = false;
        File saveFile = new File(savePath);
        try {
            FileOutputStream fos = new FileOutputStream(saveFile);
            fos.write(data);
            fos.close();
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] getFileData(String filePath) {
        byte[] result = null;
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            if (inStream != null) {
                long size = file.length();
                result = new byte[(int)size];
                try {
                    inStream.read(result);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return result;
    }

    public static String getFileSuffix(String path) {
        String name;
        String[] s1;
        File file;
        if (StringUtil.isNotEmpty(path) && (file = new File(path)).exists() && file.isFile() && (s1 = (name = file.getName()).split("\\.")).length > 1) {
            return s1[s1.length - 1];
        }
        return null;
    }

    public static String getFileName(String path) {
        File file;
        if (StringUtil.isNotEmpty(path) && (file = new File(path)).exists() && file.isFile()) {
            return file.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filePath) {
        String fileContent = "";
        File file = new File(filePath);
        if (file == null || !file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            InputStreamReader is = new InputStreamReader(new FileInputStream(file));
            reader = new BufferedReader(is);
            String line = null;
            while ((line = reader.readLine()) != null) {
                fileContent = fileContent + line + " ";
            }
            reader.close();
            String string = fileContent;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileContent;
    }

    public static long getFileSize(String path) {
        File file;
        long size = 0L;
        if (path != null && !path.isEmpty() && (file = new File(path)).exists() && file.isFile()) {
            size = file.length();
        }
        return size;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }
}

