/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.view.View;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtil {
    public static Bitmap decodeUriAsBitmap(Context context, Uri uri) {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(uri));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap readBitMap(Context context, int resId) {
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inPreferredConfig = Bitmap.Config.ARGB_8888;
        opt.inPurgeable = true;
        opt.inInputShareable = true;
        InputStream is = context.getResources().openRawResource(resId);
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opt);
    }

    public static Bitmap safeDecodeStream(Context context, Uri uri, int width, int height) {
        Bitmap result = null;
        int scale = 1;
        ContentResolver resolver = context.getContentResolver();
        try {
            BufferedInputStream readBuffer = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            if (width > 0 || height > 0) {
                options.inJustDecodeBounds = true;
                readBuffer = new BufferedInputStream(resolver.openInputStream(uri), 16384);
                BitmapFactory.decodeStream((InputStream)readBuffer, null, (BitmapFactory.Options)options);
                readBuffer.close();
                if (options.mCancel || options.outWidth == -1 || options.outHeight == -1) {
                    return null;
                }
                int w = options.outWidth;
                int h = options.outHeight;
                while (!(width > 0 && w / 2 < width || height > 0 && h / 2 < height)) {
                    w /= 2;
                    h /= 2;
                    scale *= 2;
                }
            }
            options.inSampleSize = scale;
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            readBuffer = new BufferedInputStream(resolver.openInputStream(uri), 16384);
            result = BitmapFactory.decodeStream((InputStream)readBuffer, null, (BitmapFactory.Options)options);
            readBuffer.close();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int refSize) {
        return BitmapUtil.zoomBitmap(bitmap, refSize, true);
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int refSize, boolean autoRecycle) {
        if (bitmap != null) {
            int newHeight;
            int height;
            int newWidth = bitmap.getWidth();
            int width = newWidth;
            if (width > (height = (newHeight = bitmap.getHeight()))) {
                if (height > refSize) {
                    newHeight = refSize;
                    newWidth = (int)((float)refSize / (float)height * (float)width);
                }
            } else if (width > refSize) {
                newWidth = refSize;
                newHeight = (int)((float)refSize / (float)width * (float)height);
            }
            return BitmapUtil.zoomBitmap(bitmap, newWidth, newHeight, autoRecycle);
        }
        return null;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int width, int height) {
        return BitmapUtil.zoomBitmap(bitmap, width, height, true);
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int width, int height, boolean autoRecycle) {
        if (bitmap != null && width > 0 && height > 0) {
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            if (w != width || h != height) {
                Matrix matrix = new Matrix();
                float scaleWidth = (float)width / (float)w;
                float scaleHeight = (float)height / (float)h;
                matrix.postScale(scaleWidth, scaleHeight);
                Bitmap bmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
                if (autoRecycle && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                return bmp;
            }
        }
        return bitmap;
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap flipHorizontalBitmap(Bitmap bitmap) {
        Matrix m = new Matrix();
        m.postScale(-1.0f, 1.0f);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        if (!bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return newBitmap;
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bitmap, int degrees) {
        return BitmapUtil.rotateBitmapByDegree(bitmap, degrees, false);
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bitmap, int degrees, boolean flipHorizontal) {
        return BitmapUtil.rotateBitmapByDegree(bitmap, degrees, flipHorizontal, true);
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bitmap, int degrees, boolean flipHorizontal, boolean autoRecycle) {
        Matrix m = new Matrix();
        m.postRotate((float)degrees);
        if (flipHorizontal) {
            m.postScale(-1.0f, 1.0f);
        }
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        if (autoRecycle && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        return newBitmap;
    }

    public static Bitmap adjustBitmapRotation(Bitmap bm, int rotate) {
        float targetY;
        float targetX;
        Matrix m = new Matrix();
        m.setRotate((float)rotate);
        if (rotate == -90) {
            targetX = 0.0f;
            targetY = bm.getWidth();
        } else if (rotate == 90) {
            targetX = bm.getHeight();
            targetY = 0.0f;
        } else {
            targetX = bm.getHeight();
            targetY = bm.getWidth();
        }
        m.postTranslate(targetX, targetY);
        Bitmap bm1 = Bitmap.createBitmap((int)bm.getHeight(), (int)bm.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bm1);
        canvas.drawBitmap(bm, m, paint);
        return bm1;
    }

    public static Bitmap loadBitmapFromView(View v) {
        if (v == null) {
            return null;
        }
        Bitmap screenshot = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(screenshot);
        c.translate((float)(-v.getScrollX()), (float)(-v.getScrollY()));
        v.draw(c);
        return screenshot;
    }

    public static Bitmap combineBitmap(Bitmap background, Bitmap foreground, int fLeft, int fTop) {
        return BitmapUtil.combineBitmap(background, foreground, fLeft, fTop, Bitmap.Config.RGB_565);
    }

    public static Bitmap combineBitmap(Bitmap background, Bitmap foreground, int fLeft, int fTop, Bitmap.Config config) {
        if (background == null) {
            return null;
        }
        int bgWidth = background.getWidth();
        int bgHeight = background.getHeight();
        Bitmap newmap = Bitmap.createBitmap((int)bgWidth, (int)bgHeight, (Bitmap.Config)config);
        Canvas canvas = new Canvas(newmap);
        canvas.drawBitmap(background, 0.0f, 0.0f, null);
        canvas.drawBitmap(foreground, (float)fLeft, (float)fTop, null);
        canvas.save(31);
        canvas.restore();
        return newmap;
    }

    public static byte[] bitmap2Bytes(Bitmap bm, int quality) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static byte[] color2rgb24(int[] color) {
        if (color != null) {
            byte[] rgb24 = new byte[color.length * 3];
            for (int i = 0; i < color.length; ++i) {
                rgb24[i * 3] = (byte)(color[i] >> 16 & 0xFF);
                rgb24[i * 3 + 1] = (byte)(color[i] >> 8 & 0xFF);
                rgb24[i * 3 + 2] = (byte)(color[i] & 0xFF);
            }
            return rgb24;
        }
        return null;
    }

    public static int getExifOrientation(String filepath) {
        int orientation;
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
            }
        }
        return degree;
    }

    private Bitmap createCircleImage(Bitmap source, int min) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap target = Bitmap.createBitmap((int)min, (int)min, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        canvas.drawCircle((float)(min / 2), (float)(min / 2), (float)(min / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        return target;
    }
}

