/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.heartbeat;

import android.os.Handler;
import android.os.Looper;
import com.gensee.heartbeat.AbsHeartBeat;
import com.gensee.utils.GenseeLog;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimerHeart
extends AbsHeartBeat {
    private static final String TAG = "TimerHeart";
    private ScheduledFuture future;
    private TimerTask timerTask = new TimerTask(){
        private boolean isSetPriority = false;

        @Override
        public void run() {
            if (!this.isSetPriority) {
                this.isSetPriority = true;
                TimerHeart.this.setThreadPriority();
            }
            TimerHeart.this.doTasks();
        }
    };

    protected TimerHeart() {
    }

    @Override
    public void startHeartBeat() {
        if (this.future != null) {
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TimerHeart.this.startBeat();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startBeat() {
        GenseeLog.d((String)TAG, (String)"startBeat");
        if (null != this.future) return;
        Class<TimerHeart> clazz = TimerHeart.class;
        synchronized (TimerHeart.class) {
            ScheduledThreadPoolExecutor ses = new ScheduledThreadPoolExecutor(1);
            if (null != this.future) return;
            this.future = ses.scheduleWithFixedDelay(this.timerTask, 0L, 10L, TimeUnit.MILLISECONDS);
            GenseeLog.i((String)TAG, (String)("startBeat schedule future = " + this.future.hashCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stopHeartBeat() {
        if (null != this.future) {
            this.future.cancel(true);
        }
    }
}

