/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.heartbeat;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.gensee.taskret.IGSTask;
import com.gensee.utils.GenseeLog;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class GSHeartBeat {
    private static final int DELAY = 10;
    private static final String TAG = "GSHeartBeat";
    private static Timer mTimer;
    private static HeartBeat mVodHeartbeat;
    private static HeartBeat castHearbeat;
    private static Queue<IGSTask> tasks;
    private static Object lock;
    private static boolean isVodNeed;
    private static boolean isCastNeed;
    public static boolean isInited;
    private static TimerTask timerTask;

    public static void startHeartBeat(HeartBeat beat) {
        if (mTimer != null) {
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                GSHeartBeat.startBeat();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startBeat() {
        GenseeLog.d((String)TAG, (String)"startBeat");
        if (null != mTimer) return;
        Class<GSHeartBeat> clazz = GSHeartBeat.class;
        synchronized (GSHeartBeat.class) {
            if (null != mTimer) return;
            mTimer = new Timer(TAG);
            mTimer.schedule(timerTask, 0L, 10L);
            GenseeLog.d((String)TAG, (String)("startBeat schedule t = " + mTimer.hashCode()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setCastHBeat(HeartBeat beat) {
        castHearbeat = beat;
    }

    public static void setVodHBeat(HeartBeat beat) {
        mVodHeartbeat = beat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTasks() {
        IGSTask task = null;
        int ret = 0;
        Object object = lock;
        synchronized (object) {
            if (!tasks.isEmpty()) {
                task = tasks.poll();
            }
        }
        if (null != task) {
            try {
                ret = task.doTask();
            }
            catch (Throwable e) {
                GenseeLog.w((String)TAG, (Throwable)e);
            }
        }
        switch (ret) {
            case 1: {
                isVodNeed = true;
                break;
            }
            case 2: {
                isVodNeed = false;
                break;
            }
            case 4: {
                isCastNeed = false;
                break;
            }
            case 3: {
                isCastNeed = true;
                break;
            }
        }
        if (isVodNeed && null != mVodHeartbeat) {
            try {
                mVodHeartbeat.heartBeat();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isCastNeed && castHearbeat != null) {
            try {
                castHearbeat.heartBeat();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void stopHeartBeat() {
        if (null != mTimer) {
            mTimer.cancel();
            mTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addTask(IGSTask task) {
        Object object = lock;
        synchronized (object) {
            boolean ret = tasks.add(task);
            lock.notifyAll();
            return ret;
        }
    }

    static {
        tasks = new LinkedList<IGSTask>();
        lock = new Object();
        isVodNeed = false;
        isCastNeed = false;
        isInited = false;
        timerTask = new TimerTask(){
            private boolean isSetPriority = false;

            @Override
            public void run() {
                if (!this.isSetPriority) {
                    this.isSetPriority = true;
                    Process.setThreadPriority((int)-19);
                }
                GSHeartBeat.doTasks();
            }
        };
    }

    public static interface HeartBeat {
        public void heartBeat();
    }
}

