/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import com.gensee.utils.GenseeLog;
import com.gensee.voiceengine.Logging;
import com.gensee.voiceengine.WebRtcAudioUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private Buffer byteBuffer;
    private AudioTrack audioTrack = null;
    private AudioTrackThread audioThread = null;

    WebRtcAudioTrack(Context context, long nativeAudioTrack) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private void initPlayout(int sampleRate, int channels) {
        int trackStreamType;
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int bytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.nativeCacheDirectBufferAddress((ByteBuffer)this.byteBuffer, this.nativeAudioTrack);
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)4, (int)2);
        GenseeLog.d((String)TAG, (String)("initPlayout AudioTrack.getMinBufferSize: " + minBufferSizeInBytes));
        if (this.audioTrack != null) {
            GenseeLog.e((String)TAG, (String)("initPlayout audioTrack " + this.audioTrack));
            this.releaseAudioTrack();
        }
        if (this.byteBuffer.capacity() >= minBufferSizeInBytes) {
            GenseeLog.e((String)TAG, (String)("initPlayout minBufferSizeInBytes=" + minBufferSizeInBytes + " <= byteBuffer.capacity()=" + this.byteBuffer.capacity()));
        }
        int streamType = 3;
        try {
            this.audioTrack = new AudioTrack(streamType, sampleRate, 4, 2, minBufferSizeInBytes, 1);
        }
        catch (IllegalArgumentException e) {
            GenseeLog.e((String)TAG, (Throwable)e);
            GenseeLog.w((String)TAG, (String)"initPlayout audioTrack is null");
            return;
        }
        if (this.audioTrack.getState() != 1) {
            GenseeLog.e((String)TAG, (String)("initPlayout AudioTrack.STATE_INITIALIZED != audioTrack.getState() " + this.audioTrack.getState()));
        }
        if (this.audioTrack.getPlayState() != 1) {
            GenseeLog.e((String)TAG, (String)("initPlayout AudioTrack.PLAYSTATE_STOPPED != audioTrack.getPlayState() " + this.audioTrack.getPlayState()));
        }
        if (streamType != (trackStreamType = this.audioTrack.getStreamType())) {
            GenseeLog.e((String)TAG, (String)("initPlayout streamType = " + streamType + " but trackStreamType = " + trackStreamType));
        }
    }

    private boolean startPlayout() {
        GenseeLog.d((String)TAG, (String)"startPlayout");
        if (this.audioTrack == null) {
            GenseeLog.e((String)TAG, (String)"startPlayout audioTrack = null");
        }
        if (this.audioThread != null) {
            this.releaseThread();
            GenseeLog.w((String)TAG, (String)("startPlayout audioThread = " + this.audioThread));
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        Logging.d(TAG, "stopPlayout");
        this.releaseThread();
        this.releaseAudioTrack();
        return true;
    }

    private void releaseThread() {
        AudioTrackThread t = this.audioThread;
        this.audioThread = null;
        if (t != null) {
            t.joinThread();
        }
    }

    private void releaseAudioTrack() {
        AudioTrack track = this.audioTrack;
        this.audioTrack = null;
        if (track != null) {
            track.release();
        }
    }

    private int getStreamMaxVolume() {
        Logging.d(TAG, "getStreamMaxVolume");
        return this.audioManager != null ? this.audioManager.getStreamMaxVolume(3) : 0;
    }

    private boolean setStreamVolume(int volume) {
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        if (this.audioManager != null) {
            if (this.isVolumeFixed()) {
                Logging.e(TAG, "The device implements a fixed volume policy.");
                return false;
            }
            this.audioManager.setStreamVolume(3, volume, 0);
            return true;
        }
        return false;
    }

    @TargetApi(value=21)
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        Logging.d(TAG, "getStreamVolume");
        return this.audioManager != null ? this.audioManager.getStreamVolume(3) : 0;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            // empty if block
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            int playstate;
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                playstate = WebRtcAudioTrack.this.audioTrack.getPlayState();
                if (playstate != 3) {
                    GenseeLog.e((String)WebRtcAudioTrack.TAG, (String)"run state != AudioTrack.PLAYSTATE_PLAYING");
                }
            }
            catch (Throwable e) {
                GenseeLog.e((String)WebRtcAudioTrack.TAG, (String)("run AudioTrack.play failed: " + e.getMessage()));
                return;
            }
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack);
                if (sizeInBytes > WebRtcAudioTrack.this.byteBuffer.remaining()) {
                    GenseeLog.e((String)WebRtcAudioTrack.TAG, (String)"run sizeInBytes > byteBuffer.remaining()");
                    return;
                }
                int bytesWritten = 0;
                bytesWritten = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, (ByteBuffer)WebRtcAudioTrack.this.byteBuffer, sizeInBytes) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, (ByteBuffer)WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                if (bytesWritten != sizeInBytes) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write failed: " + bytesWritten);
                    if (bytesWritten == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException e) {
                GenseeLog.e((String)WebRtcAudioTrack.TAG, (String)("run AudioTrack.stop failed: " + e.getMessage()));
            }
            playstate = WebRtcAudioTrack.this.audioTrack.getPlayState();
            if (playstate != 1) {
                GenseeLog.e((String)WebRtcAudioTrack.TAG, (String)("run AudioTrack.stop failed: state = " + playstate + " not AudioTrack.PLAYSTATE_STOPPED " + 1));
            }
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer, sizeInBytes, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

