/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import com.gensee.utils.GenseeLog;
import com.gensee.voiceengine.AudioManagerAndroid;
import com.gensee.voiceengine.Logging;
import com.gensee.voiceengine.WebRtcAudioEffects;
import com.gensee.voiceengine.WebRtcAudioManager;
import com.gensee.voiceengine.WebRtcAudioUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private final long nativeAudioRecord;
    private final Context context;
    private WebRtcAudioEffects effects = null;
    private Buffer byteBuffer;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;

    WebRtcAudioRecord(Context context, long nativeAudioRecord) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = nativeAudioRecord;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInAGC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAGC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AGC is not supported on this platform");
            return false;
        }
        return this.effects.setAGC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    private int initRecording(int sampleRate, int channels) {
        String sampleRate_ch = "initRecording sampleRate=" + sampleRate + " channels=" + channels;
        GenseeLog.d((String)TAG, (String)sampleRate_ch);
        if (!WebRtcAudioUtils.hasPermission(this.context, "android.permission.RECORD_AUDIO")) {
            GenseeLog.e((String)TAG, (String)"initRecording RECORD_AUDIO permission is missing");
            if (null != WebRtcAudioManager.getRecordPermissionListener()) {
                WebRtcAudioManager.getRecordPermissionListener().onNoRecordPermission();
            }
            return -1;
        }
        if (this.audioRecord != null) {
            GenseeLog.e((String)TAG, (String)"InitRecording() called twice without StopRecording()");
            this.stopRecording();
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        GenseeLog.d((String)TAG, (String)("initRecording byteBuffer.capacity: " + this.byteBuffer.capacity()));
        this.nativeCacheDirectBufferAddress((ByteBuffer)this.byteBuffer, this.nativeAudioRecord);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)16, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            GenseeLog.e((String)TAG, (String)("AudioRecord.getMinBufferSize failed: " + minBufferSize));
            return -1;
        }
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        GenseeLog.d((String)TAG, (String)("initRecording bufferSizeInBytes = " + bufferSizeInBytes + " minBufferSize = " + minBufferSize + " audio s = " + AudioManagerAndroid.audioSource));
        try {
            this.audioRecord = new AudioRecord(AudioManagerAndroid.audioSource, sampleRate, 16, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            Logging.e(TAG, e.getMessage());
            GenseeLog.e((String)TAG, (String)("initRecording Failed to create a new AudioRecord instance by " + e.getMessage()));
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            GenseeLog.e((String)TAG, (String)("initRecording Failed to create AudioRecord instance = " + this.audioRecord));
            this.stopRecording();
            return -1;
        }
        String recordInfo = "AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate();
        GenseeLog.d((String)TAG, (String)recordInfo);
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        return framesPerBuffer;
    }

    private boolean startRecording() {
        block6: {
            GenseeLog.d((String)TAG, (String)("startRecording " + this.audioRecord));
            try {
                if (this.audioRecord != null) {
                    this.audioRecord.startRecording();
                    int curRecState = this.audioRecord.getRecordingState();
                    if (curRecState != 3) {
                        GenseeLog.d((String)TAG, (String)("startRecording failed state is " + curRecState));
                        this.stopRecording();
                        return false;
                    }
                    break block6;
                }
                GenseeLog.w((String)TAG, (String)"startRecording failed audioRecord is null");
                return false;
            }
            catch (IllegalStateException e) {
                GenseeLog.e((String)TAG, (Throwable)e);
                return false;
            }
        }
        if (this.audioThread == null) {
            this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
            this.audioThread.start();
        } else {
            GenseeLog.w((String)TAG, (String)("startRecording audioThread is " + this.audioThread));
        }
        return true;
    }

    private boolean stopRecording() {
        GenseeLog.d((String)TAG, (String)("stopRecording " + this.audioThread));
        if (this.audioThread != null) {
            this.audioThread.joinThread();
            this.audioThread = null;
        }
        if (this.effects != null) {
            this.effects.release();
        }
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
            GenseeLog.d((String)WebRtcAudioRecord.TAG, (String)("AudioRecordThread name = " + name));
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            String threadInfo = "run " + WebRtcAudioUtils.getThreadInfo() + " keepAlive = " + this.keepAlive;
            GenseeLog.d((String)WebRtcAudioRecord.TAG, (String)threadInfo);
            if (WebRtcAudioRecord.this.audioRecord.getRecordingState() != 3) {
                GenseeLog.d((String)WebRtcAudioRecord.TAG, (String)"run audioRecord.getRecordingState() != RECORDSTATE_RECORDING");
                return;
            }
            int frame = 0;
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = WebRtcAudioRecord.this.audioRecord.read((ByteBuffer)WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    if (++frame % 560 != 0 && frame != 1) continue;
                    long curTime = System.nanoTime();
                    GenseeLog.d((String)WebRtcAudioRecord.TAG, (String)("run read " + (frame == 1 ? 1 : 560) + " frame for " + TimeUnit.NANOSECONDS.toMillis(curTime - lastTime) + "nano seconds,total frames = " + frame));
                    lastTime = curTime;
                    continue;
                }
                GenseeLog.d((String)WebRtcAudioRecord.TAG, (String)("run read failed " + bytesRead));
                if (bytesRead != -3) continue;
                this.keepAlive = false;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException e) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

