/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.voiceengine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.gensee.utils.GenseeLog;

public class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private static final String TAG = "AudioManagerAndroid";
    protected static int audioSource = 1;
    public static int sampleRate = 44100;
    public static int sendmode = 1;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;

    @SuppressLint(value={"NewApi"})
    private AudioManagerAndroid(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
            }
            if ((framesPerBuffer = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    public static void setAudioSource(int audioSource) {
        GenseeLog.d((String)TAG, (String)("setAudioSource " + audioSource));
        if (audioSource >= 0 && audioSource <= 9) {
            AudioManagerAndroid.audioSource = audioSource;
        }
    }
}

