/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.gensee.master.flame.danmaku.controller.DrawHandler;
import com.gensee.master.flame.danmaku.controller.DrawHelper;
import com.gensee.master.flame.danmaku.controller.IDanmakuView;
import com.gensee.master.flame.danmaku.controller.IDanmakuViewController;
import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.IDanmakus;
import com.gensee.master.flame.danmaku.danmaku.model.android.DanmakuContext;
import com.gensee.master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import com.gensee.master.flame.danmaku.danmaku.renderer.IRenderer;
import com.gensee.master.flame.danmaku.danmaku.util.SystemClock;
import com.gensee.master.flame.danmaku.ui.widget.DanmakuTouchHelper;
import java.util.LinkedList;
import java.util.Locale;

public class DanmakuView
extends View
implements IDanmakuView,
IDanmakuViewController {
    public static final String TAG = "DanmakuView";
    private DrawHandler.Callback mCallback;
    private HandlerThread mHandlerThread;
    private DrawHandler handler;
    private boolean isSurfaceCreated;
    private boolean mEnableDanmakuDrwaingCache = true;
    private IDanmakuView.OnDanmakuClickListener mOnDanmakuClickListener;
    private DanmakuTouchHelper mTouchHelper;
    private boolean mShowFps;
    private boolean mDanmakuVisible = true;
    protected int mDrawingThreadType = 0;
    private Object mDrawMonitor = new Object();
    private boolean mDrawFinished = false;
    private boolean mRequestRender = false;
    private long mUiThreadId;
    private static final int MAX_RECORD_SIZE = 50;
    private static final int ONE_SECOND = 1000;
    private LinkedList<Long> mDrawTimes;
    private boolean mClearFlag;
    private int mResumeTryCount = 0;
    private Runnable mResumeRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuView.this.handler == null) {
                return;
            }
            DanmakuView.this.mResumeTryCount++;
            if (DanmakuView.this.mResumeTryCount > 4 || DanmakuView.super.isShown()) {
                DanmakuView.this.handler.resume();
            } else {
                DanmakuView.this.handler.postDelayed(this, 100 * DanmakuView.this.mResumeTryCount);
            }
        }
    };

    public DanmakuView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mUiThreadId = Thread.currentThread().getId();
        this.setBackgroundColor(0);
        this.setDrawingCacheBackgroundColor(0);
        DrawHelper.useDrawColorToClearCanvas(true, false);
        this.mTouchHelper = DanmakuTouchHelper.instance(this);
    }

    public DanmakuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DanmakuView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @Override
    public void addDanmaku(BaseDanmaku item) {
        if (this.handler != null) {
            this.handler.addDanmaku(item);
        }
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item, boolean remeasure) {
        if (this.handler != null) {
            this.handler.invalidateDanmaku(item, remeasure);
        }
    }

    @Override
    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.handler != null) {
            this.handler.removeAllDanmakus(isClearDanmakusOnScreen);
        }
    }

    @Override
    public void removeAllLiveDanmakus() {
        if (this.handler != null) {
            this.handler.removeAllLiveDanmakus();
        }
    }

    @Override
    public IDanmakus getCurrentVisibleDanmakus() {
        if (this.handler != null) {
            return this.handler.getCurrentVisibleDanmakus();
        }
        return null;
    }

    @Override
    public void setCallback(DrawHandler.Callback callback) {
        this.mCallback = callback;
        if (this.handler != null) {
            this.handler.setCallback(callback);
        }
    }

    @Override
    public void release() {
        this.stop();
        if (this.mDrawTimes != null) {
            this.mDrawTimes.clear();
        }
    }

    @Override
    public void stop() {
        this.stopDraw();
    }

    private void stopDraw() {
        DrawHandler handler = this.handler;
        this.handler = null;
        this.unlockCanvasAndPost();
        if (handler != null) {
            handler.quit();
        }
        if (this.mHandlerThread != null) {
            HandlerThread handlerThread = this.mHandlerThread;
            this.mHandlerThread = null;
            try {
                handlerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            handlerThread.quit();
        }
    }

    protected Looper getLooper(int type) {
        int priority;
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
        }
        switch (type) {
            case 1: {
                return Looper.getMainLooper();
            }
            case 2: {
                priority = -8;
                break;
            }
            case 3: {
                priority = 19;
                break;
            }
            default: {
                priority = 0;
            }
        }
        String threadName = "DFM Handler Thread #" + priority;
        this.mHandlerThread = new HandlerThread(threadName, priority);
        this.mHandlerThread.start();
        return this.mHandlerThread.getLooper();
    }

    private void prepare() {
        if (this.handler == null) {
            this.handler = new DrawHandler(this.getLooper(this.mDrawingThreadType), this, this.mDanmakuVisible);
        }
    }

    @Override
    public void prepare(BaseDanmakuParser parser, DanmakuContext config) {
        this.prepare();
        this.handler.setConfig(config);
        this.handler.setParser(parser);
        this.handler.setCallback(this.mCallback);
        this.handler.prepare();
    }

    @Override
    public boolean isPrepared() {
        return this.handler != null && this.handler.isPrepared();
    }

    @Override
    public DanmakuContext getConfig() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getConfig();
    }

    @Override
    public void showFPS(boolean show) {
        this.mShowFps = show;
    }

    private float fps() {
        long lastTime = SystemClock.uptimeMillis();
        this.mDrawTimes.addLast(lastTime);
        float dtime = lastTime - this.mDrawTimes.getFirst();
        int frames = this.mDrawTimes.size();
        if (frames > 50) {
            this.mDrawTimes.removeFirst();
        }
        return dtime > 0.0f ? (float)(this.mDrawTimes.size() * 1000) / dtime : 0.0f;
    }

    @Override
    public long drawDanmakus() {
        if (!this.isSurfaceCreated) {
            return 0L;
        }
        if (!this.isShown()) {
            return -1L;
        }
        long stime = SystemClock.uptimeMillis();
        this.lockCanvas();
        return SystemClock.uptimeMillis() - stime;
    }

    @SuppressLint(value={"NewApi"})
    private void postInvalidateCompat() {
        this.mRequestRender = true;
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCanvas() {
        if (!this.mDanmakuVisible) {
            return;
        }
        this.postInvalidateCompat();
        Object object = this.mDrawMonitor;
        synchronized (object) {
            while (!this.mDrawFinished && this.handler != null) {
                try {
                    this.mDrawMonitor.wait(200L);
                }
                catch (InterruptedException e) {
                    if (!this.mDanmakuVisible || this.handler == null || this.handler.isStop()) break;
                    Thread.currentThread().interrupt();
                }
            }
            this.mDrawFinished = false;
        }
    }

    private void lockCanvasAndClear() {
        this.mClearFlag = true;
        this.lockCanvas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockCanvasAndPost() {
        Object object = this.mDrawMonitor;
        synchronized (object) {
            this.mDrawFinished = true;
            this.mDrawMonitor.notifyAll();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mDanmakuVisible && !this.mRequestRender) {
            super.onDraw(canvas);
            return;
        }
        if (this.mClearFlag) {
            DrawHelper.clearCanvas(canvas);
            this.mClearFlag = false;
        } else if (this.handler != null) {
            IRenderer.RenderingState rs = this.handler.draw(canvas);
            if (this.mShowFps) {
                if (this.mDrawTimes == null) {
                    this.mDrawTimes = new LinkedList();
                }
                String fps = String.format(Locale.getDefault(), "fps %.2f,time:%d s,cache:%d,miss:%d", Float.valueOf(this.fps()), this.getCurrentTime() / 1000L, rs.cacheHitCount, rs.cacheMissCount);
                DrawHelper.drawFPS(canvas, fps);
            }
        }
        this.mRequestRender = false;
        this.unlockCanvasAndPost();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.handler != null) {
            this.handler.notifyDispSizeChanged(right - left, bottom - top);
        }
        this.isSurfaceCreated = true;
    }

    @Override
    public void toggle() {
        if (this.isSurfaceCreated) {
            if (this.handler == null) {
                this.start();
            } else if (this.handler.isStop()) {
                this.resume();
            } else {
                this.pause();
            }
        }
    }

    @Override
    public void pause() {
        if (this.handler != null) {
            this.handler.pause();
        }
    }

    @Override
    public void resume() {
        if (this.handler != null && this.handler.isPrepared()) {
            this.mResumeTryCount = 0;
            this.handler.postDelayed(this.mResumeRunnable, 100L);
        } else if (this.handler == null) {
            this.restart();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.handler != null) {
            return this.handler.isStop();
        }
        return false;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void start() {
        this.start(0L);
    }

    @Override
    public void start(long postion) {
        if (this.handler == null) {
            this.prepare();
        } else {
            this.handler.removeCallbacksAndMessages(null);
        }
        this.handler.obtainMessage(1, postion).sendToTarget();
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public void seekTo(Long ms) {
        if (this.handler != null) {
            this.handler.seekTo(ms);
        }
    }

    @Override
    public void enableDanmakuDrawingCache(boolean enable) {
        this.mEnableDanmakuDrwaingCache = enable;
    }

    @Override
    public boolean isDanmakuDrawingCacheEnabled() {
        return this.mEnableDanmakuDrwaingCache;
    }

    @Override
    public boolean isViewReady() {
        return this.isSurfaceCreated;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void show() {
        this.showAndResumeDrawTask(null);
    }

    @Override
    public void showAndResumeDrawTask(Long position) {
        this.mDanmakuVisible = true;
        this.mClearFlag = false;
        if (this.handler == null) {
            return;
        }
        this.handler.showDanmakus(position);
    }

    @Override
    public void hide() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return;
        }
        this.handler.hideDanmakus(false);
    }

    @Override
    public long hideAndPauseDrawTask() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return 0L;
        }
        return this.handler.hideDanmakus(true);
    }

    @Override
    public void clear() {
        if (!this.isViewReady()) {
            return;
        }
        if (!this.mDanmakuVisible || Thread.currentThread().getId() == this.mUiThreadId) {
            this.mClearFlag = true;
            this.postInvalidateCompat();
        } else {
            this.lockCanvasAndClear();
        }
    }

    @Override
    public boolean isShown() {
        return this.mDanmakuVisible && super.isShown();
    }

    @Override
    public void setDrawingThreadType(int type) {
        this.mDrawingThreadType = type;
    }

    @Override
    public long getCurrentTime() {
        if (this.handler != null) {
            return this.handler.getCurrentTime();
        }
        return 0L;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean isHardwareAccelerated() {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.isHardwareAccelerated();
        }
        return false;
    }

    @Override
    public void clearDanmakusOnScreen() {
        if (this.handler != null) {
            this.handler.clearDanmakusOnScreen();
        }
    }

    @Override
    public void setOnDanmakuClickListener(IDanmakuView.OnDanmakuClickListener listener) {
        this.mOnDanmakuClickListener = listener;
        this.setClickable(null != listener);
    }

    @Override
    public IDanmakuView.OnDanmakuClickListener getOnDanmakuClickListener() {
        return this.mOnDanmakuClickListener;
    }
}

