/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.ui.widget;

import android.graphics.RectF;
import android.view.MotionEvent;
import com.gensee.master.flame.danmaku.controller.IDanmakuView;
import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.IDanmakuIterator;
import com.gensee.master.flame.danmaku.danmaku.model.IDanmakus;
import com.gensee.master.flame.danmaku.danmaku.model.android.Danmakus;

public class DanmakuTouchHelper {
    private IDanmakuView danmakuView;
    private RectF mDanmakuBounds;

    private DanmakuTouchHelper(IDanmakuView danmakuView) {
        this.danmakuView = danmakuView;
        this.mDanmakuBounds = new RectF();
    }

    public static synchronized DanmakuTouchHelper instance(IDanmakuView danmakuView) {
        return new DanmakuTouchHelper(danmakuView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                IDanmakus clickDanmakus = this.touchHitDanmaku(event.getX(), event.getY());
                BaseDanmaku newestDanmaku = null;
                if (null != clickDanmakus && !clickDanmakus.isEmpty()) {
                    this.performClick(clickDanmakus);
                    newestDanmaku = this.fetchLatestOne(clickDanmakus);
                }
                if (null == newestDanmaku) break;
                this.performClickWithlatest(newestDanmaku);
                break;
            }
        }
        return false;
    }

    private void performClickWithlatest(BaseDanmaku newest) {
        if (this.danmakuView.getOnDanmakuClickListener() != null) {
            this.danmakuView.getOnDanmakuClickListener().onDanmakuClick(newest);
        }
    }

    private void performClick(IDanmakus danmakus) {
        if (this.danmakuView.getOnDanmakuClickListener() != null) {
            this.danmakuView.getOnDanmakuClickListener().onDanmakuClick(danmakus);
        }
    }

    private IDanmakus touchHitDanmaku(float x, float y) {
        Danmakus hitDanmakus = new Danmakus();
        this.mDanmakuBounds.setEmpty();
        IDanmakus danmakus = this.danmakuView.getCurrentVisibleDanmakus();
        if (null != danmakus && !danmakus.isEmpty()) {
            IDanmakuIterator iterator = danmakus.iterator();
            while (iterator.hasNext()) {
                BaseDanmaku danmaku = iterator.next();
                if (null == danmaku) continue;
                this.mDanmakuBounds.set(danmaku.getLeft(), danmaku.getTop(), danmaku.getRight(), danmaku.getBottom());
                if (!this.mDanmakuBounds.contains(x, y)) continue;
                hitDanmakus.addItem(danmaku);
            }
        }
        return hitDanmakus;
    }

    private BaseDanmaku fetchLatestOne(IDanmakus danmakus) {
        if (danmakus.isEmpty()) {
            return null;
        }
        return danmakus.last();
    }
}

