/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.danmaku.parser.android;

import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.android.Danmakus;
import com.gensee.master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import com.gensee.master.flame.danmaku.danmaku.parser.android.JSONSource;
import com.gensee.master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AcFunDanmakuParser
extends BaseDanmakuParser {
    @Override
    public Danmakus parse() {
        if (this.mDataSource != null && this.mDataSource instanceof JSONSource) {
            JSONSource jsonSource = (JSONSource)this.mDataSource;
            return this.doParse(jsonSource.data());
        }
        return new Danmakus();
    }

    private Danmakus doParse(JSONArray danmakuListData) {
        Danmakus danmakus = new Danmakus();
        if (danmakuListData == null || danmakuListData.length() == 0) {
            return danmakus;
        }
        for (int i = 0; i < danmakuListData.length(); ++i) {
            try {
                JSONObject danmakuArray = danmakuListData.getJSONObject(i);
                if (danmakuArray == null) continue;
                danmakus = this._parse(danmakuArray, danmakus);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return danmakus;
    }

    private Danmakus _parse(JSONObject jsonObject, Danmakus danmakus) {
        if (danmakus == null) {
            danmakus = new Danmakus();
        }
        if (jsonObject == null || jsonObject.length() == 0) {
            return danmakus;
        }
        for (int i = 0; i < jsonObject.length(); ++i) {
            try {
                int type;
                JSONObject obj = jsonObject;
                String c = obj.getString("c");
                String[] values = c.split(",");
                if (values.length <= 0 || (type = Integer.parseInt(values[2])) == 7) continue;
                long time = (long)(Float.parseFloat(values[0]) * 1000.0f);
                int color = Integer.parseInt(values[1]) | 0xFF000000;
                float textSize = Float.parseFloat(values[3]);
                BaseDanmaku item = this.mContext.mDanmakuFactory.createDanmaku(type, this.mContext);
                if (item == null) continue;
                item.time = time;
                item.textSize = textSize * (this.mDispDensity - 0.6f);
                item.textColor = color;
                item.textShadowColor = color <= -16777216 ? -1 : -16777216;
                DanmakuUtils.fillText(item, obj.optString("m", "...."));
                item.index = i;
                item.setTimer(this.mTimer);
                danmakus.addItem(item);
                continue;
            }
            catch (JSONException jSONException) {
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return danmakus;
    }
}

