/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.danmaku.model.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import java.util.HashMap;
import java.util.Map;

public class SimpleTextCacheStuffer
extends BaseCacheStuffer {
    private static final Map<Float, Float> sTextHeightCache = new HashMap<Float, Float>();

    protected Float getCacheHeight(BaseDanmaku danmaku, Paint paint) {
        Float textSize = Float.valueOf(paint.getTextSize());
        Float textHeight = sTextHeightCache.get(textSize);
        if (textHeight == null) {
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            textHeight = Float.valueOf(fontMetrics.descent - fontMetrics.ascent + fontMetrics.leading);
            sTextHeightCache.put(textSize, textHeight);
        }
        return textHeight;
    }

    @Override
    public void measure(BaseDanmaku danmaku, TextPaint paint, boolean fromWorkerThread) {
        if (this.mProxy != null) {
            this.mProxy.prepareDrawing(danmaku, fromWorkerThread);
        }
        float w = 0.0f;
        Float textHeight = Float.valueOf(0.0f);
        if (danmaku.lines == null) {
            if (danmaku.text == null) {
                w = 0.0f;
            } else {
                w = paint.measureText(danmaku.text.toString());
                textHeight = this.getCacheHeight(danmaku, (Paint)paint);
            }
            danmaku.paintWidth = w;
            danmaku.paintHeight = textHeight.floatValue();
        } else {
            textHeight = this.getCacheHeight(danmaku, (Paint)paint);
            for (String tempStr : danmaku.lines) {
                if (tempStr.length() <= 0) continue;
                float tr = paint.measureText(tempStr);
                w = Math.max(tr, w);
            }
            danmaku.paintWidth = w;
            danmaku.paintHeight = (float)danmaku.lines.length * textHeight.floatValue();
        }
    }

    @Override
    public void drawStroke(BaseDanmaku danmaku, String lineText, Canvas canvas, float left, float top, Paint paint) {
        if (lineText != null) {
            canvas.drawText(lineText, left, top, paint);
        } else {
            canvas.drawText(danmaku.text.toString(), left, top, paint);
        }
    }

    @Override
    public void drawText(BaseDanmaku danmaku, String lineText, Canvas canvas, float left, float top, TextPaint paint, boolean fromWorkerThread) {
        if (lineText != null) {
            canvas.drawText(lineText, left, top, (Paint)paint);
        } else {
            canvas.drawText(danmaku.text.toString(), left, top, (Paint)paint);
        }
    }

    @Override
    public void clearCaches() {
        sTextHeightCache.clear();
    }

    @Override
    public void drawBackground(BaseDanmaku danmaku, Canvas canvas, float left, float top) {
    }
}

