/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.danmaku.model.android;

import com.gensee.master.flame.danmaku.danmaku.model.IDrawingCache;
import com.gensee.master.flame.danmaku.danmaku.model.android.DrawingCacheHolder;
import com.gensee.master.flame.danmaku.danmaku.model.objectpool.Poolable;

public class DrawingCache
implements IDrawingCache<DrawingCacheHolder>,
Poolable<DrawingCache> {
    private final DrawingCacheHolder mHolder = new DrawingCacheHolder();
    private int mSize = 0;
    private DrawingCache mNextElement;
    private boolean mIsPooled;
    private int referenceCount = 0;

    @Override
    public void build(int w, int h, int density, boolean checkSizeEquals) {
        DrawingCacheHolder holder = this.mHolder;
        holder.buildCache(w, h, density, checkSizeEquals);
        this.mSize = this.mHolder.bitmap.getRowBytes() * this.mHolder.bitmap.getHeight();
    }

    @Override
    public void erase() {
        this.mHolder.erase();
    }

    @Override
    public DrawingCacheHolder get() {
        DrawingCacheHolder holder = this.mHolder;
        if (holder.bitmap == null) {
            return null;
        }
        return this.mHolder;
    }

    @Override
    public void destroy() {
        if (this.mHolder != null) {
            this.mHolder.recycle();
        }
        this.mSize = 0;
        this.referenceCount = 0;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void setNextPoolable(DrawingCache element) {
        this.mNextElement = element;
    }

    @Override
    public DrawingCache getNextPoolable() {
        return this.mNextElement;
    }

    @Override
    public boolean isPooled() {
        return this.mIsPooled;
    }

    @Override
    public void setPooled(boolean isPooled) {
        this.mIsPooled = isPooled;
    }

    @Override
    public synchronized boolean hasReferences() {
        return this.referenceCount > 0;
    }

    @Override
    public synchronized void increaseReference() {
        ++this.referenceCount;
    }

    @Override
    public synchronized void decreaseReference() {
        --this.referenceCount;
    }

    @Override
    public int width() {
        return this.mHolder.width;
    }

    @Override
    public int height() {
        return this.mHolder.height;
    }
}

