/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.master.flame.danmaku.danmaku.model;

import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.Duration;
import com.gensee.master.flame.danmaku.danmaku.model.IDisplayer;

public class FTDanmaku
extends BaseDanmaku {
    private float x = 0.0f;
    protected float y = -1.0f;
    private float[] RECT = null;
    private float mLastLeft;
    private float mLastPaintWidth;
    private int mLastDispWidth;

    public FTDanmaku(Duration duration) {
        this.duration = duration;
    }

    @Override
    public void layout(IDisplayer displayer, float x, float y) {
        if (this.mTimer != null) {
            long deltaDuration = this.mTimer.currMillisecond - this.time;
            if (deltaDuration > 0L && deltaDuration < this.duration.value) {
                if (!this.isShown()) {
                    this.x = this.getLeft(displayer);
                    this.y = y;
                    this.setVisibility(true);
                }
                return;
            }
            this.setVisibility(false);
            this.y = -1.0f;
            this.x = displayer.getWidth();
        }
    }

    protected float getLeft(IDisplayer displayer) {
        if (this.mLastDispWidth == displayer.getWidth() && this.mLastPaintWidth == this.paintWidth) {
            return this.mLastLeft;
        }
        float left = ((float)displayer.getWidth() - this.paintWidth) / 2.0f;
        this.mLastDispWidth = displayer.getWidth();
        this.mLastPaintWidth = this.paintWidth;
        this.mLastLeft = left;
        return left;
    }

    @Override
    public float[] getRectAtTime(IDisplayer displayer, long time) {
        if (!this.isMeasured()) {
            return null;
        }
        float left = this.getLeft(displayer);
        if (this.RECT == null) {
            this.RECT = new float[4];
        }
        this.RECT[0] = left;
        this.RECT[1] = this.y;
        this.RECT[2] = left + this.paintWidth;
        this.RECT[3] = this.y + this.paintHeight;
        return this.RECT;
    }

    @Override
    public float getLeft() {
        return this.x;
    }

    @Override
    public float getTop() {
        return this.y;
    }

    @Override
    public float getRight() {
        return this.x + this.paintWidth;
    }

    @Override
    public float getBottom() {
        return this.y + this.paintHeight;
    }

    @Override
    public int getType() {
        return 5;
    }
}

