/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.util;

import android.content.Context;
import android.os.Environment;
import com.gensee.fastsdk.util.ConfigApp;
import com.gensee.utils.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogcatHelper {
    private static LogcatHelper INSTANCE = null;
    private static String PATH_LOGCAT;
    private LogDumper mLogDumper = null;
    private int mPId;

    public void init(Context context) {
        PATH_LOGCAT = Environment.getExternalStorageState().equals("mounted") ? ConfigApp.LOGPATH + "logcat" + File.separator : context.getFilesDir().getAbsolutePath() + File.separator + "logcat" + File.separator;
        File file = new File(PATH_LOGCAT);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static LogcatHelper getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new LogcatHelper(context);
        }
        return INSTANCE;
    }

    private LogcatHelper(Context context) {
        this.init(context);
        this.mPId = android.os.Process.myPid();
    }

    public void start() {
        if (this.mLogDumper == null) {
            this.mLogDumper = new LogDumper(String.valueOf(this.mPId), PATH_LOGCAT);
        }
        this.mLogDumper.start();
    }

    public void stop() {
        if (this.mLogDumper != null) {
            this.mLogDumper.stopLogs();
            this.mLogDumper = null;
        }
    }

    private static class MyDate {
        private MyDate() {
        }

        public static String getFileName() {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = format1.format(new Date(System.currentTimeMillis()));
            return date;
        }

        public static String getDateEN() {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String date1 = format1.format(new Date(System.currentTimeMillis()));
            return date1;
        }
    }

    private class LogDumper
    extends Thread {
        private Process logcatProc;
        private BufferedReader mReader = null;
        private boolean mRunning = true;
        String cmds = null;
        private String mPID;
        private FileOutputStream out = null;
        private String dir = "";

        public LogDumper(String pid, String dir) {
            this.mPID = pid;
            try {
                this.dir = dir;
                this.out = new FileOutputStream(new File(dir, "logcat-" + MyDate.getFileName() + ".txt"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.cmds = "logcat ";
        }

        public void stopLogs() {
            this.mRunning = false;
        }

        @Override
        public void run() {
            try {
                File f = new File(this.dir);
                if (f.exists()) {
                    FileUtil.deleteFileByTime((File)f, (long)System.currentTimeMillis(), (long)3600000L);
                }
                this.logcatProc = Runtime.getRuntime().exec(this.cmds);
                this.mReader = new BufferedReader(new InputStreamReader(this.logcatProc.getInputStream()), 1024);
                String line = null;
                while (this.mRunning && (line = this.mReader.readLine()) != null) {
                    if (!this.mRunning) {
                        break;
                    }
                    if (line.length() == 0 || this.out == null) continue;
                    this.out.write((MyDate.getDateEN() + "  " + line + "\n").getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.logcatProc != null) {
                    this.logcatProc.destroy();
                    this.logcatProc = null;
                }
                if (this.mReader != null) {
                    try {
                        this.mReader.close();
                        this.mReader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.out = null;
                }
            }
        }
    }
}

