/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.util.ConfigApp;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import java.util.List;

public class VodPopMore
extends PopupWindow
implements View.OnClickListener {
    private OnMoreItemClick itemClick;
    private View share;
    private float density = 0.0f;

    public void onClick(View v) {
        if (this.itemClick == null) {
            return;
        }
        if (v.getId() == ResManager.getId("txtShare")) {
            this.itemClick.onItemShare();
        } else if (v.getId() == ResManager.getId("txtDiagnose")) {
            this.itemClick.onItemSendErrorMsg();
        }
        this.dismiss();
    }

    public VodPopMore(Context context) {
        super(context);
    }

    public VodPopMore(Context context, OnMoreItemClick itemClick) {
        this(context);
        this.itemClick = itemClick;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        LinearLayout view = (LinearLayout)inflater.inflate(ResManager.getLayoutId("fs_vod_pop_more_layout"), null);
        this.share = view.findViewById(ResManager.getId("txtShare"));
        this.share.setOnClickListener((View.OnClickListener)this);
        view.findViewById(ResManager.getId("txtDiagnose")).setOnClickListener((View.OnClickListener)this);
        List<GSMoreItem> gsMoreItemsList = null;
        if (null != ConfigApp.getIns().getFastConfig()) {
            gsMoreItemsList = ConfigApp.getIns().getFastConfig().getExtraGSMoreItems();
        }
        this.addExtraItem(context, view, gsMoreItemsList);
        this.setContentView((View)view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable(context.getResources().getDrawable(ResManager.getColorId("fs_gs_transparent")));
        this.setOutsideTouchable(false);
        this.setFocusable(true);
    }

    private void addExtraItem(Context context, LinearLayout rootView, List<GSMoreItem> gsMoreItems) {
        if (null == gsMoreItems) {
            return;
        }
        for (int i = 0; i < gsMoreItems.size(); ++i) {
            GSMoreItem item = gsMoreItems.get(i);
            LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_gs_more_item"), null);
            int idly = GenseeUtils.generateViewId();
            linearLayout.setId(idly);
            gsMoreItems.get(i).setId(idly);
            ImageView imageView = (ImageView)linearLayout.getChildAt(0);
            imageView.setImageDrawable(item.getIcon());
            TextView textView = (TextView)linearLayout.getChildAt(1);
            textView.setText((CharSequence)item.getText());
            linearLayout.setOnClickListener((View.OnClickListener)this);
            int viewIndex = -1;
            if (item.getItemIndex() <= 5) {
                viewIndex = 0;
            } else if (item.getItemIndex() > 5 && item.getItemIndex() <= 10) {
                viewIndex = 1;
            } else if (item.getItemIndex() > 10 && item.getItemIndex() <= 15) {
                viewIndex = 2;
            }
            if (viewIndex >= 0) {
                rootView.addView((View)linearLayout, viewIndex);
                continue;
            }
            rootView.addView((View)linearLayout);
        }
    }

    public void showWindow(View anchor, boolean isCasting) {
        this.showAsDropDown(anchor, anchor.getWidth() - this.getWidth(), (int)(-11.5 * (double)this.getDensity((Context)GenseeUtils.getActivityFromView(anchor))));
    }

    private float getDensity(Context context) {
        if (this.density == 0.0f) {
            this.density = context.getResources().getDisplayMetrics().density;
        }
        return this.density;
    }

    public static interface OnMoreItemClick {
        public void onItemShare();

        public void onItemSendErrorMsg();
    }
}

