/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.WindowManager;
import android.widget.TextView;
import java.util.Timer;
import java.util.TimerTask;

public class QaScrollTextView
extends TextView {
    private float textLength = 0.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private Paint paint = null;
    private String text = "";
    private boolean bInit = false;
    private Timer timer;
    private static final int SCROLL_TIME = 6000;
    private static final int PER_SCROLL_TIME = 150;
    private int perMoveLenght = 0;
    private int haveScrollTime = 0;

    public QaScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initScrollTextView(WindowManager windowManager, String text, int color2) {
        this.paint = this.getPaint();
        this.paint.setColor(color2);
        this.text = text;
        this.bInit = true;
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        this.perMoveLenght = 0;
        this.haveScrollTime = 0;
        this.textLength = this.paint.measureText(text);
        this.ty = this.getTextSize() + (float)this.getPaddingTop();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.textLength <= (float)this.getWidth()) {
            canvas.drawText(this.text, 0.0f, this.ty, this.paint);
        } else {
            if (this.bInit) {
                this.tx = this.getWidth();
                this.bInit = false;
                int moveLength = (int)(this.textLength + (float)this.getWidth());
                this.perMoveLenght = moveLength / 40;
                if (null != this.timer) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        QaScrollTextView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                QaScrollTextView.this.countTx();
                            }
                        });
                    }
                }, 150L, 150L);
            }
            canvas.drawText(this.text, this.tx, this.ty, this.paint);
        }
        super.onDraw(canvas);
    }

    private void countTx() {
        this.haveScrollTime += 150;
        this.tx -= (float)this.perMoveLenght;
        this.invalidate();
        if (this.haveScrollTime >= 6000) {
            this.haveScrollTime = 0;
            this.tx = this.getWidth();
        }
    }

    public void close() {
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

