/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import java.util.List;

public class PopMore
extends PopupWindow
implements View.OnClickListener {
    private List<GSMoreItem> gsMoreItems;
    private TextView tvNetSwitch;
    private LinearLayout lyNetSwitch;
    private OnMoreItemClick itemClick;
    private float density = 0.0f;

    public PopMore(Context context) {
        super(context);
    }

    public PopMore(Context context, OnMoreItemClick itemClick, List<GSMoreItem> gsMoreItems) {
        this(context);
        this.itemClick = itemClick;
        this.gsMoreItems = gsMoreItems;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        LinearLayout view = (LinearLayout)inflater.inflate(ResManager.getLayoutId("fs_pop_more_layout"), null);
        LinearLayout viewCloseVideo = (LinearLayout)view.findViewById(ResManager.getId("txtCloseVideo"));
        viewCloseVideo.setVisibility(PlayerLive.getIns().isShowCloseVideo() ? 0 : 8);
        TextView tv = (TextView)viewCloseVideo.getChildAt(0);
        boolean isVideoClose = PreferUtil.getIns().getBoolean("KEY_VIDEO_CLOSED");
        viewCloseVideo.setSelected(isVideoClose);
        if (isVideoClose) {
            tv.setText(ResManager.getStringId("fs_gs_open_video"));
        } else {
            tv.setText(ResManager.getStringId("fs_gs_close_video"));
        }
        viewCloseVideo.setOnClickListener((View.OnClickListener)this);
        this.lyNetSwitch = (LinearLayout)view.findViewById(ResManager.getId("lyNetSwitch"));
        this.lyNetSwitch.setOnClickListener((View.OnClickListener)this);
        this.lyNetSwitch.setVisibility(PlayerLive.getIns().isShownetSwitch() ? 0 : 8);
        this.tvNetSwitch = (TextView)view.findViewById(ResManager.getId("tvNetSwitch"));
        view.findViewById(ResManager.getId("txtDiagnose")).setOnClickListener((View.OnClickListener)this);
        this.addExtraItem(context, view, gsMoreItems);
        this.setContentView((View)view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable(context.getResources().getDrawable(17170445));
        this.setOutsideTouchable(false);
        this.setFocusable(true);
        this.setSoftInputMode(16);
    }

    private void addExtraItem(Context context, LinearLayout rootView, List<GSMoreItem> gsMoreItems) {
        if (null == gsMoreItems) {
            return;
        }
        for (int i = 0; i < gsMoreItems.size(); ++i) {
            GSMoreItem item = gsMoreItems.get(i);
            LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_gs_more_item"), null);
            int idly = GenseeUtils.generateViewId();
            linearLayout.setId(idly);
            gsMoreItems.get(i).setId(idly);
            ImageView imageView = (ImageView)linearLayout.getChildAt(0);
            imageView.setImageDrawable(item.getIcon());
            TextView textView = (TextView)linearLayout.getChildAt(1);
            textView.setText((CharSequence)item.getText());
            linearLayout.setOnClickListener((View.OnClickListener)this);
            int viewIndex = -1;
            if (item.getItemIndex() <= 5) {
                viewIndex = 0;
            } else if (item.getItemIndex() > 5 && item.getItemIndex() <= 10) {
                viewIndex = 1;
            } else if (item.getItemIndex() > 10 && item.getItemIndex() <= 15) {
                viewIndex = 2;
            }
            if (viewIndex >= 0) {
                rootView.addView((View)linearLayout, viewIndex);
                continue;
            }
            rootView.addView((View)linearLayout);
        }
    }

    public void onClick(View v) {
        if (this.itemClick == null) {
            return;
        }
        if (v.getId() == ResManager.getId("lyNetSwitch")) {
            this.itemClick.onSelectIdc();
        } else if (v.getId() == ResManager.getId("txtDiagnose")) {
            this.itemClick.onItemSendErrorMsg();
        } else if (v.getId() == ResManager.getId("txtCloseVideo")) {
            this.itemClick.onSelectCloseVideo(v);
        } else {
            for (int i = 0; i < this.gsMoreItems.size(); ++i) {
                GSMoreItem item = this.gsMoreItems.get(i);
                if (item.getId() != v.getId()) continue;
                String subject = PlayerLive.getIns().getSubject();
                String liveId = PlayerLive.getIns().getLiveId();
                item.getIGSItemClickEvent().itemEvent(v, subject, liveId);
            }
        }
        this.dismiss();
    }

    private float getDensity(Context context) {
        if (this.density == 0.0f) {
            this.density = context.getResources().getDisplayMetrics().density;
        }
        return this.density;
    }

    public void showWindow(View anchor, boolean isCasting) {
        this.showAsDropDown(anchor, anchor.getWidth() - this.getWidth(), (int)(-11.5 * (double)this.getDensity(anchor.getContext())));
    }

    public static interface OnMoreItemClick {
        public void onItemSendErrorMsg();

        public void onSelectIdc();

        public void onSelectCloseVideo(View var1);
    }
}

