/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.ui.holder.video.VideoViewTouchHolder;

public class PipViewTouchHolder
extends VideoViewTouchHolder {
    private OnPipFullScreenSmallListener onPipFullScreenSmallListener;
    private int portraitLeft = -1;
    private int portraitTop = -1;
    private int lastLeft = 0;
    private int lastTop = 0;
    private RelativeLayout parentRootView;

    public void initPosition(int leftMargin, int topMargin) {
        this.portraitLeft = leftMargin;
        this.portraitTop = topMargin;
    }

    public PipViewTouchHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void setOnPadFullScreenSmallListener(OnPipFullScreenSmallListener onPipFullScreenSmallListener) {
        this.onPipFullScreenSmallListener = onPipFullScreenSmallListener;
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.parentRootView = (RelativeLayout)value;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        boolean isMove;
        if (null != this.onPipFullScreenSmallListener && (isMove = this.onPipFullScreenSmallListener.isMove())) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.lastLeft = (int)event.getRawX();
                    this.lastTop = (int)event.getRawY();
                    break;
                }
                case 2: {
                    int x = (int)event.getRawX();
                    int y = (int)event.getRawY();
                    int moveX = x - this.lastLeft;
                    int moveY = y - this.lastTop;
                    this.portraitLeft += moveX;
                    if (this.portraitLeft < 0) {
                        this.portraitLeft = 0;
                    }
                    if (this.portraitLeft + this.rootView.getWidth() > this.parentRootView.getRight()) {
                        this.portraitLeft = this.parentRootView.getRight() - this.rootView.getWidth();
                    }
                    this.portraitTop += moveY;
                    if (this.portraitTop < 0) {
                        this.portraitTop = 0;
                    }
                    if (this.portraitTop + this.rootView.getHeight() > this.parentRootView.getBottom()) {
                        this.portraitTop = this.parentRootView.getBottom() - this.rootView.getHeight();
                    }
                    this.lastLeft = x;
                    this.lastTop = y;
                    this.onPipFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
                }
            }
        }
        return super.onTouch(v, event);
    }

    public static interface OnPipFullScreenSmallListener {
        public boolean isMove();

        public void onFullScreenSmallMoveTo(int var1, int var2);
    }
}

