/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.Random;

public class MarqueeView
extends RelativeLayout {
    private TextView mTextView;
    private int txtWidth;
    private int txtHeight;
    private ValueAnimator anim;
    private RelativeLayout.LayoutParams rightParams;
    private RelativeLayout.LayoutParams leftParams;
    private int mTopMargin;
    private float mSpeed = 1.0f;
    private String mText;

    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MarqueeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mTextView = new TextView(context);
        this.mTextView.setTextColor(-65536);
        this.mTextView.setTextSize((float)this.dp2px(context, 14.0f));
        this.mTextView.setSingleLine();
        this.addView((View)this.mTextView);
    }

    public void setTextColor(int color2) {
        this.mTextView.setTextColor(color2);
    }

    public void setTextSize(int size) {
        this.mTextView.setTextSize((float)size);
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    public void setText(String text) {
        this.setText(text, 100);
    }

    public void setText(String text, int maxCount) {
        if (!TextUtils.isEmpty((CharSequence)text) && text.length() > maxCount) {
            text = text.substring(0, maxCount);
        }
        this.mText = text;
        this.mTextView.setText((CharSequence)text);
        this.restartAnim();
    }

    private void getNewTopMargin() {
        this.mTopMargin = new Random().nextInt(this.getMeasuredHeight() - this.txtHeight);
    }

    private void measureTxt() {
        this.txtWidth = (int)this.mTextView.getPaint().measureText(this.mText);
        this.txtHeight = this.mTextView.getMeasuredHeight();
    }

    private long changeSpeedToDuration() {
        int animWidth = this.getMeasuredWidth() + this.txtWidth;
        long duration = 10000 * animWidth / this.dp2px(this.getContext(), 400.0f);
        duration = (long)((float)duration / this.mSpeed);
        return duration;
    }

    private void startAnim() {
        this.stopAnim();
        if (null == this.mTextView || TextUtils.isEmpty((CharSequence)this.mText)) {
            return;
        }
        this.anim = ValueAnimator.ofInt((int[])new int[]{0, this.getMeasuredWidth() + this.txtWidth});
        this.anim.setDuration(this.changeSpeedToDuration());
        this.anim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.anim.setRepeatCount(0);
        this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MarqueeView.this.updateTextView((Integer)animation.getAnimatedValue());
            }
        });
        this.anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                MarqueeView.this.changePosition();
                MarqueeView.this.startAnim();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.anim.start();
    }

    private void updateTextView(int value) {
        RelativeLayout.LayoutParams params;
        if (value >= this.getMeasuredWidth()) {
            params = this.leftParams;
            params.leftMargin = -(value - this.getMeasuredWidth());
        } else {
            params = this.rightParams;
            params.rightMargin = value - this.txtWidth;
        }
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void changePosition() {
        this.getNewTopMargin();
        this.rightParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightParams.addRule(11);
        this.rightParams.rightMargin = -this.txtWidth;
        this.rightParams.topMargin = this.mTopMargin;
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)this.rightParams);
        this.leftParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftParams.addRule(9);
        this.leftParams.leftMargin = 0;
        this.leftParams.topMargin = this.mTopMargin;
    }

    private void stopAnim() {
        if (null != this.anim) {
            this.anim.cancel();
            this.anim.removeAllUpdateListeners();
            this.anim.removeAllListeners();
            this.anim = null;
        }
    }

    private int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(scale * dpValue + 0.5f);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.restartAnim();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnim();
    }

    public void restartAnim() {
        this.stopAnim();
        if (null == this.mTextView || TextUtils.isEmpty((CharSequence)this.mText)) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                MarqueeView.this.measureTxt();
                MarqueeView.this.changePosition();
                MarqueeView.this.startAnim();
            }
        });
    }
}

