/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import com.gensee.chat.gif.GifDrawalbe;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.master.flame.danmaku.controller.DrawHandler;
import com.gensee.master.flame.danmaku.controller.IDanmakuView;
import com.gensee.master.flame.danmaku.danmaku.loader.ILoader;
import com.gensee.master.flame.danmaku.danmaku.loader.IllegalDataException;
import com.gensee.master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import com.gensee.master.flame.danmaku.danmaku.model.BaseDanmaku;
import com.gensee.master.flame.danmaku.danmaku.model.DanmakuTimer;
import com.gensee.master.flame.danmaku.danmaku.model.IDanmakus;
import com.gensee.master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import com.gensee.master.flame.danmaku.danmaku.model.android.DanmakuContext;
import com.gensee.master.flame.danmaku.danmaku.model.android.Danmakus;
import com.gensee.master.flame.danmaku.danmaku.model.android.SimpleTextCacheStuffer;
import com.gensee.master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import com.gensee.master.flame.danmaku.danmaku.parser.IDataSource;
import com.gensee.master.flame.danmaku.danmaku.parser.android.BiliDanmukuParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class Danmaku {
    private DanmakuContext mContext;
    private BaseDanmakuParser mParser;
    private IDanmakuView mDanmakuView;
    private Context context;
    private float pixelSizeFromDp16 = 0.0f;
    private float pixelSizeFromDp14 = 0.0f;
    private ExecutorService threadPool;
    private DanmakuRunnable danmakuRunnable;
    private OnShowDanmakuListener onShowDanmakuListener;
    private List<OnShowDanmakuListener> onShowDanmakuListenerList = new ArrayList<OnShowDanmakuListener>();
    private int configTextSize;
    private BaseCacheStuffer.Proxy mCacheStufferAdapter = new BaseCacheStuffer.Proxy(){

        public void prepareDrawing(BaseDanmaku danmaku, boolean fromWorkerThread) {
        }

        public void releaseResource(BaseDanmaku danmaku) {
            if (danmaku.text instanceof Spanned) {
                danmaku.text = "";
            }
        }
    };

    public void addOnShowDanmakuListener(OnShowDanmakuListener onShowDanmakuListener) {
        this.onShowDanmakuListenerList.add(onShowDanmakuListener);
    }

    public void setDanmakuTextSize(int size) {
        this.configTextSize = size;
    }

    public Danmaku(Context context, IDanmakuView danmakuView) {
        this.mDanmakuView = danmakuView;
        this.context = context;
        this.initDamaku();
    }

    private void initDamaku() {
        this.pixelSizeFromDp16 = GenseeUtils.dp2px(this.context, 16.0f);
        this.pixelSizeFromDp14 = GenseeUtils.dp2px(this.context, 14.0f);
        HashMap<Integer, Integer> maxLinesPair = new HashMap<Integer, Integer>();
        maxLinesPair.put(1, 5);
        HashMap<Integer, Boolean> overlappingEnablePair = new HashMap<Integer, Boolean>();
        overlappingEnablePair.put(1, true);
        overlappingEnablePair.put(5, true);
        this.mContext = DanmakuContext.create();
        this.mContext.setDanmakuStyle(2, new float[]{2.0f}).setDuplicateMergingEnabled(false).setScrollSpeedFactor(1.0f).setScaleTextSize(1.2f).setCacheStuffer((BaseCacheStuffer)new SimpleTextCacheStuffer(), this.mCacheStufferAdapter).setMaximumLines(maxLinesPair).preventOverlapping(overlappingEnablePair);
        if (this.mDanmakuView != null) {
            this.mParser = this.createParser(null);
            this.mDanmakuView.setCallback(new DrawHandler.Callback(){

                public void updateTimer(DanmakuTimer timer) {
                }

                public void drawingFinished() {
                }

                public void danmakuShown(BaseDanmaku danmaku) {
                }

                public void prepared() {
                    Danmaku.this.mDanmakuView.start();
                }
            });
            this.mDanmakuView.setOnDanmakuClickListener(new IDanmakuView.OnDanmakuClickListener(){

                public void onDanmakuClick(BaseDanmaku latest) {
                }

                public void onDanmakuClick(IDanmakus danmakus) {
                }
            });
            this.mDanmakuView.prepare(this.mParser, this.mContext);
            this.mDanmakuView.showFPS(false);
            this.mDanmakuView.enableDanmakuDrawingCache(true);
        }
    }

    public void addDanmaku(String msg, boolean isSelf, byte priority) {
        if (this.mDanmakuView.isPaused() || !this.mDanmakuView.isShown()) {
            return;
        }
        this.configAndAddDanmaku(msg, isSelf, priority);
    }

    private void configAndAddDanmaku(String msg, boolean isSelf, byte priority) {
        BaseDanmaku danmaku = this.mContext.mDanmakuFactory.createDanmaku(1);
        if (danmaku == null || this.mDanmakuView == null || TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (msg.startsWith("<span>") && msg.endsWith("</span>")) {
            msg = msg.substring(6, msg.length() - 7);
        }
        msg = Html.fromHtml((String)msg).toString();
        danmaku.text = msg;
        danmaku.padding = 5;
        danmaku.priority = priority;
        danmaku.isLive = false;
        danmaku.time = this.mDanmakuView.getCurrentTime() + 500L;
        danmaku.textSize = 0 == this.configTextSize ? this.pixelSizeFromDp14 : (float)this.configTextSize;
        danmaku.alpha = 204;
        danmaku.textColor = isSelf ? Color.parseColor((String)"#ff665d") : -1;
        danmaku.textShadowColor = -16777216;
        this.mDanmakuView.addDanmaku(danmaku);
    }

    private float getNowOrientationTextSize() {
        if (GenseeUtils.isLandscape(this.context)) {
            return this.pixelSizeFromDp16;
        }
        return this.pixelSizeFromDp14;
    }

    private SpannableStringBuilder createSpannable(Drawable drawable) {
        String text = "bitmap";
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)text);
        ImageSpan span = new ImageSpan(drawable);
        spannableStringBuilder.setSpan((Object)span, 0, text.length(), 17);
        spannableStringBuilder.append((CharSequence)"\u56fe\u6587\u6df7\u6392");
        spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(Color.parseColor((String)"#8A2233B1")), 0, spannableStringBuilder.length(), 18);
        return spannableStringBuilder;
    }

    private BaseDanmakuParser createParser(InputStream stream) {
        if (stream == null) {
            return new BaseDanmakuParser(){

                protected Danmakus parse() {
                    return new Danmakus();
                }
            };
        }
        ILoader loader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_BILI);
        try {
            loader.load(stream);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
        }
        BiliDanmukuParser parser = new BiliDanmukuParser();
        IDataSource dataSource = loader.getDataSource();
        parser.load(dataSource);
        return parser;
    }

    public void showDanmaku(boolean isShow, View lyDanmakuView) {
        if (null == this.mDanmakuView) {
            return;
        }
        if (isShow) {
            this.mDanmakuView.show();
        } else {
            this.mDanmakuView.hide();
        }
        PreferUtil.getIns().putBoolean("KEY_DANMAKU_IS_SHOW", isShow);
        for (OnShowDanmakuListener showDanmakuListener : this.onShowDanmakuListenerList) {
            showDanmakuListener.showDanmaku(isShow);
        }
        if (null != lyDanmakuView) {
            lyDanmakuView.setVisibility(isShow ? 0 : 8);
        }
    }

    public void changeDanmakuState(boolean isFullScreen, View lyDanmakuView) {
        boolean isDanmakuShown = PreferUtil.getIns().getBoolean("KEY_DANMAKU_IS_SHOW");
        if (isFullScreen && isDanmakuShown) {
            this.mDanmakuView.show();
            lyDanmakuView.setVisibility(0);
        } else {
            this.mDanmakuView.hide();
            lyDanmakuView.setVisibility(8);
        }
    }

    public static interface OnShowDanmakuListener {
        public void showDanmaku(boolean var1);
    }

    private class MyUIUpdateLis
    implements GifDrawalbe.UpdateUIListen {
        private BaseDanmaku danmaku;

        public MyUIUpdateLis(BaseDanmaku danmaku2) {
            this.danmaku = danmaku2;
        }

        public void updateUI() {
            Danmaku.this.mDanmakuView.invalidateDanmaku(this.danmaku, false);
        }
    }

    private class DanmakuRunnable
    implements Runnable {
        protected String msg;
        protected boolean isSelf;
        protected byte priority;

        public DanmakuRunnable(String msg, boolean isSelf, byte priority) {
            this.msg = msg;
            this.isSelf = isSelf;
            this.priority = priority;
        }

        @Override
        public void run() {
            Danmaku.this.configAndAddDanmaku(this.msg, this.isSelf, this.priority);
        }
    }
}

