/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.util.ResManager;

public class CustomCloseBtnDialog
extends Dialog {
    public CustomCloseBtnDialog(Context context, int theme) {
        super(context, theme);
    }

    public CustomCloseBtnDialog(Context context) {
        super(context);
    }

    public static class Builder {
        protected Context context;
        private String title;
        private String message;
        private String message2;
        private String positiveButtonText;
        private String negativeButtonText;
        private View contentView;
        private boolean isShowCloseBtn;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;
        private View layout;
        private TextView tvMsg;
        private TextView tvMsg2;

        public void setDialogMsg(CharSequence text) {
            this.tvMsg.setText(text);
        }

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(int message) {
            this.message = (String)this.context.getText(message);
            return this;
        }

        public Builder setMessage2(String message) {
            this.message2 = message;
            return this;
        }

        public Builder setMessage2(int message) {
            this.message2 = (String)this.context.getText(message);
            return this;
        }

        public Builder setTitle(int title) {
            this.title = (String)this.context.getText(title);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        public Builder setIsShowCloseBtn(boolean isShowCloseBtn) {
            this.isShowCloseBtn = isShowCloseBtn;
            return this;
        }

        public Builder setPositiveButton(int positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = (String)this.context.getText(positiveButtonText);
            this.positiveButtonClickListener = listener;
            return this;
        }

        public Builder setPositiveButton(String positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = listener;
            return this;
        }

        public void setPositiveButtonText(String text) {
            if (null == this.layout) {
                return;
            }
            ((Button)this.layout.findViewById(ResManager.getId("gs_positiveButton"))).setText((CharSequence)text);
        }

        public void setPositiveButtonTextColor(int color2) {
            if (null == this.layout) {
                return;
            }
            ((Button)this.layout.findViewById(ResManager.getId("gs_positiveButton"))).setTextColor(color2);
        }

        public void setPositiveButtonEnable(boolean enable) {
            if (null == this.layout) {
                return;
            }
            ((Button)this.layout.findViewById(ResManager.getId("gs_positiveButton"))).setClickable(enable);
        }

        public void setNegativeButtonTextColor(int color2) {
            if (null == this.layout) {
                return;
            }
            ((Button)this.layout.findViewById(ResManager.getId("gs_negativeButton"))).setTextColor(color2);
        }

        public Builder setNegativeButton(String negativeButtonText, DialogInterface.OnClickListener listener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = listener;
            return this;
        }

        public CustomCloseBtnDialog create() {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            this.layout = inflater.inflate(ResManager.getLayoutId("fs_gs_dialog_with_close_btn"), null);
            CustomCloseBtnDialog dialog = new CustomCloseBtnDialog(this.context, ResManager.getStyleId("fs_gs_dialog"));
            dialog.addContentView(this.layout, new ViewGroup.LayoutParams(-1, -2));
            return this.create(this.layout, dialog);
        }

        public CustomCloseBtnDialog create(View layout, CustomCloseBtnDialog mDialog) {
            final CustomCloseBtnDialog dialog = mDialog;
            if (this.title != null) {
                ((TextView)layout.findViewById(ResManager.getId("gs_title"))).setText((CharSequence)this.title);
            } else {
                layout.findViewById(ResManager.getId("gs_title")).setVisibility(8);
                layout.findViewById(ResManager.getId("gs_iv_top")).setVisibility(8);
            }
            layout.findViewById(ResManager.getId("gs_iv_close_dialog")).setVisibility(this.isShowCloseBtn ? 0 : 8);
            layout.findViewById(ResManager.getId("gs_iv_close_dialog")).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            if (this.positiveButtonText != null) {
                ((Button)layout.findViewById(ResManager.getId("gs_positiveButton"))).setText((CharSequence)this.positiveButtonText);
                ((Button)layout.findViewById(ResManager.getId("gs_positiveButton"))).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (Builder.this.positiveButtonClickListener != null) {
                            Builder.this.positiveButtonClickListener.onClick((DialogInterface)dialog, -1);
                        }
                        dialog.dismiss();
                    }
                });
            } else {
                layout.findViewById(ResManager.getId("gs_positiveButton")).setVisibility(8);
            }
            if (this.negativeButtonText != null) {
                ((Button)layout.findViewById(ResManager.getId("gs_negativeButton"))).setText((CharSequence)this.negativeButtonText);
                ((Button)layout.findViewById(ResManager.getId("gs_negativeButton"))).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (Builder.this.negativeButtonClickListener != null) {
                            Builder.this.negativeButtonClickListener.onClick((DialogInterface)dialog, -2);
                        }
                        dialog.dismiss();
                    }
                });
            } else {
                layout.findViewById(ResManager.getId("gs_negativeButton")).setVisibility(8);
            }
            if (null == this.positiveButtonText || null == this.negativeButtonText) {
                layout.findViewById(ResManager.getId("gs_iv_bottom_center")).setVisibility(8);
            }
            if (this.message != null) {
                this.tvMsg = (TextView)layout.findViewById(ResManager.getId("gs_message"));
                this.tvMsg.setText((CharSequence)this.message);
            } else {
                layout.findViewById(ResManager.getId("gs_message")).setVisibility(8);
            }
            if (this.message2 != null) {
                this.tvMsg2 = (TextView)layout.findViewById(ResManager.getId("gs_message_2"));
                this.tvMsg2.setText((CharSequence)this.message2);
            } else {
                layout.findViewById(ResManager.getId("gs_message_2")).setVisibility(8);
            }
            if (this.contentView != null) {
                ((LinearLayout)layout.findViewById(ResManager.getId("gs_content"))).removeAllViews();
                ((LinearLayout)layout.findViewById(ResManager.getId("gs_content"))).addView(this.contentView, new ViewGroup.LayoutParams(-2, -2));
            }
            dialog.setContentView(layout);
            return dialog;
        }
    }
}

