/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.ui.holder.ReceiverLocalVideoHolder;
import com.gensee.fastsdk.ui.holder.small.SmallHolder;
import com.gensee.fastsdk.ui.holder.small.SmallVideoViewTouchHolder;
import com.gensee.fastsdk.ui.holder.vdbar.ReceiverVDBarHolder;
import com.gensee.fastsdk.ui.holder.video.AbstractLiveVideoHolder;
import com.gensee.fastsdk.ui.holder.video.VideoViewTouchHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.media.IVideoIndication;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSAudoDecodeViewEx;
import com.gensee.view.GSTVideoView;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReceiverLiveVideoHolder
extends AbstractLiveVideoHolder
implements VideoViewTouchHolder.OnVideoViewTouchListener,
PlayerLive.OnLocalVideoListener,
ReceiverVDBarHolder.OnVdBarListener,
PlayerLive.OnAudioVideoListener,
SmallHolder.OnSmallHolderListener,
SmallVideoViewTouchHolder.OnSmallFullScreenSmallListener {
    protected static final String TAG = "ReceiverLiveVideoHolder";
    private IVideoIndication mVideoView;
    private View txtVideoDef;
    private ReceiverLocalVideoHolder receiverLocalVideoHolder;
    private RelativeLayout rlActived;
    private AtomicBoolean bResume = new AtomicBoolean(false);
    private RelativeLayout mRlAllVideoView;
    private ReceiverVDBarHolder mVdBarHolder;
    private boolean bReceiverAudioNotify = false;
    private boolean bReceiverVideoNotify = false;
    private boolean bReceiverAvCaching = false;
    private ImageView imgAudioDefView;
    private View defView;
    private View mPauseView;
    private View livePauseTv;
    private View llHaveNoVideo;
    private boolean bVideoSwitchClicke;
    private boolean isShowLoadingView;
    private SmallVideoViewTouchHolder mVideoViewTouchHolder;
    private SmallHolder mSmallHolder;
    private boolean bFullScreenDisplay = false;

    public ReceiverLiveVideoHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.mRlAllVideoView = (RelativeLayout)this.findViewById(ResManager.getId("rlVideoView"));
        GSTVideoView videoEx = (GSTVideoView)this.findViewById(ResManager.getId("videoView"));
        GSAudoDecodeViewEx hardDecodeVideoEx = (GSAudoDecodeViewEx)this.findViewById(ResManager.getId("gsHardDecodeViewEx"));
        GSFastConfig config = PlayerLive.getIns().getGsFastConfig();
        if (null != config && config.isHardDecode()) {
            videoEx.setVisibility(8);
            hardDecodeVideoEx.setVisibility(0);
            this.mVideoView = hardDecodeVideoEx;
        } else {
            videoEx.setVisibility(0);
            hardDecodeVideoEx.setVisibility(8);
            this.mVideoView = videoEx;
        }
        ((BaseWatchActivity)this.getContext()).setVideoView(this.mVideoView);
        this.txtVideoDef = this.findViewById(ResManager.getId("txtVideoDef"));
        this.mRlAllVideoView.setLongClickable(true);
        this.showVideoDefTxt(false);
        this.mVideoViewTouchHolder = new SmallVideoViewTouchHolder(this.rootView, value);
        this.mVideoViewTouchHolder.setOnVideoViewTouchListener(this);
        this.mVideoViewTouchHolder.setOnSmallFullScreenSmallListener(this);
        this.mRlAllVideoView.setOnTouchListener((View.OnTouchListener)this.mVideoViewTouchHolder);
        this.mVdBarHolder = new ReceiverVDBarHolder(this.getRootView(), null);
        this.mVdBarHolder.setOnVdBarListener(this);
        this.rlActived = (RelativeLayout)this.findViewById(ResManager.getId("actived_rl"));
        PlayerLive.getIns().setOnLocalVideoListener(this);
        this.imgAudioDefView = (ImageView)this.findViewById(ResManager.getId("ivAudioDef"));
        this.imgAudioDefView.setSelected(false);
        this.defView = this.findViewById(ResManager.getId("relDef"));
        PlayerLive.getIns().setOnAudioVideoListener(this);
        this.mPauseView = this.findViewById(ResManager.getId("live_pause_ly"));
        this.livePauseTv = this.findViewById(ResManager.getId("live_pause_tv"));
        this.llHaveNoVideo = this.findViewById(ResManager.getId("ll_have_no_video"));
        PreferUtil.getIns().putBoolean("KEY_VIDEO_CLOSED", false);
        this.mSmallHolder = new SmallHolder(this.rootView, null);
        this.mSmallHolder.setOnSmallHolderListener(this);
        this.mVideoViewTouchHolder.setOnSmallViewEventListener(this.mSmallHolder);
    }

    public boolean isReceiverVideoNotify() {
        return this.bReceiverVideoNotify;
    }

    public void setBottomAndLeftMargin(int bottomMargin, int leftMargin) {
        this.receiverLocalVideoHolder.setBottomAndLeftMargin(bottomMargin, leftMargin);
    }

    public void renderDefault() {
        this.mVideoView.renderDefault();
    }

    private void setImgAudoiDefViewSelect(boolean bSelect) {
        this.imgAudioDefView.setSelected(bSelect);
    }

    @Override
    public void layout(RelativeLayout.LayoutParams p) {
        super.layout(p);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.showVideoView(true);
            }
        }, 50L);
    }

    @Override
    public IVideoIndication getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void onOpenSmall() {
        IVDClickListener mListener = this.mVdBarHolder.getListener();
        mListener.onFullScreenVDClick(2, true);
    }

    @Override
    public void onCloseSamll() {
        IVDClickListener mListener = this.mVdBarHolder.getListener();
        mListener.onFullScreenVDClick(1, false);
    }

    @Override
    public void onSwitchSmall() {
        this.mVdBarHolder.getListener().onFullContentSwitch(1);
    }

    public void initSmallPosition() {
        if (null != this.mVideoViewTouchHolder) {
            this.mVideoViewTouchHolder.initPosition();
        }
    }

    public int getPortraitLeft() {
        return this.mVideoViewTouchHolder.getPortraitLeft();
    }

    public int getPortraitTop() {
        return this.mVideoViewTouchHolder.getPortraitTop();
    }

    public void setPortraitLeftAndTop(int left, int top) {
        this.mVideoViewTouchHolder.setPortraitLeftAndTop(left, top);
    }

    private void processSmallAndEffectPosition() {
        int videoViewIndex;
        View docView;
        RelativeLayout parent;
        int docViewIndex;
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        if ((uimode & 1) == 1 && (uimode & 2) != 2) {
            return;
        }
        if (null != this.rootView.getParent() && (docViewIndex = (parent = (RelativeLayout)this.rootView.getParent()).indexOfChild(docView = parent.findViewById(ResManager.getId("docLayout")))) <= (videoViewIndex = parent.indexOfChild(this.rootView))) {
            parent.removeView(docView);
            parent.addView(docView, videoViewIndex);
        }
    }

    public void onFullScreenSmallView(boolean bOpen) {
        if (bOpen) {
            this.show(true);
            this.positionSmallVideoView();
            this.mSmallHolder.setRlScreenRightVisibility(true);
            this.setImgOpenSmallVisible(false);
        } else {
            this.show(false);
            this.mSmallHolder.setRlScreenRightVisibility(false);
        }
        ((LiveActivity)this.getContext()).videoNetDisconnectVisible(bOpen);
    }

    private void positionSmallVideoView() {
        int nViewWidth = GenseeUtils.getWidth3to10Rate(this.getContext());
        int nViewHeight = nViewWidth * 9 / 16;
        RelativeLayout.LayoutParams mNormalLayoutParam = new RelativeLayout.LayoutParams(-2, -2);
        mNormalLayoutParam.width = nViewWidth;
        mNormalLayoutParam.height = nViewHeight;
        mNormalLayoutParam.topMargin = this.mVideoViewTouchHolder.getPortraitTop();
        mNormalLayoutParam.leftMargin = this.mVideoViewTouchHolder.getPortraitLeft();
        this.layout(mNormalLayoutParam);
    }

    @Override
    public boolean isMove() {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        return (uiMode & 1) == 1 && (uiMode & 2) != 2;
    }

    @Override
    public void onFullScreenSmallMoveTo(int left, int top) {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        if ((uiMode & 2) != 2 && (uiMode & 8) == 8) {
            RelativeLayout.LayoutParams mNormalLayoutParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
            mNormalLayoutParam.leftMargin = left;
            mNormalLayoutParam.topMargin = top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)mNormalLayoutParam);
        }
    }

    private void processSmallVideoViewSwitch() {
    }

    @Override
    public void showFullScreen() {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.showVideoView(true);
        this.mVdBarHolder.selectImgFullScreen(true);
        this.setImgOpenDocStatus();
        this.processSmallAndEffectPosition();
    }

    @Override
    public void showNormalScreen() {
        this.setImgOpenDocStatus();
        this.mSmallHolder.setRlScreenRightVisibility(false);
        this.processSmallVideoViewSwitch();
    }

    private void setImgOpenDocStatus() {
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        boolean bVisible = (uimode & 1) == 1 && (uimode & 8) != 8;
        this.setImgOpenSmallVisible(bVisible);
    }

    public void setImgOpenSmallVisible(boolean bVisible) {
        this.mSmallHolder.setImgOpenVisibility(bVisible && PlayerLive.getIns().isShowPIP() && PlayerLive.getIns().isShowDoc());
        if (bVisible) {
            this.continueShowBtn();
            this.delayDismissFloatBtns();
        }
    }

    @Override
    public void show(boolean isShow) {
        GenseeLog.d((String)TAG, (String)("show isShow = " + isShow));
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        isShow = isShow || (uiMode & 1) == 1 && (uiMode & 8) == 8;
        super.show(isShow);
        this.showVideoView(isShow);
    }

    private void showVideoDefTxt(boolean isShow) {
        this.txtVideoDef.setVisibility(8);
    }

    @Override
    public void onHandClick() {
    }

    @Override
    public void onRewardClick() {
    }

    @Override
    public void onShowFloatTitle(int visibility) {
        if (null != this.mVdBarHolder && null != this.mVdBarHolder.getListener()) {
            this.mVdBarHolder.getListener().onFloatBtnShow(1, visibility);
        }
    }

    @Override
    public void onShowInputDialog() {
        ((LiveActivity)this.getContext()).showInputDialog();
    }

    @Override
    public void onRoomJoinSuccess() {
        this.showVideoDefTxt(true);
        this.setReceiverLocalTextureVideoView();
        this.switchVideoView(false);
        this._processHaveAudioOpen();
    }

    @Override
    public void onRoomReconnect() {
        this.showVideoDefTxt(false);
        this.showVideoSwitchBtn(false);
        this.bReceiverAudioNotify = false;
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    public void onVideoStart() {
        this.showVideoView(true);
        this.renderDefault();
        this.showDefView(false);
        this._processHaveAudioOpen();
    }

    public void onVideoEnd() {
        this.bReceiverVideoNotify = false;
        this.showDefView(true);
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    private void showDefView(boolean isShow) {
        this.defView.setVisibility(isShow ? 0 : 4);
    }

    @Override
    public void onMicOpen() {
    }

    private void switchVideoView(boolean bVisible) {
        this.showVideoView(!bVisible);
    }

    private void showVideoView(boolean bVisible) {
        boolean bCurVisible = bVisible;
        this.mRlAllVideoView.setVisibility(bCurVisible ? 0 : 8);
        if (this.mRlAllVideoView.getVisibility() == 0) {
            ViewGroup.LayoutParams vl = this.mRlAllVideoView.getLayoutParams();
            vl.width = this.rootView.getLayoutParams().width;
            vl.height = this.rootView.getLayoutParams().height;
            this.mRlAllVideoView.setLayoutParams(vl);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        if (null != this.receiverLocalVideoHolder) {
            this.receiverLocalVideoHolder.setOrientation(orientation);
        }
        if (null != this.mVideoViewTouchHolder) {
            this.mVideoViewTouchHolder.setOrientation(orientation);
        }
        this.show(this.rootView.getVisibility() == 0);
    }

    @Override
    public void onResume() {
        this.bResume.set(true);
        if (PlayerLive.getIns().isVideoCameraOpen()) {
            this.activedSelf(false);
        } else {
            this.receiverLocalVideoHolder.restoreView();
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.receiverLocalVideoHolder.getRootView().getLayoutParams();
            lp.width = 1;
            lp.height = 1;
            this.receiverLocalVideoHolder.getRootView().setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.bReceiverAudioNotify = false;
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    public void activedSelf(boolean bSelfActived) {
        if (null != this.receiverLocalVideoHolder) {
            if (!this.bResume.get()) {
                return;
            }
            if (PlayerLive.getIns().isVideoCameraOpen()) {
                this.receiverLocalVideoHolder.show(true);
            }
            this.rlActived.removeView(this.receiverLocalVideoHolder.getRootView());
            this.receiverLocalVideoHolder.restoreView();
        }
    }

    @Override
    public void onStop() {
        this.bResume.set(false);
        this.rlActived.removeAllViews();
        this.receiverLocalVideoHolder.removeView();
    }

    @Override
    public void onDestroy() {
        if (null != this.receiverLocalVideoHolder.getlocalTextureVideoView()) {
            // empty if block
        }
    }

    public void setReceiverLocalVideoHolder(ReceiverLocalVideoHolder receiverLocalVideoHolder) {
        this.receiverLocalVideoHolder = receiverLocalVideoHolder;
    }

    private void setReceiverLocalTextureVideoView() {
        PlayerLive.getIns().setLocalTextureVideoView(null);
        if (null != this.receiverLocalVideoHolder) {
            this.receiverLocalVideoHolder.setLocalTextureVideoView();
        }
    }

    @Override
    public void onLocalVideoOpen() {
        if (!this.bResume.get()) {
            return;
        }
        this.receiverLocalVideoHolder.onVideoOpen();
    }

    @Override
    public void onLocalVideoClose() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.receiverLocalVideoHolder.initDefaultPosition();
            }
        });
        if (!this.bResume.get()) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.receiverLocalVideoHolder.show(false);
            }
        });
    }

    public void initReceiverLocalPosition() {
        this.receiverLocalVideoHolder.initDefaultPosition();
    }

    @Override
    public void showVideoFloatBtn(int nValue) {
        this.mVdBarHolder.showVideoFloatBtn(nValue);
    }

    public void setFloatBottomBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatBottomBtnsVisible(isShow);
    }

    public void setFloatRightBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatRightBtnsVisible(isShow);
    }

    @Override
    public void dismisssFloatBtns() {
        this.mVdBarHolder.dismisssFloatBtns();
        this.mSmallHolder.dismisssOpenSmallFloatBtns();
    }

    private void showVideoSwitchBtn(boolean bVisible) {
    }

    @Override
    public void setVDListener(IVDClickListener listener) {
        this.mVdBarHolder.setVDListener(listener);
    }

    @Override
    public void delayDismissFloatBtns() {
        this.mVdBarHolder.delayDismissFloatBtns();
        this.mSmallHolder.delayOpenSmallDismissFloatBtns();
    }

    @Override
    public void continueShowBtn() {
        this.mVdBarHolder.continueShowBtn();
        this.mSmallHolder.continueOpenSmallShowBtn();
    }

    @Override
    public void delayDismissFloatBottomBtns() {
        this.mVdBarHolder.delayDismissFloatBottomBtns();
    }

    @Override
    public void continueShowBottomBtns() {
        this.mVdBarHolder.continueShowBottomBtns();
    }

    @Override
    public void dismissOwnBtn() {
        this.mVdBarHolder.dismissOwnBtn();
        this.mSmallHolder.dismissOpenSmallOwnBtn();
    }

    @Override
    public void setImageHandVisible(boolean bVisible) {
        this.mVdBarHolder.setImageHandVisible(bVisible);
    }

    public void showRewardBtn(boolean isShow) {
        this.mVdBarHolder.showRewardBtn(isShow);
    }

    @Override
    public void updateHand(String sVaule, boolean bValue) {
        this.mVdBarHolder.updateHand(sVaule, bValue);
    }

    @Override
    public boolean isTouch() {
        if (this.mVdBarHolder.getListener() == null) {
            return false;
        }
        int uimode = this.mVdBarHolder.getListener().getUIMode();
        if ((uimode & 1) != 1) {
            return false;
        }
        return (uimode & 2) == 2;
    }

    @Override
    public void onVideoViewSingleClick() {
        this.mVdBarHolder.showFloatBtns();
        this.mSmallHolder.showOpenSmallFloatBtns();
    }

    @Override
    public void onVideoViewDoubleClick() {
        long nCurrentTime = Calendar.getInstance().getTimeInMillis();
        long l = nCurrentTime - this.mVdBarHolder.nLastTime;
        this.mVdBarHolder.getClass();
        if (l >= 500L) {
            this.onSwitchToFullScreen();
            this.mVdBarHolder.nLastTime = nCurrentTime;
        }
    }

    private void processLoadingView(boolean bTrue) {
        this.isShowLoadingView = bTrue;
        this.mVdBarHolder.showDefView(bTrue);
        ((LiveActivity)this.getContext()).showLinLoadPbView(bTrue);
    }

    public void processLoadingViewStatus(boolean bTrue) {
        this.isShowLoadingView = false;
        this.processHaveNoVideo();
    }

    @Override
    public void onSwitchToFullScreen() {
        this.mVdBarHolder.getListener().onSwitchToFull(1);
    }

    private boolean isIFrame(byte[] data) {
        int frameType = data[4] & 0x1F;
        return frameType == 7 || frameType == 8;
    }

    @Override
    public void onSelectCloseVideo(View v) {
        GenseeLog.i((String)TAG, (String)"CloseVideo button onClick");
        if (v.isSelected()) {
            v.setSelected(false);
            PlayerLive.getIns().setVideoClose(false);
        } else {
            v.setSelected(true);
            PlayerLive.getIns().setVideoClose(true);
        }
        PreferUtil.getIns().putBoolean("KEY_VIDEO_CLOSED", v.isSelected());
        this.processHaveNoVideo();
    }

    private void _processHaveAudioOpen() {
        this.processHaveNoVideo();
        boolean isNoNet = ((LiveActivity)this.getContext()).isNoNet();
        if (isNoNet) {
            return;
        }
        if (((LiveActivity)this.getContext()).getLiveStatus() == 2) {
            this.bReceiverVideoNotify = false;
            this.bReceiverVideoNotify = false;
            this.mPauseView.setVisibility(0);
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(false);
            return;
        }
        this.mPauseView.setVisibility(8);
        if (!this.bResume.get()) {
            this.processLoadingView(true);
            this.mVdBarHolder.showAudioDefView(false);
            return;
        }
        if (this.bReceiverAudioNotify && !this.bReceiverVideoNotify) {
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(true);
        } else if (!this.bReceiverVideoNotify && !this.bReceiverAudioNotify) {
            this.processLoadingView(true);
            this.mVdBarHolder.showAudioDefView(false);
        } else {
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(false);
        }
    }

    public void processHaveNoVideo() {
        boolean isVideoClose = PreferUtil.getIns().getBoolean("KEY_VIDEO_CLOSED");
        if (PlayerLive.getIns().getLiveStatus() == 3 && !this.isShowLoadingView) {
            this.llHaveNoVideo.setVisibility(isVideoClose ? 0 : 8);
        } else {
            this.llHaveNoVideo.setVisibility(8);
        }
    }

    private void processHaveAudioOpen() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this._processHaveAudioOpen();
            }
        });
    }

    @Override
    public void onReceiverAudio() {
        if (!this.bReceiverAudioNotify) {
            GenseeLog.d((String)TAG, (String)(" onReceiverAudio bReceiverAudioNotify = " + this.bReceiverAudioNotify));
            this.bReceiverAudioNotify = true;
            this.processHaveAudioOpen();
        }
    }

    @Override
    public void onReceiverVideo() {
        if (!this.bReceiverVideoNotify && !this.bReceiverAvCaching) {
            GenseeLog.d((String)TAG, (String)(" onReceiverVideo bReceiverVideoNotify = " + this.bReceiverVideoNotify));
            this.bReceiverVideoNotify = true;
            this.processHaveAudioOpen();
        }
    }

    @Override
    public void onCaching(boolean isCaching) {
        GenseeLog.d((String)TAG, (String)(" onCaching isCaching = " + isCaching));
        if (isCaching) {
            this.bReceiverVideoNotify = false;
            this.bReceiverAudioNotify = false;
        }
        this.bReceiverAvCaching = isCaching;
        this.processHaveAudioOpen();
    }

    public void updateStatus(int status) {
        this.setImgAudoiDefViewSelect(status != 0);
        this._processHaveAudioOpen();
    }

    @Override
    public void onSaveInstence(Bundle outState) {
        super.onSaveInstence(outState);
        this.mVideoViewTouchHolder.onSaveInstence(outState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (null != this.mVideoViewTouchHolder) {
            this.mVideoViewTouchHolder.layoutRestore(savedInstanceState);
        }
    }

    public void onClick(View view) {
    }
}

