/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.vdbar;

import android.view.View;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.util.AnimationUtils;
import com.gensee.fastsdk.util.ResManager;
import java.util.Calendar;

public abstract class VDBarHolder
extends BaseHolder {
    public long nLastTime = Calendar.getInstance().getTimeInMillis();
    public final int DOUBLE_CLICK_TIME_INTERVAL = 500;
    protected View rightBar;
    protected View bottomBar;
    private Runnable disFloatBtnRun;
    protected IVDClickListener listener;

    public VDBarHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initComp(Object value) {
        this.rightBar = this.findViewById(ResManager.getId("ll_float_right_bar"));
    }

    public void setVDListener(IVDClickListener l) {
        this.listener = l;
    }

    public void showFloatBtns() {
        this.initDismissRunnable();
        this.removeCallbacks(this.disFloatBtnRun);
        if (this.rightBar.getVisibility() == 0 || null != this.bottomBar && this.bottomBar.getVisibility() == 0) {
            this.dismisssFloatBtns();
            this.onShowFloatBottom(8);
        } else {
            this.showFloat();
            this.postDelayed(this.disFloatBtnRun, 3000L);
        }
    }

    public void continueShowBtn() {
        this.initDismissRunnable();
        this.removeCallbacks(this.disFloatBtnRun);
        this.showFloat();
    }

    public void continueShowBottomBtns() {
    }

    protected void showFloat() {
        boolean isFullScreen;
        boolean bl = isFullScreen = (((LiveActivity)this.getContext()).getUIMode() & 1) == 1;
        if (this.rightBar.getVisibility() != 0 && isFullScreen) {
            this.rightBar.setVisibility(0);
            if (this.rightBar.getWidth() > 0) {
                AnimationUtils.enterRight2Left(this.rightBar);
            }
        }
        this.onShowFloatTitle(0);
    }

    public void delayDismissFloatBtns() {
        this.initDismissRunnable();
        this.removeCallbacks(this.disFloatBtnRun);
        this.postDelayed(this.disFloatBtnRun, 3000L);
    }

    public void delayDismissFloatBottomBtns() {
    }

    public void setFloatBottomBtnsVisible(boolean isShow) {
        this.bottomBar.setVisibility(isShow ? 0 : 8);
    }

    public void setFloatRightBtnsVisible(boolean isShow) {
        this.rightBar.setVisibility(isShow ? 0 : 8);
    }

    public void showFloatBottomBtns() {
        if (null != this.bottomBar && this.bottomBar.getVisibility() != 0) {
            this.bottomBar.setVisibility(0);
            if (this.bottomBar.getWidth() > 0) {
                AnimationUtils.fromBottomToUp(this.bottomBar);
            }
        }
    }

    public void dismisssFloatBtns() {
        if (this.rightBar.getVisibility() != 8) {
            if (this.rightBar.getWidth() > 0) {
                AnimationUtils.enterLeft2Right(this.rightBar);
            } else {
                this.rightBar.setVisibility(8);
            }
        }
        this.onShowFloatTitle(8);
    }

    public void dismissOwnBtn() {
        this.removeCallbacks(this.disFloatBtnRun);
        this.rightBar.setVisibility(8);
    }

    private void initDismissRunnable() {
        if (this.disFloatBtnRun == null) {
            this.disFloatBtnRun = new Runnable(){

                @Override
                public void run() {
                    VDBarHolder.this.dismisssFloatBtns();
                }
            };
        }
    }

    public void removeRunnable() {
        this.removeCallbacks(this.disFloatBtnRun);
    }

    public IVDClickListener getListener() {
        return this.listener;
    }

    protected abstract void onShowFloatTitle(int var1);

    protected abstract void onShowFloatBottom(int var1);
}

