/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.topfloat;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.utils.GenseeLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class TopFloatHolder
extends BaseHolder {
    public static final int UI_FULLSCREEN = 1;
    public static final int UI_FULLSCREEN_SHOW_VIDEO = 2;
    public static final int UI_NORSCREEN_TOP_VIDEO = 4;
    public static final int UI_FULLSCREEN_SHOW_SMALL_VIEW = 8;
    private static final String UI_MODE_KEY = "ui.mode.key";
    protected int uimode = 0;
    private RelativeLayout.LayoutParams topFloatParam;
    private RelativeLayout.LayoutParams fullParam;
    private OrientationEventListener mOrientationListener;
    public static final int OREITATION_PORTRAIT = 1;
    public static final int OREITATION_LANDSCAPE = 0;
    protected int mCurrentOrient = -1;
    protected boolean bEnable = false;

    public TopFloatHolder(View rootView, Object value) {
        super(rootView, value);
        this.startOrientation(this.getContext());
    }

    @Override
    protected void initData(Object value) {
    }

    public void onClick(View v) {
    }

    public void setRequestedOrientation(int orientation) {
        if ((this.uimode & 1) != 1) {
            return;
        }
        if (orientation == 1) {
            ((Activity)this.getContext()).setRequestedOrientation(1);
        } else {
            ((Activity)this.getContext()).setRequestedOrientation(0);
        }
    }

    @Override
    public void layout(Bundle savedInstanceState) {
        this.uimode = savedInstanceState == null ? (this.uimode |= 4) : savedInstanceState.getInt(UI_MODE_KEY, 0);
        if ((this.uimode & 1) == 1) {
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.getFullParam());
        } else {
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.getTopLayoutParam());
        }
        GenseeLog.i((String)("TopFloatHolder layout uimode = " + this.uimode));
    }

    public void updateUIMode(int uiMode, boolean isAdd) {
        this.uimode = isAdd ? this.uimode | uiMode : this.uimode & ~uiMode;
    }

    public int getUIMode() {
        return this.uimode;
    }

    public RelativeLayout.LayoutParams getTopLayoutParam() {
        if (this.topFloatParam == null) {
            this.topFloatParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
            this.topFloatParam.width = this.getContext().getResources().getDisplayMetrics().widthPixels;
            int modWidth = this.topFloatParam.width % 16;
            if (modWidth > 0) {
                this.topFloatParam.width += 16 - modWidth;
                this.topFloatParam.leftMargin = -(16 - modWidth) / 2;
                this.topFloatParam.rightMargin = -(16 - modWidth) / 2;
            }
            this.topFloatParam.height = this.topFloatParam.width * 9 / 16;
        }
        GenseeLog.i((String)("create getTopLayoutParam = " + this.topFloatParam.width + " : " + this.topFloatParam.height));
        return this.topFloatParam;
    }

    public RelativeLayout.LayoutParams getFullParam() {
        DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
        if (this.fullParam == null) {
            this.fullParam = new RelativeLayout.LayoutParams(dm.widthPixels, dm.heightPixels);
        } else {
            this.fullParam.width = dm.widthPixels;
            this.fullParam.height = dm.heightPixels;
        }
        GenseeLog.i((String)("create getFullParam = " + this.fullParam.width + " : " + this.fullParam.height));
        return this.fullParam;
    }

    @Override
    public void onSaveInstence(Bundle outState) {
        super.onSaveInstence(outState);
        outState.putInt(UI_MODE_KEY, this.uimode);
    }

    public abstract void layoutRestore();

    public abstract void showFullScreen(boolean var1);

    public static String timeStamp2Date(long seconds, String format, String gmt) {
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (gmt != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(gmt));
        }
        String a = sdf.format(new Date(seconds));
        return sdf.format(new Date(seconds));
    }

    protected void startOrientation(Context context) {
        this.stopOrientation();
        this.mOrientationListener = new OrientationEventListener(context){

            public void onOrientationChanged(int rotation) {
                if (!TopFloatHolder.this.bEnable) {
                    return;
                }
                if (rotation >= 0 && rotation <= 45 || rotation >= 315 || rotation >= 135 && rotation <= 225) {
                    TopFloatHolder.this.processSmallOrientation();
                } else if (rotation > 45 && rotation < 135 || rotation > 225 && rotation < 315) {
                    TopFloatHolder.this.processBigOrientation();
                }
            }
        };
        this.bEnable = true;
        this.mOrientationListener.enable();
    }

    protected void processSmallOrientation() {
        if (this.mCurrentOrient != 1) {
            this.mCurrentOrient = 1;
            this.setRequestedOrientation(1);
        }
    }

    protected void processBigOrientation() {
        if (this.mCurrentOrient != 0) {
            this.mCurrentOrient = 0;
            this.setRequestedOrientation(0);
        }
    }

    protected void stopOrientation() {
        if (null == this.mOrientationListener) {
            return;
        }
        this.bEnable = false;
        this.mOrientationListener.disable();
        this.mCurrentOrient = -1;
        this.mOrientationListener = null;
    }

    public void onDestroy() {
        this.stopOrientation();
    }
}

