/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.topfloat;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.gensee.fastsdk.ui.holder.topfloat.TopFloatHolder;
import com.gensee.fastsdk.util.ResManager;

public abstract class AbstractViewTopFloatHolder
extends TopFloatHolder {
    private BroadcastReceiver powerReceiver;
    protected ImageView imgBack;
    protected ImageView imgPower;
    protected ImageView imgMore;
    protected TextView txtTitle;
    protected TextView txtPower;
    protected View titleBar;
    protected View linPower;

    public AbstractViewTopFloatHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public IntentFilter getPowerFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        return filter;
    }

    public ImageView getImgMore() {
        return this.imgMore;
    }

    public void showHongbaoRecordRed() {
    }

    public BroadcastReceiver getPowerReceiver() {
        if (this.powerReceiver == null) {
            this.powerReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    int level = intent.getIntExtra("level", 0);
                    int scale = intent.getIntExtra("scale", 0);
                    int status = intent.getIntExtra("status", 0);
                    AbstractViewTopFloatHolder.this.txtPower.setText((CharSequence)((int)((float)level / (float)scale * 100.0f) + "%"));
                    if (status == 2) {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery_charging"));
                    } else if (level < 12) {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery1"));
                    } else if (level >= 12 && level < 37) {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery2"));
                    } else if (level >= 37 && level < 62) {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery3"));
                    } else if (level >= 62 && level <= 87) {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery4"));
                    } else {
                        AbstractViewTopFloatHolder.this.imgPower.setImageResource(ResManager.getDrawableId("fs_icon_battery5"));
                    }
                }
            };
        }
        return this.powerReceiver;
    }

    @Override
    public void showFullScreen(boolean isFull) {
        if (isFull) {
            this.imgBack.setImageResource(ResManager.getDrawableId("fs_icon_back"));
        } else {
            this.imgBack.setImageResource(ResManager.getDrawableId("fs_ic_exit_app"));
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("imgBack")) {
            ((Activity)this.getContext()).onBackPressed();
        }
    }

    public void registerPowerReceiver(Activity activity) {
        activity.registerReceiver(this.getPowerReceiver(), this.getPowerFilter(), 4);
    }

    public void unregisterPowerReceiver(Activity activity) {
        if (null != this.powerReceiver) {
            activity.unregisterReceiver(this.powerReceiver);
            this.powerReceiver = null;
        }
    }
}

