/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.small;

import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.ui.holder.video.VideoViewTouchHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import java.util.Calendar;

public class SmallVideoViewTouchHolder
extends VideoViewTouchHolder {
    private static int SINGLE_CLICK_DISTANCE = 10;
    private static int SINGLE_CLICK_TIME_INTERVER = 300;
    private static final String SMALL_LEFT_MARGIN = "SMALL_LEFT_MARGIN";
    private static final String SMALL_TOP_MARGIN = "SMALL_TOP_MARGIN";
    private OnSmallFullScreenSmallListener onSmallFullScreenSmallListener;
    protected int portraitLeft = 0;
    protected int portraitTop = 0;
    protected int lastLeft = 0;
    protected int lastTop = 0;
    protected RelativeLayout parentRootView;
    private int nBottomMargin = 0;
    private int nLeftMargin = 0;
    private OnSmallViewEventListener onSmallViewEventListener;
    private GestureDetector smallViewDetector;
    private GSSmallViewListener smallViewListener;
    private int nDownx;
    private int nDowny;
    private long nDownTimeStamp;

    public void setOnSmallViewEventListener(OnSmallViewEventListener onSmallViewEventListener) {
        this.onSmallViewEventListener = onSmallViewEventListener;
    }

    public SmallVideoViewTouchHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void setOnSmallFullScreenSmallListener(OnSmallFullScreenSmallListener onSmallFullScreenSmallListener) {
        this.onSmallFullScreenSmallListener = onSmallFullScreenSmallListener;
    }

    public int getPortraitLeft() {
        return this.portraitLeft;
    }

    public int getPortraitTop() {
        return this.portraitTop;
    }

    public void setPortraitLeftAndTop(int left, int top) {
        this.portraitLeft = left;
        this.portraitTop = top;
        this.onSmallFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.parentRootView = (RelativeLayout)value;
        if (this.smallViewDetector == null) {
            this.smallViewListener = new GSSmallViewListener();
            this.smallViewDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.smallViewListener);
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        boolean isMove;
        if (null != this.onSmallFullScreenSmallListener && (isMove = this.onSmallFullScreenSmallListener.isMove())) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.lastLeft = (int)event.getRawX();
                    this.lastTop = (int)event.getRawY();
                    this.nDownx = this.lastLeft;
                    this.nDowny = this.lastTop;
                    this.nDownTimeStamp = Calendar.getInstance().getTimeInMillis();
                    break;
                }
                case 2: {
                    int x = (int)event.getRawX();
                    int y = (int)event.getRawY();
                    int moveX = x - this.lastLeft;
                    int moveY = y - this.lastTop;
                    this.portraitLeft += moveX;
                    if (this.portraitLeft < this.nLeftMargin) {
                        this.portraitLeft = this.nLeftMargin;
                    }
                    if (this.portraitLeft + this.rootView.getWidth() > this.parentRootView.getRight()) {
                        this.portraitLeft = this.parentRootView.getRight() - this.rootView.getWidth();
                    }
                    this.portraitTop += moveY;
                    if (this.portraitTop < 0) {
                        this.portraitTop = 0;
                    }
                    if (this.portraitTop + this.rootView.getHeight() > this.parentRootView.getBottom() - this.nBottomMargin) {
                        this.portraitTop = this.parentRootView.getBottom() - this.rootView.getHeight() - this.nBottomMargin;
                    }
                    this.lastLeft = x;
                    this.lastTop = y;
                    this.onSmallFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
                    break;
                }
                case 1: {
                    if (null == this.onSmallViewEventListener) {
                        return true;
                    }
                    if (!this.onSmallViewEventListener.isSmallRightVisible()) break;
                    int nUpx = (int)event.getRawX();
                    int nUpy = (int)event.getRawY();
                    long nUpTimeStamp = Calendar.getInstance().getTimeInMillis();
                    if (Math.abs(nUpx - this.nDownx) > SINGLE_CLICK_DISTANCE || Math.abs(nUpy - this.nDowny) > SINGLE_CLICK_DISTANCE || nUpTimeStamp - this.nDownTimeStamp > (long)SINGLE_CLICK_TIME_INTERVER) break;
                    int[] closeScreenPosition = new int[2];
                    ImageView ivClose = this.onSmallViewEventListener.onSmallViewEventGetCloseImg();
                    if (null != ivClose) {
                        ivClose.getLocationOnScreen(closeScreenPosition);
                        if (this.nDownx >= closeScreenPosition[0] && this.nDownx <= closeScreenPosition[0] + ivClose.getWidth() && this.nDowny >= closeScreenPosition[1] && this.nDowny <= closeScreenPosition[1] + ivClose.getHeight()) {
                            this.onSmallViewEventListener.onSmallViewEventClose();
                            return true;
                        }
                    }
                    ImageView ivSwitch = this.onSmallViewEventListener.onSmallViewEventGetSwitchImg();
                    int[] switchScreenPosition = new int[2];
                    ivSwitch.getLocationOnScreen(switchScreenPosition);
                    if (this.nDownx < switchScreenPosition[0] || this.nDownx > switchScreenPosition[0] + ivSwitch.getWidth() || this.nDowny < switchScreenPosition[1] || this.nDowny > switchScreenPosition[1] + ivSwitch.getHeight()) break;
                    this.onSmallViewEventListener.onSmallViewEventSwitch();
                    return true;
                }
            }
            this.smallViewDetector.onTouchEvent(event);
            return true;
        }
        return super.onTouch(v, event);
    }

    public void onScreenSizeChange() {
        int nViewWidth = GenseeUtils.getWidth3to10Rate(this.getContext());
        int nViewHeight = nViewWidth * 9 / 16;
        if (this.portraitTop + nViewHeight > this.parentRootView.getBottom() - this.nBottomMargin) {
            this.portraitTop = this.parentRootView.getBottom() - nViewHeight - this.nBottomMargin;
        }
        if (this.portraitLeft + nViewWidth > this.parentRootView.getRight()) {
            this.portraitLeft = this.parentRootView.getRight() - nViewWidth;
        }
    }

    public void setBottomAndLeftMargin(int bottomMargin, int leftMargin) {
        int nViewWidth;
        int nViewHeight;
        this.nBottomMargin = bottomMargin;
        this.nLeftMargin = leftMargin;
        if (this.portraitLeft < this.nLeftMargin) {
            this.portraitLeft = this.nLeftMargin;
        }
        if (this.portraitTop + (nViewHeight = (nViewWidth = GenseeUtils.getWidth3to10Rate(this.getContext())) * 9 / 16) > this.parentRootView.getBottom() - this.nBottomMargin) {
            this.portraitTop = this.parentRootView.getBottom() - nViewHeight - this.nBottomMargin;
        }
        if (null != this.onSmallFullScreenSmallListener) {
            this.onSmallFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
        }
    }

    public void initPosition() {
        int nViewWidth = GenseeUtils.getWidth3to10Rate(this.getContext());
        int nViewHeight = nViewWidth * 9 / 16;
        this.portraitLeft = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_fullscreen_small_show_left"));
        this.portraitLeft = Math.max(this.portraitLeft, this.nLeftMargin);
        this.portraitTop = this.getContext().getResources().getDisplayMetrics().heightPixels - nViewHeight - this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_fullscreen_small_show_bottom"));
    }

    public void setOrientation(int orientation) {
        this.initPosition();
        if (null != this.onSmallFullScreenSmallListener) {
            this.onSmallFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
        }
    }

    @Override
    public void onSaveInstence(Bundle outState) {
        super.onSaveInstence(outState);
        outState.putInt(SMALL_LEFT_MARGIN, this.portraitLeft);
        outState.putInt(SMALL_TOP_MARGIN, this.portraitTop);
    }

    public void layoutRestore(Bundle savedInstanceState) {
        if (null != savedInstanceState) {
            this.portraitLeft = savedInstanceState.getInt(SMALL_LEFT_MARGIN, 0);
            this.portraitTop = savedInstanceState.getInt(SMALL_TOP_MARGIN, 0);
            if (null != this.onSmallFullScreenSmallListener) {
                this.onSmallFullScreenSmallListener.onFullScreenSmallMoveTo(this.portraitLeft, this.portraitTop);
            }
        }
    }

    private class GSSmallViewListener
    extends GestureDetector.SimpleOnGestureListener {
        private GSSmallViewListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (null != SmallVideoViewTouchHolder.this.onSmallViewEventListener) {
                SmallVideoViewTouchHolder.this.onSmallViewEventListener.onSmallViewEventClick();
            }
            return true;
        }
    }

    public static interface OnSmallViewEventListener {
        public void onSmallViewEventClick();

        public ImageView onSmallViewEventGetCloseImg();

        public ImageView onSmallViewEventGetSwitchImg();

        public void onSmallViewEventClose();

        public void onSmallViewEventSwitch();

        public boolean isSmallRightVisible();
    }

    public static interface OnSmallFullScreenSmallListener {
        public boolean isMove();

        public void onFullScreenSmallMoveTo(int var1, int var2);
    }
}

