/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.small;

import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.small.SmallVideoViewTouchHolder;
import com.gensee.fastsdk.ui.holder.vdbar.VDBarHolder;
import com.gensee.fastsdk.util.AnimationUtils;
import com.gensee.fastsdk.util.ResManager;

public class SmallHolder
extends VDBarHolder
implements SmallVideoViewTouchHolder.OnSmallViewEventListener {
    private ImageView ivOpenSamll;
    private ImageView ivCloseSmall;
    private ImageView ivSwicthSamll;
    private OnSmallHolderListener onSmallHolderListener;
    private RelativeLayout rlScreenRight;
    private RelativeLayout rlScreenFull;
    private OpenSmallViewHolder openSmallViewHolder;

    public void setOnSmallHolderListener(OnSmallHolderListener onSmallHolderListener) {
        this.onSmallHolderListener = onSmallHolderListener;
    }

    public SmallHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.ivOpenSamll = (ImageView)this.findViewById(ResManager.getId("openSmall"));
        this.ivOpenSamll.setOnClickListener((View.OnClickListener)this);
        this.ivCloseSmall = (ImageView)this.findViewById(ResManager.getId("fullscreen_small_close"));
        this.ivSwicthSamll = (ImageView)this.findViewById(ResManager.getId("fullscreen_small_switch"));
        this.rlScreenRight = (RelativeLayout)this.findViewById(ResManager.getId("full_screen_small_rl"));
        this.rlScreenFull = (RelativeLayout)this.findViewById(ResManager.getId("doc_full_screen_small_rl"));
        this.rightBar = this.rlScreenRight;
        this.openSmallViewHolder = new OpenSmallViewHolder(this.findViewById(ResManager.getId("rlopenSmall")), null);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("openSmall")) {
            this.openSmall();
        } else if (v.getId() == ResManager.getId("fullscreen_small_close")) {
            this.closeSmall();
        } else if (v.getId() == ResManager.getId("fullscreen_small_switch")) {
            this.switchSamll();
        }
    }

    private void openSmall() {
        this.ivOpenSamll.setVisibility(8);
        if (null != this.onSmallHolderListener) {
            this.onSmallHolderListener.onOpenSmall();
        }
    }

    private void closeSmall() {
        if (null != this.onSmallHolderListener) {
            this.onSmallHolderListener.onCloseSamll();
        }
    }

    private void switchSamll() {
        if (null != this.onSmallHolderListener) {
            this.onSmallHolderListener.onSwitchSmall();
        }
    }

    public void setImgOpenVisibility(boolean bVisible) {
        this.ivOpenSamll.setVisibility(bVisible ? 0 : 8);
    }

    public void setRlScreenRightVisibility(boolean bVisible) {
        this.rlScreenRight.setVisibility(bVisible ? 0 : 8);
        if (null != this.rlScreenFull) {
            this.rlScreenFull.setVisibility(bVisible ? 0 : 8);
        }
        if (bVisible) {
            this.continueShowBtn();
            this.delayDismissFloatBtns();
        }
    }

    public RelativeLayout getScreenFullView() {
        return this.rlScreenFull;
    }

    @Override
    protected void onShowFloatTitle(int visibility) {
    }

    @Override
    public void onSmallViewEventClick() {
        this.showFloatBtns();
    }

    @Override
    public ImageView onSmallViewEventGetCloseImg() {
        return this.ivCloseSmall;
    }

    @Override
    public ImageView onSmallViewEventGetSwitchImg() {
        return this.ivSwicthSamll;
    }

    @Override
    public void onSmallViewEventClose() {
        this.onClick((View)this.ivCloseSmall);
    }

    @Override
    public void onSmallViewEventSwitch() {
        this.onClick((View)this.ivSwicthSamll);
    }

    @Override
    public boolean isSmallRightVisible() {
        return null != this.rlScreenRight && this.rlScreenRight.getVisibility() == 0;
    }

    public void showOpenSmallFloatBtns() {
        this.openSmallViewHolder.showFloatBtns();
    }

    public void dismisssOpenSmallFloatBtns() {
        this.openSmallViewHolder.dismisssFloatBtns();
    }

    public void continueOpenSmallShowBtn() {
        this.openSmallViewHolder.continueShowBtn();
    }

    public void delayOpenSmallDismissFloatBtns() {
        this.openSmallViewHolder.delayDismissFloatBtns();
    }

    public void dismissOpenSmallOwnBtn() {
        this.openSmallViewHolder.dismissOwnBtn();
    }

    @Override
    protected void onShowFloatBottom(int visibility) {
    }

    private class OpenSmallViewHolder
    extends VDBarHolder {
        public OpenSmallViewHolder(View rootView, Object value) {
            super(rootView, value);
            this.rightBar = rootView;
        }

        @Override
        protected void onShowFloatTitle(int visibility) {
        }

        @Override
        protected void initData(Object value) {
        }

        public void onClick(View v) {
        }

        @Override
        protected void showFloat() {
            int uiMode = ((LiveActivity)this.getContext()).getUIMode();
            if ((uiMode & 1) == 1 && (uiMode & 8) != 8) {
                if (this.rightBar.getVisibility() != 0) {
                    this.rightBar.setVisibility(0);
                    if (this.rightBar.getWidth() > 0) {
                        AnimationUtils.enterLeft2RightVisible(this.rightBar);
                    }
                }
                this.onShowFloatTitle(0);
            }
        }

        @Override
        public void dismisssFloatBtns() {
            if (this.rightBar.getVisibility() != 8) {
                if (this.rightBar.getWidth() > 0) {
                    AnimationUtils.enterRight2LeftGone(this.rightBar);
                } else {
                    this.rightBar.setVisibility(8);
                }
                this.onShowFloatTitle(8);
            }
        }

        @Override
        protected void onShowFloatBottom(int visibility) {
        }
    }

    public static interface OnSmallHolderListener {
        public void onOpenSmall();

        public void onCloseSamll();

        public void onSwitchSmall();
    }
}

