/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.qa.impl;

import android.text.TextUtils;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.holder.qa.impl.AbstractQaImpl;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.player.OnQaListener;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class QaImpl
extends AbstractQaImpl
implements OnQaListener {
    private static final String TAG = "QaImpl";
    private AtomicBoolean isQaEnalbe = new AtomicBoolean(true);
    private AtomicBoolean selfQaEnable = new AtomicBoolean(true);
    private OnQaMsgBottomListener onQaMsgBottomListener;

    public boolean getQaEnable() {
        return this.isQaEnalbe.get();
    }

    public void setOnQaMsgBottomListener(OnQaMsgBottomListener onQaMsgBottomListener) {
        this.onQaMsgBottomListener = onQaMsgBottomListener;
    }

    public void onQa(String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
        GenseeLog.i((String)TAG, (String)("onQa() called with: questionId = [" + questionId + "], question = [" + question + "], questionOwner = [" + questionOwner + "], answerId = [" + answerId + "], answer = [" + answer + "], answerOwner = [" + answerOwner + "], questionTime = [" + questionTime + "], answerTime = [" + answerTime + "], qaOwnerId = [" + qaOwnerId + "], isCancel = [" + isCancel + "]"));
        this.addMsg(questionId, question, questionOwner, answerId, answer, answerOwner, questionTime, answerTime, qaOwnerId, isCancel);
    }

    public void onQaMute(boolean b) {
        GenseeLog.i((String)TAG, (String)("onQaMute b:" + b));
        this.selfQaEnable.set(!b);
    }

    public void onRoomMute(boolean b) {
        GenseeLog.i((String)TAG, (String)("onRoomMute b:" + b));
        this.isQaEnalbe.set(!b);
        if (null != this.onQaMsgBottomListener) {
            this.onQaMsgBottomListener.onQaEnable(!b, true);
        }
    }

    public void addMsg(final String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
        UserInfo self = PlayerLive.getIns().getSelf();
        if (isCancel) {
            boolean bTrue = false;
            if (null != self && qaOwnerId == self.getUserId()) {
                bTrue = true;
            }
            final boolean bTmpTrue = bTrue;
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().cancelQaMsg(questionId, bTmpTrue);
                }
            });
        } else {
            RtQaMsg msg = new RtQaMsg();
            msg.setAnswer(answer);
            msg.setAnswerId(answerId);
            msg.setAnswerOwner(answerOwner);
            msg.setAnswerTimestamp((long)answerTime);
            msg.setQuestId(questionId);
            msg.setQuestion(question);
            msg.setQuestOwnerId(qaOwnerId);
            msg.setQuestOwnerName(questionOwner);
            msg.setQuestTimgstamp((long)questionTime);
            msg.setTimestamp(Calendar.getInstance().getTimeInMillis());
            this.addMsg(msg);
            if (null != this.onQaMsgBottomListener && null != questionOwner && qaOwnerId == PlayerLive.getIns().getSelf().getId() && !TextUtils.isEmpty((CharSequence)answer)) {
                this.onQaMsgBottomListener.onQaReplaySelf(answerOwner);
            }
        }
    }

    public void sendQaMsg(String text) {
        if (this.isQaEnalbe.get()) {
            if (this.selfQaEnable.get()) {
                PlayerLive.getIns().sendQaMsg(this, text);
            } else {
                UserInfo self = PlayerLive.getIns().getSelf();
                String questId = UUID.randomUUID().toString() + "_self";
                this.addMsg(questId, text, null == self ? "" : self.getName(), "", "", "", (int)Calendar.getInstance().getTimeInMillis(), 0, null == self ? -1L : self.getId(), false);
            }
        }
    }

    public void release() {
        super.release();
        QaMsgQueue.getIns().setOnQaHolderListener(null);
    }

    public static interface OnQaMsgBottomListener {
        public void onQaReplaySelf(String var1);

        public void onQaEnable(boolean var1, boolean var2);
    }
}

