/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.midtab;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.ui.holder.midtab.MidTabsHolder;
import com.gensee.fastsdk.util.ConfigApp;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public class VodMidTabsHolder
extends MidTabsHolder {
    public static final int ACTIVE_TAB5 = 5;
    protected Button tab5;
    private RelativeLayout lyTab5;

    public VodMidTabsHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.tab5 = (Button)this.findViewById(ResManager.getId("btnTab5"));
        this.lyTab5 = (RelativeLayout)this.findViewById(ResManager.getId("lyTab5"));
        this.lyTab5.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void layout(Bundle saveInstance) {
        super.layout(saveInstance);
        GSFastConfig config = ConfigApp.getIns().getFastConfig();
        boolean isShowDoc = true;
        boolean isShowQa = true;
        boolean isShowChat = true;
        boolean isShowIntro = true;
        boolean isShowChapter = true;
        if (config != null) {
            isShowQa = config.isShowQa();
            isShowChat = config.isShowChat();
            isShowIntro = config.isShowIntro() && this.isHaveLiveInfo;
            isShowChapter = config.isShowChapter();
            isShowDoc = config.isShowDoc();
        }
        boolean bl = isShowDoc = isShowDoc || !isShowQa && !isShowChat && !isShowIntro && !isShowChapter;
        if (isShowDoc) {
            this.activeTabId = ResManager.getId("lyTab1");
            this.activeTab(1, this.getString(ResManager.getStringId("fs_doc")));
            if (this.mListener != null) {
                this.mListener.onClick((View)this.lyTab1);
            }
        } else if (isShowChapter) {
            this.activeTabId = ResManager.getId("lyTab4");
            this.activeTab(4, "");
            if (this.mListener != null) {
                this.mListener.onClick((View)this.lyTab4);
            }
        } else if (isShowChat) {
            this.activeTabId = ResManager.getId("lyTab2");
            this.activeTab(2, this.getString(ResManager.getStringId("fs_chat")));
            if (this.mListener != null) {
                this.mListener.onClick((View)this.lyTab2);
            }
        } else if (isShowQa) {
            this.activeTabId = ResManager.getId("lyTab3");
            this.activeTab(3, this.getString(ResManager.getStringId("fs_qa")));
            if (this.mListener != null) {
                this.mListener.onClick((View)this.lyTab3);
            }
        } else if (isShowIntro) {
            this.activeTabId = ResManager.getId("lyTab5");
            this.activeTab(5, this.getString(ResManager.getStringId("fs_introdution")));
            if (this.mListener != null) {
                this.mListener.onClick((View)this.lyTab5);
            }
        }
    }

    @Override
    protected void activeTab(View activeTab) {
        super.activeTab(activeTab);
        this.activeTab(activeTab, this.lyTab5);
    }

    @Override
    protected void activeTab(int activeTab, String text) {
        super.activeTab(activeTab, text);
        if (activeTab == 5) {
            if (text != null && !"".equals(text)) {
                this.tab4.setText((CharSequence)text);
            }
            this.activeTab((View)this.lyTab5);
        }
    }

    @Override
    public void showTabs() {
        GSFastConfig config = ConfigApp.getIns().getFastConfig();
        boolean isShowDoc = false;
        boolean isShowQa = false;
        boolean isShowChat = false;
        boolean isShowIntro = false;
        boolean isShowChapter = false;
        if (config != null) {
            isShowQa = config.isShowQa();
            isShowChat = config.isShowChat();
            isShowIntro = config.isShowIntro() && this.isHaveLiveInfo;
            isShowChapter = config.isShowChapter();
        }
        isShowDoc = config.isShowDoc() || !isShowQa && !isShowChat && !isShowIntro && !isShowChapter;
        GenseeLog.i((String)("showTabs bShowDoc = " + isShowDoc + " bShowQa = " + isShowQa + " bShowChat = " + isShowChat + " bShowIntro = " + isShowIntro + "config = " + config));
        this.lyTab1.setVisibility(isShowDoc ? 0 : 8);
        this.lyTab2.setVisibility(isShowChat ? 0 : 8);
        this.lyTab3.setVisibility(isShowQa ? 0 : 8);
        this.lyTab4.setVisibility(isShowChapter ? 0 : 8);
        this.lyTab5.setVisibility(isShowIntro ? 0 : 8);
        if (!isShowDoc) {
            int fistMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_midtabs_first_margin_left"));
            if (isShowChapter) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab4.getLayoutParams();
                lp.leftMargin = fistMargin;
                this.lyTab4.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (isShowChat) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab2.getLayoutParams();
                lp.leftMargin = fistMargin;
                this.lyTab2.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (isShowQa) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab3.getLayoutParams();
                lp.leftMargin = fistMargin;
                this.lyTab3.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (isShowIntro) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab5.getLayoutParams();
                lp.leftMargin = fistMargin;
                this.lyTab5.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }
}

