/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.idc;

import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.GSLive;
import com.gensee.fastsdk.ui.holder.idc.IdcBaseHolder;
import com.gensee.fastsdk.ui.holder.idc.IdcWhiteHolder;
import com.gensee.fastsdk.util.ResManager;
import java.util.List;

public class IdcBlackHolder
extends IdcBaseHolder {
    private static final long DURAION = 300L;
    protected LinearLayout lyIdcContent;
    protected LinearLayout lyIdcNoData;
    protected String selectIdc = "";
    protected View idcBlankArea;
    protected LinearLayout idcAllContent;

    public IdcBlackHolder(View rootView, Object value) {
        super(rootView, value, new Object[0]);
    }

    @Override
    public void selectIdc(List<IdcWhiteHolder.FastIdc> idcList) {
        final List<IdcWhiteHolder.FastIdc> idcs = idcList;
        this.lyIdcContent.removeAllViews();
        if (null == idcs || idcs.size() <= 0) {
            this.lyIdcNoData.setVisibility(0);
        } else {
            this.lyIdcNoData.setVisibility(8);
            String sCurIdc = GSLive.getIns().roomIDCGetCurrent();
            this.selectIdc = null == sCurIdc ? "" : sCurIdc;
            int nsize = idcs.size();
            for (int i = 0; i < nsize; ++i) {
                TextView tv = new TextView(this.getContext());
                tv.setGravity(17);
                tv.setTextSize(0, (float)this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_gs_idc_item_text_size")));
                tv.setSingleLine();
                tv.setEllipsize(TextUtils.TruncateAt.END);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fs_gs_idc_item_height")));
                tv.setText((CharSequence)idcs.get((int)i).name);
                if (!"".equals(this.selectIdc) && this.selectIdc.equals(idcs.get((int)i).id)) {
                    tv.setTextColor(Color.parseColor((String)"#e43e36"));
                } else {
                    tv.setTextColor(-1);
                }
                final int nItemIndex = i;
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        IdcBlackHolder.this.selectIdc = ((IdcWhiteHolder.FastIdc)idcs.get((int)nItemIndex)).id;
                        IdcBlackHolder.this.sure();
                    }
                });
                if (i != 0) {
                    View line = new View(this.getContext());
                    line.setBackgroundResource(ResManager.getColorId("fs_pure_idc_line_color"));
                    LinearLayout.LayoutParams lineLp = new LinearLayout.LayoutParams(-1, 2);
                    this.lyIdcContent.addView(line, (ViewGroup.LayoutParams)lineLp);
                }
                this.lyIdcContent.addView((View)tv, (ViewGroup.LayoutParams)lp);
            }
        }
        this.show(true);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_idc_blank_area")) {
            this.show(false);
        }
    }

    protected void sure() {
        if (!"".equals(this.selectIdc) && !this.selectIdc.equals(GSLive.getIns().roomIDCGetCurrent())) {
            GSLive.getIns().roomIDCSetCurrent(this.selectIdc);
        }
        this.show(false);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.lyIdcContent = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_content_ly"));
        this.lyIdcNoData = (LinearLayout)this.findViewById(ResManager.getId("idc_no_data_ly"));
        this.idcBlankArea = this.findViewById(ResManager.getId("gs_idc_blank_area"));
        this.idcBlankArea.setOnClickListener((View.OnClickListener)this);
        this.idcAllContent = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_all_content"));
    }
}

