/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.doc;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.doc.AbstractLiveDocHolder;
import com.gensee.fastsdk.ui.holder.small.SmallHolder;
import com.gensee.fastsdk.ui.holder.small.SmallVideoViewTouchHolder;
import com.gensee.fastsdk.ui.holder.vdbar.ReceiverVDBarHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.pdu.IGSDocView;

public class ReceiverLiveDocHolder
extends AbstractLiveDocHolder
implements ReceiverVDBarHolder.OnVdBarListener,
PlayerLive.OnDocListener,
SmallHolder.OnSmallHolderListener,
SmallVideoViewTouchHolder.OnSmallFullScreenSmallListener {
    private ReceiverVDBarHolder mVdBarHolder;
    private SmallHolder mSmallHolder;
    private SmallVideoViewTouchHolder mSmallVideoViewTouchHolder;
    private View tvDef;

    public ReceiverLiveDocHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.mVdBarHolder = new ReceiverVDBarHolder(this.getRootView(), null);
        this.mVdBarHolder.setOnVdBarListener(this);
        ((BaseWatchActivity)this.getContext()).setDocView(this.docViewGx);
        this.mVdBarHolder.setFloatRightBtnsVisible(false);
        this.mSmallHolder = new SmallHolder(this.rootView, null);
        this.mSmallHolder.setOnSmallHolderListener(this);
        this.mSmallVideoViewTouchHolder = new SmallVideoViewTouchHolder(this.rootView, value);
        if (null != this.mSmallHolder.getScreenFullView()) {
            this.mSmallHolder.getScreenFullView().setOnTouchListener((View.OnTouchListener)this.mSmallVideoViewTouchHolder);
        }
        this.mSmallVideoViewTouchHolder.setOnSmallFullScreenSmallListener(this);
        this.mSmallVideoViewTouchHolder.setOnSmallViewEventListener(this.mSmallHolder);
        this.findViewById(ResManager.getId("relDef")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("fs_doc_default_bg")));
        this.tvDef = this.findViewById(ResManager.getId("tvDef"));
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("iv_pip_switch")) {
            this.listener.onFullContentSwitch(2);
        }
    }

    @Override
    public void onSwitchToFullScreen() {
        this.listener.onSwitchToFull(2);
    }

    @Override
    public void onHandClick() {
    }

    @Override
    public void onRewardClick() {
    }

    @Override
    public void onShowInputDialog() {
        ((LiveActivity)this.getContext()).showInputDialog();
    }

    @Override
    public void onShowFloatTitle(int visibility) {
        this.listener.onFloatBtnShow(2, visibility);
    }

    @Override
    public void onRoomJoinSuccess() {
        this.cancelDocSwitchButtons();
    }

    public void cancelDocSwitchButtons() {
        this.mVdBarHolder.showImageFullScreen(true);
        this.findViewById(ResManager.getId("tvDef")).setSelected(false);
    }

    @Override
    public void showFullScreen() {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.getContext().getResources().getConfiguration().orientation == 1) {
            this.showPortraitDocFullScreen();
        } else {
            this.showLandScapeDocFullScreen();
        }
        this.setImgOpenVideoStatus();
        this.processSmallAndEffectPosition();
    }

    @Override
    public void showNormalScreen() {
        this.setImgOpenVideoStatus();
        this.mSmallHolder.setRlScreenRightVisibility(false);
    }

    public void removeDelayRunnable() {
        this.mVdBarHolder.removeRunnable();
    }

    @Override
    public void showPortraitDocNorScreen() {
    }

    @Override
    public void showPortraitDocFullScreen() {
        this.setImgOpenVideoStatus();
    }

    @Override
    public void showLandScapeDocFullScreen() {
        this.setImgOpenVideoStatus();
    }

    public void setFloatRightBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatRightBtnsVisible(isShow);
    }

    @Override
    public boolean onSingleClicked(IGSDocView arg0) {
        boolean isFullScreen;
        boolean bl = isFullScreen = (((LiveActivity)this.getContext()).getUIMode() & 1) == 1;
        if (isFullScreen) {
            this.mVdBarHolder.showFloatBtns();
        }
        this.mSmallHolder.showOpenSmallFloatBtns();
        return super.onSingleClicked(arg0);
    }

    @Override
    public void show(boolean isShow) {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        isShow = isShow || (uiMode & 1) == 1 && (uiMode & 8) == 8;
        this.docViewGx.setVisibility(isShow ? 0 : 8);
        super.show(isShow);
    }

    @Override
    public void setOrientation(final int orientation) {
        this.show(this.rootView.getVisibility() == 0);
        if (null != this.mSmallVideoViewTouchHolder) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ReceiverLiveDocHolder.this.mSmallVideoViewTouchHolder.setOrientation(orientation);
                }
            }, 50L);
        }
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (null != this.mSmallVideoViewTouchHolder) {
            this.mSmallVideoViewTouchHolder.layoutRestore(savedInstanceState);
        }
    }

    @Override
    public void onSaveInstence(Bundle outState) {
        super.onSaveInstence(outState);
        this.mSmallVideoViewTouchHolder.onSaveInstence(outState);
    }

    @Override
    public void onPageSize(int pos, int width, int height) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveDocHolder.this.findViewById(ResManager.getId("relDef")).setVisibility(8);
            }
        });
    }

    @Override
    public void onDocSwitch(int docType, String docName) {
        if (docType == 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ReceiverLiveDocHolder.this.findViewById(ResManager.getId("relDef")).setVisibility(0);
                }
            });
        }
    }

    @Override
    public void dismisssFloatBtns() {
        this.mVdBarHolder.dismisssFloatBtns();
        this.mSmallHolder.dismisssOpenSmallFloatBtns();
    }

    @Override
    public void delayDismissFloatBtns() {
        this.mVdBarHolder.delayDismissFloatBtns();
        this.mSmallHolder.delayOpenSmallDismissFloatBtns();
    }

    @Override
    public void continueShowBtn() {
        this.mVdBarHolder.continueShowBtn();
        this.mSmallHolder.continueOpenSmallShowBtn();
    }

    @Override
    public void showDocFloatBtn(int type) {
    }

    @Override
    public void dismissOwnBtn() {
        this.mVdBarHolder.dismissOwnBtn();
        this.mSmallHolder.dismissOpenSmallOwnBtn();
    }

    @Override
    public void setImageHandVisible(boolean visible) {
        this.mVdBarHolder.setImageHandVisible(visible);
    }

    public void showRewardBtn(boolean isShow) {
        this.mVdBarHolder.showRewardBtn(isShow);
    }

    @Override
    public void updateHand(String sValue, boolean visible) {
        this.mVdBarHolder.updateHand(sValue, visible);
    }

    @Override
    public void dismissVideoFloatButtons() {
    }

    @Override
    public boolean isMove() {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        return (uiMode & 1) == 1 && (uiMode & 2) == 2;
    }

    @Override
    public void onFullScreenSmallMoveTo(int left, int top) {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        if ((uiMode & 2) == 2 && (uiMode & 8) == 8) {
            RelativeLayout.LayoutParams mNormalLayoutParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
            mNormalLayoutParam.leftMargin = left;
            mNormalLayoutParam.topMargin = top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)mNormalLayoutParam);
        }
    }

    protected void processSmallAndEffectPosition() {
        int docViewIndex;
        View videoView;
        RelativeLayout parent;
        int videoViewIndex;
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        if ((uimode & 1) == 1 && (uimode & 2) == 2) {
            return;
        }
        if (null != this.rootView.getParent() && (videoViewIndex = (parent = (RelativeLayout)this.rootView.getParent()).indexOfChild(videoView = parent.findViewById(ResManager.getId("videoLayout")))) <= (docViewIndex = parent.indexOfChild(this.rootView))) {
            parent.removeView(this.rootView);
            parent.addView(this.rootView, videoViewIndex);
        }
    }

    public void onFullScreenSmallView(boolean bOpen) {
        if (bOpen) {
            this.show(true);
            this.positionSmallDocView();
            this.mSmallHolder.setRlScreenRightVisibility(true);
            this.docViewGx.showAdaptView();
            this.setImgOpenSmallVisible(false);
        } else {
            this.show(false);
            this.mSmallHolder.setRlScreenRightVisibility(false);
        }
    }

    private void positionSmallDocView() {
        int nViewWidth = GenseeUtils.getWidth3to10Rate(this.getContext());
        int nViewHeight = nViewWidth * 9 / 16;
        RelativeLayout.LayoutParams mNormalLayoutParam = new RelativeLayout.LayoutParams(-2, -2);
        mNormalLayoutParam.width = nViewWidth;
        mNormalLayoutParam.height = nViewHeight;
        mNormalLayoutParam.topMargin = this.mSmallVideoViewTouchHolder.getPortraitTop();
        mNormalLayoutParam.leftMargin = this.mSmallVideoViewTouchHolder.getPortraitLeft();
        this.layout(mNormalLayoutParam);
    }

    public void setImgOpenVideoStatus() {
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        boolean bVisible = (uimode & 1) == 1 && (uimode & 8) != 8;
        this.setImgOpenSmallVisible(bVisible);
    }

    public void setImgOpenSmallVisible(boolean bVisible) {
        boolean bTrue = bVisible;
        this.mSmallHolder.setImgOpenVisibility(bTrue && PlayerLive.getIns().isShowPIP());
        if (bTrue) {
            this.continueShowBtn();
            this.delayDismissFloatBtns();
        }
    }

    @Override
    public void onOpenSmall() {
        this.listener.onFullScreenVDClick(1, true);
    }

    @Override
    public void onCloseSamll() {
        this.listener.onFullScreenVDClick(2, false);
    }

    @Override
    public void onSwitchSmall() {
        this.listener.onFullContentSwitch(2);
    }

    public void initSmallPosition() {
        if (null != this.mSmallVideoViewTouchHolder) {
            this.mSmallVideoViewTouchHolder.initPosition();
        }
    }

    public int getPortraitLeft() {
        return this.mSmallVideoViewTouchHolder.getPortraitLeft();
    }

    public int getPortraitTop() {
        return this.mSmallVideoViewTouchHolder.getPortraitTop();
    }

    public void setPortraitLeftAndTop(int left, int top) {
        this.mSmallVideoViewTouchHolder.setPortraitLeftAndTop(left, top);
    }
}

