/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.os.Handler;
import com.gensee.callback.IChatCallBack;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.holder.chat.impl.AbstractChatImpl;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.ThreadPool;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RTChatImpl
extends AbstractChatImpl
implements IChatCallBack,
RTLive.OnSysMsgListener,
AbsChatImpl {
    public static final int NEW_DELAY_TIME = 1000;
    private OnMsgBottomListener onMsgBottomListener;
    private OnChatModeChangeListener onChatModeChangeListener;
    private OnChatTopMsgTipListener onTopMsgTipListener;
    private AtomicBoolean bChatEnable = new AtomicBoolean(true);
    private AtomicInteger nChatMode = new AtomicInteger(1);
    private int nSiteChatMode = 101;
    private Handler mHandler;

    @Override
    public boolean isSutPriChatEnable() {
        return this.nSiteChatMode != 0;
    }

    public int getSiteChatMode() {
        return this.nSiteChatMode;
    }

    @Override
    public boolean getChatEnable() {
        return this.bChatEnable.get();
    }

    @Override
    public void sendPrivateMsg(String text, String rich, UserInfo receiveUserInfo) {
    }

    public void setOnTopMsgTipListener(OnChatTopMsgTipListener onTopMsgTipListener) {
        this.onTopMsgTipListener = onTopMsgTipListener;
    }

    public void setOnMsgBottomListener(OnMsgBottomListener onMsgBottomListener) {
        this.onMsgBottomListener = onMsgBottomListener;
    }

    @Override
    public void setOnChatModeChangeListener(OnChatModeChangeListener onChatModeChangeListener) {
        this.onChatModeChangeListener = onChatModeChangeListener;
    }

    public RTChatImpl() {
        RTLive.getIns().setOnSysMsgListener(this);
    }

    public void setHandler(Handler mHandler) {
        this.mHandler = mHandler;
    }

    public void onChatJoinConfirm(boolean bRet) {
    }

    public void onChatWithPersion(UserInfo userInfo, String msg, String richText, String msgId) {
        PrivateMessage message = new PrivateMessage();
        message.setText(msg);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setSendUserId(userInfo.getId());
        message.setRich(richText);
        message.setReceiveUserId(null == RTLive.getIns().getSelf() ? 0L : RTLive.getIns().getSelf().getId());
        message.setSendUserName(userInfo.getName());
        message.setReceiveName(null == RTLive.getIns().getSelf() ? "" : RTLive.getIns().getSelf().getName());
        message.setId(msgId);
        this.updateMessage((AbsChatMessage)message);
        if (null != this.onTopMsgTipListener && null != userInfo) {
            this.onTopMsgTipListener.onPrivateMsg(userInfo.getName());
        }
        if (null != this.onMsgBottomListener && null != userInfo) {
            this.onMsgBottomListener.onPrivateMsg(userInfo);
        }
    }

    public void addTipMessage(String msg) {
        TipMessage message = new TipMessage();
        message.setText(msg);
        message.setRich(msg);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setReceiveUserId(-1L);
        this.updateMessage((AbsChatMessage)message);
    }

    public void onChatWithPublic(UserInfo userInfo, String msg, String richText, String msgId) {
        PublicMessage message = new PublicMessage();
        message.setText(msg);
        message.setRich(richText);
        message.setSendUserId(userInfo.getId());
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setSendUserName(userInfo.getName());
        message.setReceiveUserId(-1L);
        message.setId(msgId);
        this.updateMessage((AbsChatMessage)message);
    }

    public void onChatToPersion(long userId, String msg, String richText) {
        PrivateMessage message = new PrivateMessage();
        message.setText(msg);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setSendUserId(null == RTLive.getIns().getSelf() ? 0L : RTLive.getIns().getSelf().getId());
        message.setRich(richText);
        message.setReceiveUserId(userId);
        UserInfo toUser = RTLive.getIns().getUserById(userId);
        message.setReceiveName(null == toUser ? "" : toUser.getName());
        message.setSendUserName(null == RTLive.getIns().getSelf() ? "" : RTLive.getIns().getSelf().getName());
        this.updateMessage((AbsChatMessage)message);
    }

    public void onChatEnable(boolean enable) {
        this.bChatEnable.set(enable);
        if (null != this.onChatModeChangeListener) {
            this.onChatModeChangeListener.onSelfChatEnable(enable);
        }
    }

    @Override
    public void sendPublicMsg(final String text, final String rich) {
        if (this.nChatMode.get() == 1) {
            if (this.bChatEnable.get()) {
                final String msgId = UUID.randomUUID().toString();
                RTLive.getIns().chatWithPublic(text, rich, msgId, new OnTaskRet(){

                    public void onTaskRet(boolean ret, int id, String desc) {
                        UserInfo self;
                        if (ret && (self = RTLive.getIns().getSelf()) != null) {
                            RTChatImpl.this.onChatWithPublic(self, text, rich, msgId);
                        }
                    }
                });
            } else {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(9000, (Object)0));
                PublicMessage message = new PublicMessage();
                message.setRich(rich);
                message.setText(text);
                message.setSendUserId(null == RTLive.getIns().getSelf() ? 0L : RTLive.getIns().getSelf().getId());
                message.setTime(Calendar.getInstance().getTimeInMillis());
                message.setSendUserName(null == RTLive.getIns().getSelf() ? "" : RTLive.getIns().getSelf().getName());
                message.setReceiveUserId(-1L);
                this.updateMessage((AbsChatMessage)message);
            }
        }
    }

    @Override
    public void onSysMsg(String sSysMsg) {
        SysMessage sysMessage = new SysMessage();
        sysMessage.setTime(Calendar.getInstance().getTimeInMillis());
        sysMessage.setSendUserId(-1L);
        sysMessage.setRich(sSysMsg);
        sysMessage.setText(sSysMsg);
        this.updateMessage((AbsChatMessage)sysMessage);
    }

    @Override
    public void onBraodcastMsg(String sSysMsg) {
        this.onSysMsg(sSysMsg);
        if (null != this.onTopMsgTipListener) {
            this.onTopMsgTipListener.onBraodcastMsg(sSysMsg);
        }
    }

    @Override
    public void onChatMode(int nChatMode, String tip) {
    }

    @Override
    public void onSitePrivateChatMode(int nSiteChatMode) {
        this.nSiteChatMode = nSiteChatMode;
    }

    @Override
    public int getChatMode() {
        return this.nChatMode.get();
    }

    public void addLocalSystemMsg(String msg) {
        SysMessage message = new SysMessage();
        message.setText(msg);
        message.setRich(msg);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setReceiveUserId(-1L);
        this.updateMessage((AbsChatMessage)message);
    }

    public void onChatMessage(ChatMsg msg) {
        if (msg != null) {
            switch (msg.getChatMsgType()) {
                case 0: {
                    this.onChatWithPublic(RTLive.getIns().getUserById(msg.getSenderId()), msg.getContent(), msg.getRichText(), msg.getId());
                    break;
                }
                case 2: {
                    this.onChatWithPersion(RTLive.getIns().getUserById(msg.getSenderId()), msg.getContent(), msg.getRichText(), msg.getId());
                    break;
                }
            }
        }
    }

    public void onChatCensor(final long userId, final String msgId) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().removeMsg(userId, msgId);
            }
        });
    }

    public static interface OnChatModeChangeListener {
        public void onChatModeChage(int var1);

        public void onSelfChatEnable(boolean var1);
    }

    public static interface OnMsgBottomListener {
        public void onChatMode(int var1);

        public void onPrivateMsg(UserInfo var1);
    }

    public static interface OnChatTopMsgTipListener {
        public void onBraodcastMsg(String var1);

        public void onPrivateMsg(String var1);
    }
}

