/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.common.RoleType;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.HongbaoMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.view.MyTextViewEx;

public class PublicChatAdapter
extends AbstractAdapter {
    private Context context;

    protected View createView(Context context) {
        this.context = context;
        return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("fs_public_chat_item"), null);
    }

    protected AbstractViewHolder createViewHolder(View view) {
        return new PublicChatViewHolder(view);
    }

    protected class PublicChatViewHolder
    extends AbstractViewHolder {
        protected ImageView ivTitle;
        protected TextView tvTitle;
        protected TextView tvTime;
        protected MyTextViewEx tvContent;
        protected ImageView ivBottomLine;
        protected View normalItemLy;
        protected View hongbaoItemLy;
        protected TextView tvHbMsg;
        protected ImageView viewHBLine;
        protected TextView tvTipMsg;
        protected View tipItemLy;
        protected ImageView viewTIPLine;

        public PublicChatViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.ivTitle = (ImageView)view.findViewById(ResManager.getId("item_tip_iv"));
            this.tvTitle = (TextView)view.findViewById(ResManager.getId("title_tv"));
            this.tvTime = (TextView)view.findViewById(ResManager.getId("time_tv"));
            this.tvContent = (MyTextViewEx)view.findViewById(ResManager.getId("content_tv"));
            this.ivBottomLine = (ImageView)view.findViewById(ResManager.getId("bottom_line_iv"));
            this.viewHBLine = (ImageView)view.findViewById(ResManager.getId("item_hb_line"));
            this.viewTIPLine = (ImageView)view.findViewById(ResManager.getId("item_hb_line_tip"));
            this.normalItemLy = view.findViewById(ResManager.getId("public_chat_item_normal"));
            this.hongbaoItemLy = view.findViewById(ResManager.getId("public_chat_item_hongbao"));
            this.tvHbMsg = (TextView)view.findViewById(ResManager.getId("hb_msg_tv"));
            this.tipItemLy = view.findViewById(ResManager.getId("public_chat_item_tip"));
            this.tvTipMsg = (TextView)view.findViewById(ResManager.getId("hb_msg_tv_tip"));
            view.findViewById(ResManager.getId("top_iv")).setBackground(PublicChatAdapter.this.context.getResources().getDrawable(ResManager.getColorId("fs_public_chat_item_line")));
            this.ivBottomLine.setBackground(PublicChatAdapter.this.context.getResources().getDrawable(ResManager.getColorId("fs_public_chat_item_line")));
            this.tvTime.setTextColor(PublicChatAdapter.this.context.getResources().getColor(ResManager.getColorId("fs_qa_item_time")));
        }

        public void initValue(int positon) {
            Context context = this.tvTitle.getContext();
            AbsChatMessage chatMessage = (AbsChatMessage)PublicChatAdapter.this.getItem(positon);
            this.tvTitle.setText((CharSequence)chatMessage.getSendUserName());
            this.tvContent.setChatContent(chatMessage.getText(), chatMessage.getRich());
            this.ivBottomLine.setVisibility(positon == PublicChatAdapter.this.getCount() - 1 ? 8 : 0);
            long mCurrentTime = chatMessage.getTime() / 1000L;
            this.tvTime.setText((CharSequence)(String.format("%02d", (mCurrentTime / 3600L % 24L + 8L) % 24L) + ":" + String.format("%02d", mCurrentTime % 3600L / 60L) + ":" + String.format("%02d", mCurrentTime % 3600L % 60L)));
            if (chatMessage instanceof HongbaoMessage) {
                this.normalItemLy.setVisibility(8);
                this.hongbaoItemLy.setVisibility(0);
                String text = chatMessage.getRich();
                SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)text);
                ForegroundColorSpan redSpan = new ForegroundColorSpan(Color.parseColor((String)"#f05252"));
                int start = text.lastIndexOf(" ") + 1;
                ssb.setSpan((Object)redSpan, start, text.length(), 33);
                this.tvHbMsg.setText((CharSequence)ssb);
                this.viewHBLine.setVisibility(positon == PublicChatAdapter.this.getCount() - 1 ? 8 : 0);
                return;
            }
            this.normalItemLy.setVisibility(0);
            this.hongbaoItemLy.setVisibility(8);
            if (chatMessage instanceof TipMessage) {
                this.normalItemLy.setVisibility(8);
                this.tipItemLy.setVisibility(0);
                this.tipItemLy.findViewById(ResManager.getId("top_iv_ref_tip")).setBackground(context.getResources().getDrawable(ResManager.getColorId("fs_public_chat_item_line")));
                this.tipItemLy.findViewById(ResManager.getId("item_hb_line_tip")).setBackground(context.getResources().getDrawable(ResManager.getColorId("fs_public_chat_item_line")));
                String text = chatMessage.getRich();
                this.tvTipMsg.setText((CharSequence)text);
                this.tvTipMsg.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_tip_text")));
                this.tvTipMsg.setBackground(context.getResources().getDrawable(ResManager.getDrawableId("fs_shape_tip_msg_bg")));
                this.viewTIPLine.setVisibility(positon == PublicChatAdapter.this.getCount() - 1 ? 8 : 0);
                return;
            }
            this.normalItemLy.setVisibility(0);
            this.tipItemLy.setVisibility(8);
            if (chatMessage instanceof SysMessage) {
                this.tvTitle.setText(ResManager.getStringId("fs_gs_chat_sys"));
                this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_tip")));
                this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_sys_iv"));
                this.tvContent.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_sys_content")));
            } else if (chatMessage instanceof PublicMessage) {
                this.tvTitle.setText((CharSequence)GenseeUtils.filterNickName(chatMessage.getSendUserName()));
                UserInfo self = PlayerLive.getIns().getSelf();
                this.tvContent.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_content")));
                if (0L != chatMessage.getSendUserId()) {
                    boolean bHost = RoleType.isHost((int)chatMessage.getSenderRole());
                    boolean bSelf = false;
                    if (null != self && self.getId() == chatMessage.getSendUserId()) {
                        bSelf = true;
                    }
                    if (bHost && bSelf) {
                        this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_host_iv"));
                        this.tvTitle.setText((CharSequence)context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")));
                        this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_tip")));
                    } else if (bHost) {
                        this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_host_iv"));
                        this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_host_tip")));
                    } else if (bSelf) {
                        this.tvTitle.setText((CharSequence)context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")));
                        this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                        this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_tip")));
                    } else {
                        this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                        this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_host_tip")));
                    }
                } else {
                    this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                    this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_tip")));
                }
            } else if (chatMessage instanceof PrivateMessage) {
                UserInfo self = PlayerLive.getIns().getSelf();
                this.ivTitle.setBackgroundResource(ResManager.getDrawableId("fs_chat_default_iv"));
                this.tvContent.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_default_content")));
                if (null != self) {
                    String sTitle = "";
                    if (chatMessage.getSendUserId() == self.getId()) {
                        sTitle = context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + GenseeUtils.filterNickName(((PrivateMessage)chatMessage).getReceiveName()) + " ";
                        sTitle = sTitle + context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    } else {
                        sTitle = GenseeUtils.filterNickName(chatMessage.getSendUserName()) + " ";
                        sTitle = sTitle + context.getResources().getString(ResManager.getStringId("fs_gs_chat_to")) + " ";
                        sTitle = sTitle + context.getResources().getString(ResManager.getStringId("fs_gs_chat_me")) + " ";
                        sTitle = sTitle + context.getResources().getString(ResManager.getStringId("fs_gs_chat_say")) + " ";
                    }
                    this.tvTitle.setText((CharSequence)Html.fromHtml((String)("<u>" + sTitle + "</u>")));
                    this.tvTitle.setTextColor(context.getResources().getColor(ResManager.getColorId("fs_public_chat_item_to_tip")));
                } else {
                    GenseeLog.d((String)"publicchatadapter", (String)("privatemsg error = " + chatMessage));
                }
            }
        }
    }
}

