/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.os.Bundle;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.chat.ChatHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.PublicChatAdapter;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import java.util.List;

public class PublicChatSelfHolder
extends ChatHolder
implements AdapterView.OnItemLongClickListener,
View.OnTouchListener {
    private OnChatSelfHolderListener onChatSelfHolderListener;
    private int nowRawX;
    private int nowRawY;

    public void setOnChatSelfHolderListener(OnChatSelfHolderListener onChatSelfHolderListener) {
        this.onChatSelfHolderListener = onChatSelfHolderListener;
    }

    public PublicChatSelfHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void onClick(View v) {
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.findViewById(ResManager.getId("public_chat_view_root")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("fs_chat_bg")));
        this.lvChat.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                UserInfo userInfo = PublicChatSelfHolder.this.onChatItemClick(position, id);
                if (null != PublicChatSelfHolder.this.onChatSelfHolderListener) {
                    PublicChatSelfHolder.this.onChatSelfHolderListener.privateToUser(userInfo);
                }
            }
        });
        this.lvChat.setOnItemLongClickListener(this);
        this.lvChat.setOnTouchListener(this);
        this.adapter = new PublicChatAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
    }

    public void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("LATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                UserInfo self = PlayerLive.getIns().getSelf();
                MsgQueue.getIns().onSelfMessageFresh(self == null ? -1L : self.getId());
            }
        });
    }

    @Override
    public void show(boolean isShow) {
        this.rootView.setVisibility(isShow ? 0 : 8);
        if (isShow) {
            this.setLvBottom(true);
        }
    }

    @Override
    public void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                UserInfo self = PlayerLive.getIns().getSelf();
                MsgQueue.getIns().onSelfMessageLoadMore(self == null ? -1L : self.getId());
            }
        });
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        AbsChatMessage chatMessage = (AbsChatMessage)this.adapter.getItem(position - 1);
        String pureText = chatMessage.getText();
        if (TextUtils.isEmpty((CharSequence)pureText)) {
            return true;
        }
        if (pureText.startsWith("<span>") && pureText.endsWith("</span>")) {
            pureText = pureText.substring(6, pureText.length() - 7);
        }
        pureText = Html.fromHtml((String)pureText).toString();
        View anchor = null;
        anchor = view.findViewById(ResManager.getId("content_tv"));
        this.showCopyPopupWindow(anchor, false, this.nowRawX, this.nowRawY, pureText);
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.nowRawX = (int)event.getRawX();
        this.nowRawY = (int)event.getRawY();
        return false;
    }

    public void resetLvBottom(boolean bTrue) {
        this.setLvBottom(bTrue);
    }

    public static interface OnChatSelfHolderListener {
        public void privateToUser(UserInfo var1);
    }
}

