/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.bottom;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import com.gensee.fastsdk.adapter.GridViewAvatarAdapter;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.EmotionHolder;
import com.gensee.fastsdk.ui.holder.InputBottomHolder;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.holder.chat.impl.PlayerChatImpl;
import com.gensee.fastsdk.ui.holder.qa.impl.QaImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.routine.UserInfo;

public class QcInputBottomHolder
extends InputBottomHolder
implements GridViewAvatarAdapter.SelectAvatarInterface,
InputBottomHolder.OnQaBottomListener,
QaImpl.OnQaMsgBottomListener,
PlayerChatImpl.OnMsgBottomListener {
    private int lastSelectPosition;
    private EmotionHolder emotionHolder;

    public QcInputBottomHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.ivSelectSelf = (ImageView)this.findViewById(ResManager.getId("chat_bottom_self_iv"));
        this.ivSelectSelf.setOnClickListener((View.OnClickListener)this);
        ((PlayerChatImpl)value).setOnMsgBottomListener(this);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("gs_chat_avatar_iv")) {
            this.selectAvatar();
        }
    }

    protected void selectAvatar() {
        this.ivAvatar.setSelected(!this.ivAvatar.isSelected());
        if (this.ivAvatar.isSelected()) {
            this.hideKeyBoard();
        } else {
            this.showKeyBoard();
        }
        if (this.keyBoradStatus == 0) {
            this.emotionHolder.show(this.ivAvatar.isSelected());
            this.ivSelectSelf.setVisibility(this.ivAvatar.isSelected() ? 8 : 0);
        }
    }

    @Override
    protected void keyBoardShow(boolean bVisible) {
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        if (bVisible) {
            if (this.ivAvatar.isSelected()) {
                this.ivAvatar.setSelected(false);
                this.emotionHolder.show(false);
            }
            this.ivSelectSelf.setVisibility(8);
        } else {
            this.emotionHolder.show(this.ivAvatar.isSelected());
            if (!this.emotionHolder.isShow()) {
                if (this.nCurSelectIndex != 1) {
                    this.ivSelectSelf.setVisibility(0);
                }
            } else {
                this.ivSelectSelf.setVisibility(8);
            }
        }
    }

    @Override
    protected void initAvatar(View view) {
        if (null == this.emotionHolder) {
            this.emotionHolder = new EmotionHolder(view.findViewById(ResManager.getId("gs_viewpageexpressionlinear")), this);
        }
    }

    @Override
    public void hide() {
        this.ivAvatar.setSelected(false);
        this.emotionHolder.show(false);
        if (this.nCurSelectIndex != 1) {
            this.ivSelectSelf.setVisibility(0);
        }
        super.hide();
    }

    @Override
    public void selectAvatar(String sAvatar, Drawable drawable) {
        this.insertValue(sAvatar);
    }

    @Override
    protected void emotionPanel(boolean bVisible) {
        this.emotionHolder.show(bVisible);
        if (!bVisible) {
            this.ivAvatar.setSelected(false);
            if (this.nCurSelectIndex != 1) {
                this.ivSelectSelf.setVisibility(0);
            }
        }
    }

    @Override
    protected boolean processPublicChatDisable() {
        if (this.nCurSelectIndex == 0 && null != this.onPublicChatBottomListener && this.onPublicChatBottomListener.getChatMode() == 0) {
            this.showMsgBottom(this.getString(ResManager.getStringId("fs_chat_public_disable")));
            return true;
        }
        return false;
    }

    @Override
    protected void send(String text, String rich) {
        switch (this.nCurSelectIndex) {
            case 0: 
            case 3: {
                if (null == this.onPublicChatBottomListener) break;
                this.onPublicChatBottomListener.sendPublicMsg(text, rich);
                break;
            }
            case 1: {
                if (null == this.onPrivateChatBottomListener) break;
                this.onPrivateChatBottomListener.sendPrivateMsg(text, rich);
                break;
            }
            case 2: {
                if (null == this.onQaBottomListener) break;
                this.onQaBottomListener.sendQaMsg(text);
            }
        }
    }

    @Override
    public void onMessage(int what, Object obj, Bundle bundle) {
        super.onMessage(what, obj, bundle);
        switch (what) {
            case 40002: {
                if (this.nCurSelectIndex != 2 || null == obj) break;
                this.showMsgBottom(String.format(this.getString(ResManager.getStringId("fs_qa_reply_tip")), GenseeUtils.filterNickName((String)obj)));
                break;
            }
            case 40001: {
                if (this.nCurSelectIndex != 0 && this.nCurSelectIndex != 1) break;
                if (null == obj) {
                    return;
                }
                UserInfo toUser = (UserInfo)obj;
                this.showMsgBottom(String.format(this.getString(ResManager.getStringId("fs_chat_bottom_private_tip")), GenseeUtils.filterNickName(toUser.getName())));
            }
        }
    }

    @Override
    public void onPrivateMsg(final UserInfo toUser) {
        if (null == toUser) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if ((((LiveActivity)QcInputBottomHolder.this.getContext()).getUIMode() & 1) != 1) {
                    if (QcInputBottomHolder.this.nCurSelectIndex != 0 && QcInputBottomHolder.this.nCurSelectIndex != 1 || !QcInputBottomHolder.this.bResume) {
                        QcInputBottomHolder.this.tmpToUser = toUser;
                    }
                } else {
                    QcInputBottomHolder.this.tmpToUser = toUser;
                }
            }
        });
        if (this.nCurSelectIndex == 0) {
            if (MsgQueue.getIns().getSelfUserId() > 0L) {
                if (!MsgQueue.getIns().isSelfLatest() || null == this.onPublicChatBottomListener || !this.onPublicChatBottomListener.isSelfLvBottom()) {
                    this.removeMessages(40001);
                    this.sendMessage(40001, toUser);
                }
            } else if (!MsgQueue.getIns().isPublicLatest() || null == this.onPublicChatBottomListener || !this.onPublicChatBottomListener.isLvBottom()) {
                this.removeMessages(40001);
                this.sendMessage(40001, toUser);
            }
        } else if (this.nCurSelectIndex == 1 && null != this.onPrivateChatBottomListener) {
            if (this.onPrivateChatBottomListener.getToUserId() == toUser.getId()) {
                if (!MsgQueue.getIns().isPrivateLatest() || !this.onPrivateChatBottomListener.isLvBottom()) {
                    this.removeMessages(40001);
                    this.sendMessage(40001, toUser);
                }
            } else {
                this.removeMessages(40001);
                this.sendMessage(40001, toUser);
            }
        }
    }

    @Override
    public void onHistoryPrivateMsg() {
        if (null != this.tmpToUser && (this.nCurSelectIndex == 0 || this.nCurSelectIndex == 1)) {
            this.removeMessages(40001);
            UserInfo info = new UserInfo();
            info.setId(this.tmpToUser.getId());
            info.setName(this.tmpToUser.getName());
            this.sendMessage(40001, info);
            this.tmpToUser = null;
        }
    }

    @Override
    public void onHistoryQaMsg() {
        if (null != this.tmpQaName && this.nCurSelectIndex == 2) {
            this.removeMessages(40002);
            String info = new String(this.tmpQaName);
            this.sendMessage(40002, info);
            this.tmpQaName = null;
        }
    }

    public void onlyMeMsg(String msg) {
        this.showMsgBottom(msg);
    }

    @Override
    public void onQaEnable(final boolean isQaEnable, boolean isSystemMsg) {
        AbsChatImpl chatImpl;
        if (isSystemMsg && null != (chatImpl = ((LiveActivity)this.getContext()).getChatImpl())) {
            String sQa = this.getContext().getResources().getString(isQaEnable ? ResManager.getStringId("fs_qa_enable") : ResManager.getStringId("fs_qa_unenable"));
            ((PlayerChatImpl)chatImpl).onSysMsg(sQa);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (QcInputBottomHolder.this.nCurSelectIndex == 2) {
                    QcInputBottomHolder.this.qaEnable(isQaEnable);
                }
            }
        });
    }

    @Override
    public void onQaReplaySelf(final String answerName) {
        this.post(new Runnable(){

            @Override
            public void run() {
                QcInputBottomHolder.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if ((((LiveActivity)QcInputBottomHolder.this.getContext()).getUIMode() & 1) != 1) {
                            if (QcInputBottomHolder.this.nCurSelectIndex != 2 || !QcInputBottomHolder.this.bResume) {
                                QcInputBottomHolder.this.tmpQaName = answerName;
                            }
                        } else {
                            QcInputBottomHolder.this.tmpQaName = answerName;
                        }
                    }
                });
                if (QcInputBottomHolder.this.nCurSelectIndex == 2) {
                    if (QaMsgQueue.getIns().getSelfUserId() > 0L) {
                        if (!QaMsgQueue.getIns().isSelfQaLatest() || null == QcInputBottomHolder.this.onQaBottomListener || !QcInputBottomHolder.this.onQaBottomListener.isSelfLvBottom()) {
                            QcInputBottomHolder.this.removeMessages(40002);
                            QcInputBottomHolder.this.sendMessage(40002, answerName);
                        }
                    } else if (!QaMsgQueue.getIns().isQaLatest() || null == QcInputBottomHolder.this.onQaBottomListener || !QcInputBottomHolder.this.onQaBottomListener.isLvBottom()) {
                        QcInputBottomHolder.this.removeMessages(40002);
                        QcInputBottomHolder.this.sendMessage(40002, answerName);
                    }
                }
            }
        });
    }

    public void qaEnable(boolean bTrue) {
        this.edtChat.setVisibility(bTrue ? 0 : 8);
        this.tvSend.setEnabled(bTrue);
        this.lyChat.setEnabled(bTrue);
        this.ivAvatar.setEnabled(bTrue);
        this.tvChatTip.setVisibility(bTrue ? 8 : 0);
        this.chatLyBg();
        if (bTrue) {
            this.edtChat.setText((CharSequence)this.sQaContent);
            this.edtChat.setSelection(this.edtChat.getText().length());
        } else {
            this.tvChatTip.setText(ResManager.getStringId("fs_qa_unenable"));
            this.hideKeyBoard();
        }
    }

    @Override
    public boolean isSelfLvBottom() {
        return false;
    }

    @Override
    public boolean isLvBottom() {
        return false;
    }

    @Override
    public void sendQaMsg(String text) {
    }

    @Override
    public void querySelfMsg(boolean bSelected) {
    }
}

