/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.text.TextPaint;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.ResManager;
import java.util.Timer;
import java.util.TimerTask;

public class RollcallHolder
extends BaseHolder
implements PlayerLive.OnRollcallListener {
    private TextView tvRollcallTitle;
    private ImageView ivRollcallClose;
    private RelativeLayout rlRollcallGoing;
    private TextView tvRollcallGoingTime;
    private Button btnRollcallGoingtime;
    private Timer rollcallTimer;
    private TimerTask rollcallTask;
    private int nTotalTime;
    private RelativeLayout rlRollcallFinish;
    private static final float SCALE = 1.2f;

    public RollcallHolder(View rootView, Object value) {
        super(rootView, value);
        PlayerLive.getIns().setOnRollcallListener(this);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("rollcall_close_iv")) {
            this.close();
        } else if (v.getId() == ResManager.getId("rollcall_poging_roll_btn")) {
            this.roll();
        }
    }

    private void roll() {
        PlayerLive.getIns().roomRollcallAck(true);
        if (null != this.rollcallTimer) {
            this.rollcallTimer.cancel();
            this.rollcallTimer = null;
        }
        this.close();
    }

    private void close() {
        if (this.rootView.getVisibility() != 8) {
            this.rootView.setVisibility(8);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.tvRollcallTitle = (TextView)this.findViewById(ResManager.getId("rollcall_title_tv"));
        this.ivRollcallClose = (ImageView)this.findViewById(ResManager.getId("rollcall_close_iv"));
        this.ivRollcallClose.setOnClickListener((View.OnClickListener)this);
        this.rlRollcallGoing = (RelativeLayout)this.findViewById(ResManager.getId("rollcall_going_rl"));
        this.tvRollcallGoingTime = (TextView)this.findViewById(ResManager.getId("rollcall_goint_time_tv"));
        this.btnRollcallGoingtime = (Button)this.findViewById(ResManager.getId("rollcall_poging_roll_btn"));
        this.btnRollcallGoingtime.setOnClickListener((View.OnClickListener)this);
        this.rlRollcallFinish = (RelativeLayout)this.findViewById(ResManager.getId("rollcall_finish_ly"));
    }

    private void rollCallTimeOut() {
        if (this.nTotalTime <= 10) {
            AnimationSet anim = new AnimationSet(true);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    TextPaint paint = RollcallHolder.this.tvRollcallGoingTime.getPaint();
                    paint.setFakeBoldText(true);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    TextPaint paint = RollcallHolder.this.tvRollcallGoingTime.getPaint();
                    paint.setFakeBoldText(false);
                }
            });
            ScaleAnimation maxAnimation = new ScaleAnimation(1.0f, 1.2f, 1.0f, 1.2f, 1, 0.5f, 1, 0.5f);
            maxAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
            maxAnimation.setDuration(100L);
            ScaleAnimation minAnimation = new ScaleAnimation(1.2f, 1.0f, 1.2f, 1.0f, 1, 0.5f, 1, 0.5f);
            minAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            anim.addAnimation((Animation)maxAnimation);
            anim.addAnimation((Animation)minAnimation);
            minAnimation.setDuration(900L);
            this.tvRollcallGoingTime.startAnimation((Animation)anim);
        }
        this.tvRollcallGoingTime.setText((CharSequence)this.getTimerStr());
        if (this.nTotalTime <= 0) {
            this.tvRollcallGoingTime.clearAnimation();
            this.rollCallClose();
        }
    }

    private void rollCallClose() {
        if (null != this.rollcallTimer) {
            this.rollcallTimer.cancel();
            this.rollcallTimer = null;
        }
        PlayerLive.getIns().roomRollcallAck(false);
        this.tvRollcallTitle.setText((CharSequence)this.getString(ResManager.getStringId("fs_rollcall_finish")));
        this.rlRollcallFinish.setVisibility(0);
        this.rlRollcallGoing.setVisibility(8);
    }

    private void rollCall(int timeout) {
        if (null != this.rollcallTimer) {
            this.rollcallTimer.cancel();
            this.rollcallTimer = null;
        }
        this.tvRollcallTitle.setText((CharSequence)this.getString(ResManager.getStringId("fs_rollcall_going")));
        this.rootView.setVisibility(0);
        this.rlRollcallFinish.setVisibility(8);
        this.rlRollcallGoing.setVisibility(0);
        this.nTotalTime = timeout;
        this.tvRollcallGoingTime.clearAnimation();
        this.rollCallTimeOut();
        this.rollcallTimer = new Timer();
        this.rollcallTask = new TimerTask(){

            @Override
            public void run() {
                RollcallHolder.this.post(new Runnable(){

                    @Override
                    public void run() {
                        RollcallHolder.this.nTotalTime = RollcallHolder.this.nTotalTime - 1;
                        RollcallHolder.this.rollCallTimeOut();
                    }
                });
            }
        };
        this.rollcallTimer.schedule(this.rollcallTask, 1000L, 1000L);
    }

    private String getTimerStr() {
        String sValue = "";
        int m = this.nTotalTime / 60;
        int s = this.nTotalTime % 60;
        if (m < 10) {
            sValue = sValue + "0";
        }
        sValue = sValue + m;
        sValue = sValue + " : ";
        if (s < 10) {
            sValue = sValue + "0";
        }
        sValue = sValue + s;
        return sValue;
    }

    @Override
    public void onRollcall(final int timeout) {
        this.post(new Runnable(){

            @Override
            public void run() {
                RollcallHolder.this.rollCall(timeout);
            }
        });
    }
}

