/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import java.util.Arrays;

public class LotteryHolder
extends BaseHolder
implements PlayerLive.OnLotteryListener {
    private TextView tvLotteryTitle;
    private ImageView ivLotteryClose;
    private RelativeLayout rlLotteryGoing;
    private RelativeLayout rlLotteryFinish;
    private ListView lvLotteryFinish;
    private LotteryFinishAdapter mFinishAdapter;
    private RelativeLayout rlLotteryAbort;
    private TextView tvLotteryAbort;
    private static final int LOTTERY_BEGIN = 1;
    private static final int LOTTERY_FINISH = 2;
    private static final int LOTTERY_ABORT = 3;

    public LotteryHolder(View rootView, Object value) {
        super(rootView, value);
        PlayerLive.getIns().setOnLotteryListener(this);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("lottery_close_iv")) {
            this.close();
        }
    }

    private void close() {
        if (this.rootView.getVisibility() != 8) {
            this.rootView.setVisibility(8);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.tvLotteryTitle = (TextView)this.findViewById(ResManager.getId("lottery_title_tv"));
        this.ivLotteryClose = (ImageView)this.findViewById(ResManager.getId("lottery_close_iv"));
        this.ivLotteryClose.setOnClickListener((View.OnClickListener)this);
        this.rlLotteryGoing = (RelativeLayout)this.findViewById(ResManager.getId("lottery_going_ly"));
        this.rlLotteryFinish = (RelativeLayout)this.findViewById(ResManager.getId("lottery_finish_ly"));
        this.lvLotteryFinish = (ListView)this.findViewById(ResManager.getId("lottery_finish_lv"));
        this.mFinishAdapter = new LotteryFinishAdapter();
        this.lvLotteryFinish.setAdapter((ListAdapter)this.mFinishAdapter);
        this.rlLotteryAbort = (RelativeLayout)this.findViewById(ResManager.getId("lottery_abort_ly"));
        this.tvLotteryAbort = (TextView)this.findViewById(ResManager.getId("lottery_abort_tv"));
    }

    private void lottery(byte type, String sUserlist) {
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
        }
        if (type == 1) {
            this.lotteryBegin(sUserlist);
        } else if (type == 2) {
            this.lotteryFinish(sUserlist);
        } else if (type == 3) {
            this.lotteryAbort();
        }
    }

    private void lotteryBegin(String sUserList) {
        this.tvLotteryTitle.setText((CharSequence)this.getString(ResManager.getStringId("fs_lottery_going")));
        this.rlLotteryGoing.setVisibility(0);
        this.rlLotteryFinish.setVisibility(8);
        this.rlLotteryAbort.setVisibility(8);
    }

    private void lotteryFinish(String sUserList) {
        this.tvLotteryTitle.setText((CharSequence)this.getString(ResManager.getStringId("fs_lottery_name_list")));
        this.rlLotteryGoing.setVisibility(8);
        this.rlLotteryFinish.setVisibility(0);
        this.rlLotteryAbort.setVisibility(8);
        String[] users = sUserList.split("\r\n");
        if (null != this.mFinishAdapter) {
            this.mFinishAdapter.notifyData(Arrays.asList(users));
        }
    }

    private void lotteryAbort() {
        this.tvLotteryTitle.setText((CharSequence)this.getString(ResManager.getStringId("fs_lottery_pause")));
        this.rlLotteryGoing.setVisibility(8);
        this.rlLotteryFinish.setVisibility(8);
        this.rlLotteryAbort.setVisibility(0);
        this.tvLotteryAbort.setText((CharSequence)this.getString(ResManager.getStringId("fs_lottery_pause_tip")));
    }

    @Override
    public void onLottery(final byte type, final String sUserlist) {
        this.post(new Runnable(){

            @Override
            public void run() {
                LotteryHolder.this.lottery(type, sUserlist);
            }
        });
    }

    private class LotteryFinishAdapter
    extends AbstractAdapter {
        private LotteryFinishAdapter() {
        }

        protected View createView(Context context) {
            return LayoutInflater.from((Context)LotteryHolder.this.getContext()).inflate(ResManager.getLayoutId("fs_lottery_finish_item_layout"), null);
        }

        protected AbstractViewHolder createViewHolder(View view) {
            return new LotteryViewHolder(view);
        }

        private class LotteryViewHolder
        extends AbstractViewHolder {
            private TextView tvName;

            public LotteryViewHolder(View view) {
                super(view);
                if (view instanceof TextView) {
                    this.tvName = (TextView)view;
                }
            }

            public void initView(View view) {
            }

            public void initValue(int position) {
                if (null != this.tvName) {
                    this.tvName.setText((CharSequence)GenseeUtils.filterNickName((String)LotteryFinishAdapter.this.getItem(position)));
                }
            }
        }
    }
}

