/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;

public abstract class BaseHolder
extends Handler
implements View.OnClickListener {
    protected View rootView;

    public BaseHolder(View rootView, Object value, Object ... objects) {
        this.rootView = rootView;
        this.initData(value);
        this.initDatas(objects);
        this.initComp(value);
    }

    public BaseHolder(View rootView, Object value) {
        this.rootView = rootView;
        this.initData(value);
        this.initComp(value);
    }

    public BaseHolder(LayoutInflater inflater, int layoutID, Object value) {
        this(inflater.inflate(layoutID, null), value);
    }

    protected void initDatas(Object ... objects) {
    }

    public void sendMessage(int what, Object object) {
        this.sendMessage(this.obtainMessage(what, object));
    }

    public final void handleMessage(Message msg) {
        this.onMessage(msg.what, msg.obj, msg.getData());
    }

    public void onMessage(int what, Object obj, Bundle bundle) {
    }

    protected View findViewById(int resId) {
        return this.rootView.findViewById(resId);
    }

    protected abstract void initData(Object var1);

    protected abstract void initComp(Object var1);

    public void layout(Bundle saveInstance) {
    }

    protected Context getContext() {
        return this.rootView.getContext();
    }

    public View getRootView() {
        return this.rootView;
    }

    public String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    public void show(boolean isShow) {
        if (isShow) {
            if (0 != this.rootView.getVisibility()) {
                this.rootView.setVisibility(0);
            }
        } else if (8 != this.rootView.getVisibility()) {
            this.rootView.setVisibility(8);
        }
    }

    public boolean isShow() {
        return this.rootView.getVisibility() == 0;
    }

    protected void startIntent(Class<?> activityClass, Bundle bundle) {
        Intent intent = new Intent(this.getContext(), activityClass);
        intent.putExtras(bundle);
        this.getContext().startActivity(intent);
    }

    protected void startIntent(Class<?> activityClass) {
        Intent intent = new Intent(this.getContext(), activityClass);
        this.getContext().startActivity(intent);
    }

    public void onSaveInstence(Bundle outState) {
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
    }
}

