/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.view.CustomAmountDialog;
import com.gensee.fastsdk.ui.view.ResizeLayout;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import java.util.Timer;
import java.util.TimerTask;

public class AmountInputHolder
extends BaseHolder
implements ResizeLayout.OnResizeListener {
    private static final String TAG = "AmountInputHolder";
    private final CustomAmountDialog mDialog;
    private View ivCustomSumBack;
    private View lyBottomTop;
    protected static final int KEYBOARD_SHOW = 1;
    protected static final int KEYBOARD_HIDE = 0;
    protected int keyBoradStatus = 0;
    private InputMethodManager inputMethodManager;
    private EditText editText;
    private TextView tvAlipayCustomCommit;
    private int customMoney;

    public AmountInputHolder(View rootView, Object value) {
        super(rootView, value);
        this.mDialog = (CustomAmountDialog)((Object)value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        if (null != this.rootView && this.rootView instanceof ResizeLayout) {
            ((ResizeLayout)this.rootView).setOnResizeListener(this);
        }
        this.ivCustomSumBack = this.findViewById(ResManager.getId("gs_iv_custom_sum_back"));
        this.ivCustomSumBack.setOnClickListener((View.OnClickListener)this);
        if (!PlayerLive.getIns().isShowFixMoneyPanel()) {
            this.ivCustomSumBack.setVisibility(8);
        }
        this.tvAlipayCustomCommit = (TextView)this.findViewById(ResManager.getId("gs_tv_custom_commit"));
        this.tvAlipayCustomCommit.setOnClickListener((View.OnClickListener)this);
        this.tvAlipayCustomCommit.setEnabled(false);
        this.editText = (EditText)this.findViewById(ResManager.getId("gs_et_sponsor_sum"));
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String money = s.toString();
                double m = 0.0;
                if (!TextUtils.isEmpty((CharSequence)money)) {
                    try {
                        m = Double.parseDouble(money);
                    }
                    catch (Exception e) {
                        GenseeLog.e((String)AmountInputHolder.TAG, (String)"edit text input a empty string,return");
                        return;
                    }
                }
                if (money.contains(".") && s.length() - 1 - money.indexOf(".") > 2) {
                    s = money.subSequence(0, money.indexOf(".") + 3);
                    AmountInputHolder.this.editText.setText(s);
                    AmountInputHolder.this.editText.setSelection(s.length());
                }
                if (m >= 0.01 && m <= 2000.0) {
                    AmountInputHolder.this.tvAlipayCustomCommit.setEnabled(true);
                    AmountInputHolder.this.customMoney = (int)(m * 100.0);
                } else {
                    AmountInputHolder.this.tvAlipayCustomCommit.setEnabled(false);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.lyBottomTop = this.findViewById(ResManager.getId("input_bottom_top_ly"));
        this.lyBottomTop.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1) {
                    if (AmountInputHolder.this.keyBoradStatus == 1) {
                        AmountInputHolder.this.hideKeyBoard();
                    } else {
                        AmountInputHolder.this.mDialog.dismiss();
                    }
                }
                return false;
            }
        });
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_iv_custom_sum_back")) {
            this.mDialog.dismiss();
            if (PlayerLive.getIns().isShowFixMoneyPanel()) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((BaseWatchActivity)AmountInputHolder.this.getContext()).getRewardHolder().show(true);
                    }
                }, 150L);
            }
        } else if (v.getId() == ResManager.getId("gs_tv_custom_commit")) {
            GenseeLog.i((String)TAG, (String)"alipay custom amount onClick");
            ((BaseWatchActivity)this.getContext()).startAliPay(this.customMoney, " ");
        }
    }

    @Override
    public void OnResize(int h, int oldh) {
        if (h < oldh) {
            if (this.keyBoradStatus != 1) {
                this.keyBoradStatus = 1;
            }
        } else if (this.keyBoradStatus != 0) {
            this.keyBoradStatus = 0;
        }
    }

    public void hideKeyBoard() {
        if (null == this.inputMethodManager && this.inputMethodManager == null) {
            this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        }
        this.inputMethodManager.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
    }

    public void showKeyBoard() {
        if (this.inputMethodManager == null) {
            this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AmountInputHolder.this.inputMethodManager.toggleSoftInputFromWindow(AmountInputHolder.this.editText.getWindowToken(), 1, 0);
            }
        }, 100L);
    }

    protected void keyBoardShow(boolean bVisible) {
        if (!bVisible) {
            this.hideDialog();
        }
    }

    private void hideDialog() {
        if (null != this.mDialog && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }
}

