/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.os.Bundle;
import com.gensee.fastsdk.receiver.ConnectionReceiver;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public abstract class NetStatusActivity
extends BaseActivity
implements ConnectionReceiver.OnNetSwitchListener {
    private ConnectionReceiver connectionReceiver;
    protected int netStatus = 4;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void showDialogByNet(String msg, DialogInterface.OnClickListener l) {
        this.showErrMsg(null, msg, this.getString(ResManager.getStringId("fs_gs_exit")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                NetStatusActivity.this.exit();
            }
        }, this.getString(ResManager.getStringId("fs_gs_continues")), l, null);
    }

    @Override
    protected void registerAppReceiver() {
        if (null == this.connectionReceiver) {
            this.connectionReceiver = new ConnectionReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.registerReceiver(this.connectionReceiver, filter, 4);
        }
    }

    @Override
    protected void unRegisterReceiver() {
        GenseeLog.d((String)this.TAG, (String)"unRegisterReceiver");
        if (null != this.connectionReceiver) {
            this.unregisterReceiver(this.connectionReceiver);
            this.connectionReceiver = null;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.unRegisterReceiver();
    }

    protected String getNetTip(int netClassType) {
        switch (netClassType) {
            case 1: {
                return this.getString(ResManager.getStringId("fs_gs_net_2g"));
            }
            case 2: {
                return this.getString(ResManager.getStringId("fs_gs_net_3g"));
            }
            case 3: {
                return this.getString(ResManager.getStringId("fs_gs_net_4g"));
            }
            case 5: {
                return this.getString(ResManager.getStringId("fs_gs_net_no_network"));
            }
        }
        return this.getString(ResManager.getStringId("fs_gs_net_2g"));
    }

    protected void joinCheckNetwork() {
        int netClassType;
        this.netStatus = netClassType = ConnectionReceiver.getNetType((Context)this);
        if (netClassType == 4) {
            this.join();
        } else if (netClassType == 5) {
            this.showErrDialog(this.getString(ResManager.getStringId("fs_gs_net_no_network")), this.getString(ResManager.getStringId("fs_gs_i_known")));
        } else {
            this.showDialogByNet(this.getNetTip(netClassType), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    NetStatusActivity.this.join();
                }
            });
        }
    }

    @Override
    public void showErrDialog(String errorMsg, String sTip) {
        this.showErrMsg("", errorMsg, sTip, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NetStatusActivity.this.exit();
            }
        });
    }

    public abstract void exit();

    protected abstract void join();
}

