/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.core;

import android.content.Context;
import android.os.Bundle;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.DocInfo;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.QAMsg;
import com.gensee.entity.VodObject;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.core.PlayTime;
import com.gensee.fastsdk.entity.OfflinePlayParam;
import com.gensee.fastsdk.util.ConfigApp;
import com.gensee.media.GSOLPlayer;
import com.gensee.media.IVideoIndication;
import com.gensee.media.PlaySpeed;
import com.gensee.media.VODPlayer;
import com.gensee.offline.OnHistoryErrCodeListener;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import com.gensee.vod.VodMr;
import com.gensee.vod.VodSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class VodPlayerImp
implements VodSite.OnVodListener,
GSOLPlayer.OnOLPlayListener {
    public static final String VOD_SAVE_PLAY_STATUS = "VOD_SAVE_PLAYER_STATUS";
    public static final String VOD_SAVE_PLAY_POSITION = "VOD_SAVE_PLAY_POSITION";
    public static final String VOD_SAVE_PLAY_SPEED_RATE = "VOD_SAVE_PLAY_SPEED_RATE";
    private static final String TAG = "VodPlayerImp";
    private static final int VOD_PAUSE = 1;
    private static final int VOD_PLAY = 0;
    private static final int VOD_STOP = 2;
    private GSFastConfig.FastSdkVodStatusListener fastSdkVodStatusListener;
    private VODPlayer.OnVodPlayListener mVodPlayListener;
    private VODPlayer mVodPlayer;
    private VodSite vodSite;
    private boolean bOnPlaying = false;
    private String sCurrentVodId = "";
    private int vodPlayerStatus = 0;
    private int nSeekToTime = 0;
    private int prePosition = 0;
    private boolean isAutoPlaying = false;
    private IVideoIndication mGsVideoView;
    private GSDocViewGx mGsDocView;
    private PlaySpeed mCurPlaySpeed = PlaySpeed.SPEED_NORMAL;
    private boolean bSaveVodStatus = false;
    private int nSaveVodPlayerStatus = 0;
    private int nSavePrePosition = 0;
    private boolean isVideoStart = false;
    private OnVodInfoListener mOnVodInfoListener;
    private OnVodPlayerBarListener mOnVodPlayerBarListener;
    private OnVodChatListener mOnVodChatListener;
    private OnVodQaHistoryListener mOnVodQaHistoryListener;
    private OnVodDocListener mOnVodDocListener;
    private OnVodVideoListener mOnVodVideoListener;
    private OnVodChapterListener onVodChapterListener;
    private OnVodRecordInfoListener onVodRecordInfoListener;
    private InitParam mInitParam;
    private OfflinePlayParam offlinePlayParam;
    private Context context;
    private PlayTime playTime = PlayTime.ins;

    public void setVodPlayListener(VODPlayer.OnVodPlayListener vodPlayListener) {
        this.mVodPlayListener = vodPlayListener;
    }

    public GSFastConfig.FastSdkVodStatusListener getFastSdkVodStatusListener() {
        return this.fastSdkVodStatusListener;
    }

    public void setOnVodRecordInfoListener(OnVodRecordInfoListener onVodRecordInfoListener) {
        this.onVodRecordInfoListener = onVodRecordInfoListener;
    }

    public void setOnVodChapterListener(OnVodChapterListener onVodChapterListener) {
        this.onVodChapterListener = onVodChapterListener;
    }

    public void setOnVodVideoListener(OnVodVideoListener mOnVodVideoListener) {
        this.mOnVodVideoListener = mOnVodVideoListener;
    }

    public void setOnVodDocListener(OnVodDocListener mOnVodDocListener) {
        this.mOnVodDocListener = mOnVodDocListener;
    }

    public void setOnVodQaHistoryListener(OnVodQaHistoryListener mOnVodQaHistoryListener) {
        this.mOnVodQaHistoryListener = mOnVodQaHistoryListener;
    }

    public void setOnVodChatListener(OnVodChatListener mOnVodChatListener) {
        this.mOnVodChatListener = mOnVodChatListener;
    }

    public void setOnVodPlayerBarListener(OnVodPlayerBarListener mOnVodPlayerBarListener) {
        this.mOnVodPlayerBarListener = mOnVodPlayerBarListener;
    }

    public void setOnVodInfoListener(OnVodInfoListener mOnVodInfoListener) {
        this.mOnVodInfoListener = mOnVodInfoListener;
    }

    public VodPlayerImp(InitParam param, OfflinePlayParam offlinePlayParam) {
        this.mInitParam = param;
        this.offlinePlayParam = offlinePlayParam;
        GSFastConfig config = ConfigApp.getIns().getFastConfig();
        if (null != config) {
            this.nSeekToTime = config.getSeekPosition();
            this.fastSdkVodStatusListener = config.getFastSdkVodStatusListener();
            this.mVodPlayListener = config.getVodPlayListener();
            GenseeConfig.viColorSpace = config.isHardDecode() ? 255 : 3;
        }
        GenseeConfig.isNeedChatMsg = true;
        this.mVodPlayer = new VODPlayer(){

            protected void onRecordInfo(String startTime, String storage, String duration) {
                super.onRecordInfo(startTime, storage, duration);
                GenseeLog.i((String)VodPlayerImp.TAG, (String)("onRecordInfo startTime:" + startTime + ",storage:" + storage + ",duration:" + duration));
                if (null != VodPlayerImp.this.onVodRecordInfoListener) {
                    VodPlayerImp.this.onVodRecordInfoListener.onRecordInfo(startTime);
                }
            }
        };
    }

    public static long utcTimeToLocal(String utcTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Calendar calendar = Calendar.getInstance();
            long m_timezoneOffset = calendar.get(15) + calendar.get(16);
            return utcTime == null ? 0L : formatter.parse(utcTime).getTime() + m_timezoneOffset;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void initVod(Context mContext) {
        this.context = mContext;
        VodSite.init((Context)mContext, null);
        if (this.mInitParam != null) {
            this.vodSite = new VodSite(mContext);
            this.vodSite.setVodListener((VodSite.OnVodListener)this);
            this.vodSite.getVodObject(this.mInitParam);
        } else {
            this.sCurrentVodId = this.offlinePlayParam.getLocalPath();
            if (this.mOnVodInfoListener != null) {
                this.mOnVodInfoListener.onInitVodSuccess();
                this.mOnVodInfoListener.onVodSubject(this.offlinePlayParam.getSubject());
            }
        }
    }

    public void setGSVideoView(IVideoIndication mGsVideoView) {
        this.mGsVideoView = mGsVideoView;
        this.mVodPlayer.setGSVideoView(mGsVideoView);
    }

    public void setGSDocView(GSDocViewGx mGsDocView) {
        this.mGsDocView = mGsDocView;
        this.mVodPlayer.setGSDocViewGx(mGsDocView);
    }

    public void playVod() {
        this.playTime.clean();
        this.isVideoStart = false;
        this.bOnPlaying = true;
        this.mVodPlayer.setGSVideoView(this.mGsVideoView);
        this.mVodPlayer.setGSDocViewGx(this.mGsDocView);
        this.mVodPlayer.play(this.sCurrentVodId, (GSOLPlayer.OnOLPlayListener)this, "", false);
    }

    private void replyPlayer() {
        this.isVideoStart = false;
        if (!"".equals(this.sCurrentVodId)) {
            VodMr.getIns().putVodObj(VodMr.getIns().getVodObjById(this.sCurrentVodId));
            this.mVodPlayer.setGSVideoView(this.mGsVideoView);
            this.mVodPlayer.setGSDocViewGx(this.mGsDocView);
            this.mVodPlayer.setSpeed(PlaySpeed.SPEED_NORMAL, null);
            this.mVodPlayer.play(this.sCurrentVodId, (GSOLPlayer.OnOLPlayListener)this, "", false);
            this.bOnPlaying = true;
        }
    }

    public void release() {
        this.stopPlay();
        if (this.mVodPlayer != null) {
            this.mVodPlayer.release();
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onPlayStop();
        }
    }

    public boolean isOnPlaying() {
        return this.bOnPlaying;
    }

    public boolean isVideoStart() {
        return this.isVideoStart;
    }

    private void stopPlay() {
        if (this.mVodPlayer != null && this.vodPlayerStatus != 2) {
            this.mVodPlayer.stop();
        }
    }

    public void setSpeedRate(PlaySpeed mPlaySpeed) {
        this.mCurPlaySpeed = mPlaySpeed;
        this.mVodPlayer.setSpeed(mPlaySpeed, null);
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayerSpeedRate(this.mCurPlaySpeed);
        }
    }

    public void setPrePosition(int prePosition) {
        this.prePosition = prePosition;
    }

    public void pause() {
        if (this.vodPlayerStatus == 0) {
            this.mVodPlayer.pause();
        } else if (this.vodPlayerStatus == 1) {
            this.mVodPlayer.resume();
        } else if (this.vodPlayerStatus == 2) {
            GenseeLog.d((String)TAG, (String)("pause bOnPlaying = " + this.bOnPlaying));
            if (!this.bOnPlaying) {
                this.replyPlayer();
            }
        }
    }

    public void seekTo(int position) {
        if (null != this.mVodPlayer) {
            this.nSeekToTime = position;
            if (this.vodPlayerStatus != 2) {
                GenseeLog.d((String)TAG, (String)("seekTo timeStamp = " + position));
                this.realSeekTo(position);
                if (this.vodPlayerStatus == 1) {
                    this.mVodPlayer.resume();
                }
            } else if (!this.bOnPlaying) {
                this.replyPlayer();
            }
        }
    }

    private void realSeekTo(int position) {
        this.playTime.willSeek(position);
        this.mVodPlayer.seekTo(position);
    }

    public void getQatHistory(int nPageIndex, OnHistoryErrCodeListener errCodeListener) {
        if (this.isOnlinePlay()) {
            if (null != this.sCurrentVodId && !"".equals(this.sCurrentVodId)) {
                this.vodSite.getQaHistory(this.sCurrentVodId, nPageIndex, errCodeListener);
            }
        } else if (null != this.mOnVodQaHistoryListener) {
            this.mOnVodQaHistoryListener.onVodQaHistory(new ArrayList<QAMsg>(), 1, false);
        }
    }

    public void onChatHistory(String vodId, List<ChatMsg> chatMsgs, int pageIndex, boolean more) {
    }

    public void onQaHistory(String vodId, List<QAMsg> chatMsgs, int pageIndex, boolean more) {
        if (null != this.mOnVodQaHistoryListener) {
            this.mOnVodQaHistoryListener.onVodQaHistory(chatMsgs, pageIndex, more);
        }
    }

    public void onVodErr(int err) {
        GenseeLog.e((String)TAG, (String)("onVodErr:" + err));
        if (null != this.mOnVodInfoListener) {
            this.mOnVodInfoListener.onVodErr(err);
        }
    }

    public void onVodObject(String vodId) {
        this.sCurrentVodId = vodId;
        if (null != this.mOnVodInfoListener) {
            this.mOnVodInfoListener.onInitVodSuccess();
            VodObject vodObject = VodMr.getIns().getVodObjById(vodId);
            if (null != vodObject) {
                this.mOnVodInfoListener.onVodIntro((LiveInfo)vodObject);
                this.mOnVodInfoListener.onVodSubject(vodObject.getVodSubject());
            }
        }
    }

    public void onVodDetail(VodObject vodObject) {
    }

    public void onInit(int result, boolean haveVideo, int duration, List<DocInfo> docInfos) {
        GenseeLog.d((String)TAG, (String)("onInit() called with: result = [" + result + "], haveVideo = [" + haveVideo + "], duration = [" + duration + "], docInfos = [" + docInfos + "]"));
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayInit(duration);
        }
        if (null != this.mOnVodInfoListener) {
            this.mOnVodInfoListener.onVodInitPlayer();
        }
        if (!this.isVideoStart() && null != this.mOnVodVideoListener) {
            this.mOnVodVideoListener.onVodInitPlayer();
        }
        this.setSpeedRate(this.mCurPlaySpeed);
        if (!this.bSaveVodStatus) {
            if (this.nSeekToTime > 0) {
                this.realSeekTo(this.nSeekToTime);
            } else {
                this.playTime.willSeek(0L);
            }
            this.vodPlayerStatus = 0;
        } else {
            if (this.nSaveVodPlayerStatus == 0) {
                if (this.nSavePrePosition > 0) {
                    this.mVodPlayer.seekTo(this.nSavePrePosition);
                }
                this.vodPlayerStatus = 0;
            } else if (this.nSaveVodPlayerStatus == 1) {
                if (this.nSavePrePosition > 0) {
                    this.mVodPlayer.seekTo(this.nSavePrePosition);
                }
                this.mVodPlayer.pause();
            } else {
                this.mVodPlayer.stop();
                this.onPlayStop();
            }
            this.bSaveVodStatus = false;
        }
        if (null != this.onVodChapterListener && null != docInfos) {
            this.onVodChapterListener.onVodChapterData(docInfos);
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onInit(result, haveVideo, duration, docInfos);
        }
    }

    public void onPlayStop() {
        GenseeLog.d((String)TAG, (String)"onPlayStop: ");
        VodObject vod = VodMr.getIns().getVodObjById(this.sCurrentVodId);
        boolean isLoop = false;
        if (vod != null) {
            isLoop = vod.isLoop();
        }
        GenseeLog.d((String)TAG, (String)("onPlayStop: loop = " + isLoop));
        this.nSeekToTime = 0;
        this.prePosition = 0;
        if (isLoop) {
            this.replyPlayer();
        } else {
            if (null != this.mOnVodPlayerBarListener) {
                this.mOnVodPlayerBarListener.onVodPlayStop();
            }
            this.bOnPlaying = false;
            GenseeLog.d((String)TAG, (String)("onPlayStop bOnPlaying = " + this.bOnPlaying));
            this.vodPlayerStatus = 2;
            this.release();
        }
        if (null != this.fastSdkVodStatusListener) {
            this.fastSdkVodStatusListener.onVodStop();
        }
    }

    public void onPlayPause() {
        GenseeLog.d((String)TAG, (String)"onPlayPause: ");
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayPause();
        }
        this.vodPlayerStatus = 1;
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onPlayPause();
        }
    }

    public void onPlayResume() {
        GenseeLog.d((String)TAG, (String)"onPlayPause: ");
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayResume();
        }
        this.vodPlayerStatus = 0;
        this.isAutoPlaying = false;
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onPlayResume();
        }
    }

    public void onPosition(int position) {
        this.playTime.setPosition(position);
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayPosition(position);
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onPosition(position);
        }
    }

    public void onVideoSize(int position, int videoWidth, int videoHeight) {
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onVideoSize(position, videoWidth, videoHeight);
        }
    }

    public void onPageSize(int position, int width, int height) {
        if (null != this.mOnVodDocListener) {
            this.mOnVodDocListener.onVodDocPageSize(position, width, height);
        }
        if (null != this.onVodChapterListener) {
            this.onVodChapterListener.onVodChapterPosition(position);
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onVideoSize(position, width, height);
        }
    }

    public void onSeek(int position) {
        GenseeLog.d((String)TAG, (String)("onSeek: position = " + position));
        this.playTime.willSeek(position);
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayerSeek(position);
        }
        this.prePosition = position;
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onSeek(position);
        }
    }

    public void onAudioLevel(int level) {
    }

    public void onCaching(boolean isCaching) {
        if (this.mOnVodInfoListener != null) {
            this.mOnVodInfoListener.onCaching(isCaching);
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onCaching(isCaching);
        }
    }

    public void onVideoStart() {
        this.isVideoStart = true;
        if (null != this.mOnVodVideoListener) {
            this.mOnVodVideoListener.onVideoStart();
        }
        if (null != this.fastSdkVodStatusListener) {
            this.fastSdkVodStatusListener.onVodStart();
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onVideoStart();
        }
    }

    public void onVideoEnd() {
    }

    public void onFirstFrameNfy() {
    }

    public void onChat(List<ChatMsg> chatMsgs) {
        if (null != this.mOnVodChatListener) {
            this.mOnVodChatListener.onVodChatMsg(chatMsgs);
        }
    }

    public void selectVodChapter(int nSeekToTime) {
        if (null != this.mVodPlayer) {
            if (this.vodPlayerStatus != 2) {
                this.mVodPlayer.seekTo(nSeekToTime);
            } else if (!this.bOnPlaying) {
                this.nSeekToTime = nSeekToTime;
                this.replyPlayer();
            }
        }
    }

    public void onDocInfo(List<DocInfo> list) {
        if (null != this.onVodChapterListener && null != list) {
            this.onVodChapterListener.onVodChapterData(list);
        }
    }

    public void onStop() {
        if (this.vodPlayerStatus == 0) {
            this.isAutoPlaying = true;
            this.mVodPlayer.pause();
        }
    }

    public void onResume() {
        if (this.isAutoPlaying) {
            this.mVodPlayer.resume();
        }
    }

    public void onError(int errCode) {
        GenseeLog.d((String)TAG, (String)("onError() called with: errCode = [" + errCode + "]"));
        if (null != this.mOnVodPlayerBarListener) {
            this.mOnVodPlayerBarListener.onVodPlayerError(errCode);
        }
        if (errCode == 5 && null != this.mVodPlayer && this.prePosition > 0) {
            GenseeLog.d((String)TAG, (String)("onError prePosition = " + this.prePosition));
            this.mVodPlayer.seekTo(this.prePosition);
        }
        if (this.mVodPlayListener != null) {
            this.mVodPlayListener.onError(errCode);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(VOD_SAVE_PLAY_STATUS, this.vodPlayerStatus);
        outState.putInt(VOD_SAVE_PLAY_POSITION, this.prePosition);
        outState.putInt(VOD_SAVE_PLAY_SPEED_RATE, this.mCurPlaySpeed.getValue());
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (null != savedInstanceState) {
            this.bSaveVodStatus = true;
            this.nSaveVodPlayerStatus = savedInstanceState.getInt(VOD_SAVE_PLAY_STATUS);
            this.nSavePrePosition = savedInstanceState.getInt(VOD_SAVE_PLAY_POSITION);
            this.mCurPlaySpeed = PlaySpeed.values()[savedInstanceState.getInt(VOD_SAVE_PLAY_SPEED_RATE)];
        } else {
            this.bSaveVodStatus = false;
        }
    }

    public boolean isParamValid() {
        return this.mInitParam != null || this.offlinePlayParam != null && this.offlinePlayParam.isValid();
    }

    public boolean isOnlinePlay() {
        return this.mInitParam != null;
    }

    public void onChatCensor(String type, String id) {
    }

    public void onBroadCastMsg(List<BroadCastMsg> list) {
    }

    public void onLayoutSet(int timeStamp, int layout) {
    }

    public void onRecordInfo(long startTime, long storage, long duration) {
    }

    public static interface OnVodRecordInfoListener {
        public void onRecordInfo(String var1);
    }

    public static interface OnVodChapterListener {
        public void onVodChapterData(List<DocInfo> var1);

        public void onVodChapterPosition(int var1);
    }

    public static interface OnVodVideoListener {
        public void onVideoStart();

        public void onVodInitPlayer();
    }

    public static interface OnVodDocListener {
        public void onVodDocPageSize(int var1, int var2, int var3);
    }

    public static interface OnVodQaHistoryListener {
        public void onVodQaHistory(List<QAMsg> var1, int var2, boolean var3);
    }

    public static interface OnVodChatListener {
        public void onVodChatMsg(List<ChatMsg> var1);
    }

    public static interface OnVodPlayerBarListener {
        public void onVodPlayInit(int var1);

        public void onVodPlayStop();

        public void onVodPlayPause();

        public void onVodPlayResume();

        public void onVodPlayPosition(int var1);

        public void onVodPlayerSeek(int var1);

        public void onVodPlayerError(int var1);

        public void onVodPlayerSpeedRate(PlaySpeed var1);
    }

    public static interface OnVodInfoListener {
        public void onInitVodSuccess();

        public void onVodSubject(String var1);

        public void onVodErr(int var1);

        public void onVodInitPlayer();

        public void onCaching(boolean var1);

        public void onVodIntro(LiveInfo var1);
    }
}

