/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.device;

import android.content.Context;
import com.ta.utdid2.android.utils.PhoneInfoUtils;
import com.ta.utdid2.android.utils.StringUtils;
import com.ta.utdid2.device.Device;
import com.ta.utdid2.device.UTUtdid;
import java.util.zip.Adler32;

public class DeviceInfo {
    private static Device mDevice = null;
    static String HMAC_KEY = "d6fc3a4a06adbde89223bvefedc24fecde188aaa9161";
    static final Object CREATE_DEVICE_METADATA_LOCK = new Object();
    static final byte UTDID_VERSION_CODE = 1;

    static long getMetadataCheckSum(Device device) {
        String checkSumContent;
        if (device != null && !StringUtils.isEmpty(checkSumContent = String.format("%s%s%s%s%s", device.getUtdid(), device.getDeviceId(), device.getCreateTimestamp(), device.getImsi(), device.getImei()))) {
            Adler32 adler32 = new Adler32();
            adler32.reset();
            adler32.update(checkSumContent.getBytes());
            long checkSum = adler32.getValue();
            return checkSum;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Device _initDeviceMetadata(Context aContext) {
        if (aContext != null) {
            Device device = new Device();
            Object object = CREATE_DEVICE_METADATA_LOCK;
            synchronized (object) {
                String utdid = UTUtdid.instance(aContext).getValue();
                if (!StringUtils.isEmpty(utdid)) {
                    if (utdid.endsWith("\n")) {
                        utdid = utdid.substring(0, utdid.length() - 1);
                    }
                    device = new Device();
                    long timestamp = System.currentTimeMillis();
                    String imei = PhoneInfoUtils.getImei(aContext);
                    String imsi = PhoneInfoUtils.getImsi(aContext);
                    device.setDeviceId(imei);
                    device.setImei(imei);
                    device.setCreateTimestamp(timestamp);
                    device.setImsi(imsi);
                    device.setUtdid(utdid);
                    device.setCheckSum(DeviceInfo.getMetadataCheckSum(device));
                    return device;
                }
            }
        }
        return null;
    }

    public static synchronized Device getDevice(Context context) {
        if (mDevice != null) {
            return mDevice;
        }
        if (context != null) {
            Device device;
            mDevice = device = DeviceInfo._initDeviceMetadata(context);
            return device;
        }
        return null;
    }
}

