/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.core.persistent;

import android.util.Xml;
import com.ta.utdid2.core.persistent.FastXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class XmlUtils {
    XmlUtils() {
    }

    public static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    public static final int convertValueToList(CharSequence value, String[] options, int defaultValue) {
        if (value != null) {
            int i2 = 0;
            while (i2 < options.length) {
                if (value.equals(options[i2])) {
                    return i2;
                }
                ++i2;
            }
        }
        return defaultValue;
    }

    public static final boolean convertValueToBoolean(CharSequence value, boolean defaultValue) {
        boolean result = false;
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("1") || value.equals("true") || value.equals("TRUE")) {
            result = true;
        }
        return result;
    }

    public static final int convertValueToInt(CharSequence charSeq, int defaultValue) {
        if (charSeq == null) {
            return defaultValue;
        }
        String nm = charSeq.toString();
        int sign = 1;
        int index = 0;
        int len = nm.length();
        int base = 10;
        if ('-' == nm.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == nm.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c2 = nm.charAt(index + 1);
            if ('x' == c2 || 'X' == c2) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == nm.charAt(index)) {
            ++index;
            base = 16;
        }
        return Integer.parseInt(nm.substring(index), base) * sign;
    }

    public static final int convertValueToUnsignedInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return XmlUtils.parseUnsignedIntAttribute(value);
    }

    public static final int parseUnsignedIntAttribute(CharSequence charSeq) {
        String value = charSeq.toString();
        int index = 0;
        int len = value.length();
        int base = 10;
        if ('0' == value.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c2 = value.charAt(index + 1);
            if ('x' == c2 || 'X' == c2) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == value.charAt(index)) {
            ++index;
            base = 16;
        }
        return (int)Long.parseLong(value.substring(index), base);
    }

    public static final void writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        FastXmlSerializer serializer = new FastXmlSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    public static final void writeListXml(List val, OutputStream out) throws XmlPullParserException, IOException {
        XmlSerializer serializer = Xml.newSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument(null, Boolean.valueOf(true));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeListXml(val, null, serializer);
        serializer.endDocument();
    }

    public static final void writeMapXml(Map val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        Set s2 = val.entrySet();
        Iterator i2 = s2.iterator();
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        while (i2.hasNext()) {
            Map.Entry e2 = i2.next();
            XmlUtils.writeValueXml(e2.getValue(), (String)e2.getKey(), out);
        }
        out.endTag(null, "map");
    }

    public static final void writeListXml(List val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.size();
        int i2 = 0;
        while (i2 < N) {
            XmlUtils.writeValueXml(val.get(i2), null, out);
            ++i2;
        }
        out.endTag(null, "list");
    }

    public static final void writeByteArrayXml(byte[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        StringBuilder sb = new StringBuilder(val.length * 2);
        int i2 = 0;
        while (i2 < N) {
            byte b2 = val[i2];
            int h2 = b2 >> 4;
            sb.append(h2 >= 10 ? 97 + h2 - 10 : 48 + h2);
            h2 = b2 & 0xFF;
            sb.append(h2 >= 10 ? 97 + h2 - 10 : 48 + h2);
            ++i2;
        }
        out.text(sb.toString());
        out.endTag(null, "byte-array");
    }

    public static final void writeIntArrayXml(int[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        int i2 = 0;
        while (i2 < N) {
            out.startTag(null, "item");
            out.attribute(null, "value", Integer.toString(val[i2]));
            out.endTag(null, "item");
            ++i2;
        }
        out.endTag(null, "int-array");
    }

    public static final void writeValueXml(Object v2, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        String typeStr;
        if (v2 == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v2 instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v2.toString());
            out.endTag(null, "string");
            return;
        }
        if (v2 instanceof Integer) {
            typeStr = "int";
        } else if (v2 instanceof Long) {
            typeStr = "long";
        } else if (v2 instanceof Float) {
            typeStr = "float";
        } else if (v2 instanceof Double) {
            typeStr = "double";
        } else if (v2 instanceof Boolean) {
            typeStr = "boolean";
        } else {
            if (v2 instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v2, name, out);
                return;
            }
            if (v2 instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v2, name, out);
                return;
            }
            if (v2 instanceof Map) {
                XmlUtils.writeMapXml((Map)v2, name, out);
                return;
            }
            if (v2 instanceof List) {
                XmlUtils.writeListXml((List)v2, name, out);
                return;
            }
            if (v2 instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v2.toString());
                out.endTag(null, "string");
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v2);
        }
        out.startTag(null, typeStr);
        if (name != null) {
            out.attribute(null, "name", name);
        }
        out.attribute(null, "value", v2.toString());
        out.endTag(null, typeStr);
    }

    public static final HashMap readMapXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static final ArrayList readListXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (ArrayList)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static final HashMap readThisMapXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                if (name[0] != null) {
                    map.put(name[0], val);
                    continue;
                }
                throw new XmlPullParserException("Map value without name attribute: " + parser.getName());
            }
            if (eventType != 3) continue;
            if (parser.getName().equals(endTag)) {
                return map;
            }
            throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
        } while ((eventType = parser.next()) != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static final ArrayList readThisListXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                list.add(val);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals(endTag)) {
                return list;
            }
            throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
        } while ((eventType = parser.next()) != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int[] readThisIntArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e2) {
            throw new XmlPullParserException("Need num attribute in byte-array");
        }
        catch (NumberFormatException e3) {
            throw new XmlPullParserException("Not a number in num attribute in byte-array");
        }
        int[] array = new int[num];
        int i2 = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array[i2] = Integer.parseInt(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e4) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e5) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else {
                if (eventType != 3) continue;
                if (parser.getName().equals(endTag)) {
                    return array;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i2;
            }
        } while ((eventType = parser.next()) != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static final Object readValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            try {
                eventType = parser.next();
            }
            catch (Exception e2) {
                throw new XmlPullParserException("Unexpected call next(): " + parser.getName());
            }
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Object readThisValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                valueName = parser.getAttributeValue(null, "name");
                                tagName = parser.getName();
                                if (!tagName.equals("null")) break block12;
                                res /* !! */  = null;
                                ** GOTO lbl70
                            }
                            if (tagName.equals("string")) {
                                value = "";
                                while ((eventType = parser.next()) != 1) {
                                    if (eventType == 3) {
                                        if (parser.getName().equals("string")) {
                                            name[0] = valueName;
                                            return value;
                                        }
                                        throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                                    }
                                    if (eventType == 4) {
                                        value = String.valueOf(value) + parser.getText();
                                        continue;
                                    }
                                    if (eventType != 2) continue;
                                    throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                                }
                                throw new XmlPullParserException("Unexpected end of document in <string>");
                            }
                            if (!tagName.equals("int")) break block13;
                            res /* !! */  = Integer.parseInt(parser.getAttributeValue(null, "value"));
                            ** GOTO lbl70
                        }
                        if (!tagName.equals("long")) break block14;
                        res /* !! */  = Long.valueOf(parser.getAttributeValue(null, "value"));
                        ** GOTO lbl70
                    }
                    if (!tagName.equals("float")) break block15;
                    res /* !! */  = new Float(parser.getAttributeValue(null, "value"));
                    ** GOTO lbl70
                }
                if (!tagName.equals("double")) break block16;
                res /* !! */  = new Double(parser.getAttributeValue(null, "value"));
                ** GOTO lbl70
            }
            if (!tagName.equals("boolean")) break block17;
            res /* !! */  = Boolean.valueOf(parser.getAttributeValue(null, "value"));
            if (true) ** GOTO lbl70
        }
        if (tagName.equals("int-array")) {
            parser.next();
            res = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
            name[0] = valueName;
            return res;
        }
        if (tagName.equals("map")) {
            parser.next();
            res = XmlUtils.readThisMapXml(parser, "map", name);
            name[0] = valueName;
            return res;
        }
        if (tagName.equals("list")) {
            parser.next();
            res = XmlUtils.readThisListXml(parser, "list", name);
            name[0] = valueName;
            return res;
        }
        throw new XmlPullParserException("Unknown tag: " + tagName);
        do {
            if (eventType == 3) {
                if (parser.getName().equals(tagName)) {
                    name[0] = valueName;
                    return res /* !! */ ;
                }
                throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
            }
            if (eventType != 2) continue;
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
lbl70:
            // 7 sources

        } while ((eventType = parser.next()) != 1);
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }

    public static final void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    public static final void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
    }
}

