/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import com.gensee.beauty.GPUFilterDataRead;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.beauty.PixelBuffer;
import com.gensee.beauty.TextureViewRender;
import com.gensee.beauty.filter.FilterSetting;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.beauty.GSGlSurfaceView;
import com.gensee.view.beauty.GSTextureView;
import com.gensee.view.beauty.IGSLocalVideoViewImp;

public class GSVideoProcess
implements GPUFilterDataRead.OnPrepareDataSendListener {
    private static final String TAG = "GSVideoProcess";
    private Context mContext;
    private GPUImageRenderer mRenderer;
    private GPUImageRenderer.ScaleType mScaleType = GPUImageRenderer.ScaleType.CENTER_CROP;
    private TextureViewRender mTextureViewRender;
    private IGSLocalVideoViewImp mLocalVideoViewImp;
    private GPUFilterDataRead mGpuFilterDataRead;
    private int nViewWidth;
    private int nViewHeight;
    private FilterSetting mFilterSetting;
    private OnSendDataListener onSendDataListener;
    private GPUImageRenderer.OnDataNotifyListener onDataNotifyListener = new GPUImageRenderer.OnDataNotifyListener(){

        @Override
        public void onNotifyData() {
            if (null != GSVideoProcess.this.mLocalVideoViewImp) {
                if (GSVideoProcess.this.mLocalVideoViewImp instanceof GSGlSurfaceView) {
                    ((GSGlSurfaceView)GSVideoProcess.this.mLocalVideoViewImp).queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            ((GSGlSurfaceView)GSVideoProcess.this.mLocalVideoViewImp).requestRender();
                        }
                    });
                } else if (null != GSVideoProcess.this.mTextureViewRender) {
                    GSVideoProcess.this.mTextureViewRender.requestRender();
                } else {
                    GenseeLog.w((String)GSVideoProcess.TAG, (String)" onNotifyData mTextureViewRender is null");
                }
            } else {
                GenseeLog.w((String)GSVideoProcess.TAG, (String)" onNotifyData view is null");
            }
        }
    };

    public void setOnSendDataListener(OnSendDataListener onSendDataListener) {
        this.onSendDataListener = onSendDataListener;
    }

    public GSVideoProcess(Context mContext, IGSLocalVideoViewImp mLocalVideoViewImp) {
        this.mContext = mContext;
        this.mLocalVideoViewImp = mLocalVideoViewImp;
        if (!this.supportsOpenGLES2(mContext)) {
            throw new IllegalStateException("OpenGL ES 2.0 is not supported on this phone.");
        }
        this.mGpuFilterDataRead = new GPUFilterDataRead();
        this.mGpuFilterDataRead.setOnPrepareDataSendListener(this);
        PixelBuffer.isSupportGLES3 = this.supportsOpenGLES3(mContext);
        this.init();
    }

    public void releaseGlViewRender() {
        if (this.mLocalVideoViewImp instanceof GSGlSurfaceView) {
            ((GSGlSurfaceView)this.mLocalVideoViewImp).queueEvent(new Runnable(){

                @Override
                public void run() {
                    GSVideoProcess.this.mRenderer.destroy();
                    ((GSGlSurfaceView)GSVideoProcess.this.mLocalVideoViewImp).requestRender();
                }
            });
        }
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.mFilterSetting.setVideoDataPng(mBitmap);
        if (this.nViewWidth > 0 && this.nViewHeight > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.nViewWidth, this.nViewHeight);
        }
        this.mGpuFilterDataRead.setVideoDataPng(mBitmap);
    }

    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.mFilterSetting.setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight);
        if (this.nViewWidth > 0 && this.nViewHeight > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.nViewWidth, this.nViewHeight);
        }
        this.mGpuFilterDataRead.setVideoDataPng(mBitmap, desVideoLogoMarginTop, desVideoLogoMarginRight);
    }

    private void init() {
        this.mFilterSetting = new FilterSetting();
        this.mRenderer = new GPUImageRenderer(this.mFilterSetting.getFilter());
        this.mFilterSetting.setRenderer(this.mRenderer);
        this.mRenderer.setOnDataPrepareListener(this.mGpuFilterDataRead);
        this.mRenderer.setOnDataNotifyListener(this.onDataNotifyListener);
        if (this.mLocalVideoViewImp instanceof GSGlSurfaceView) {
            this.setGLSurfaceView((GLSurfaceView)this.mLocalVideoViewImp);
        }
    }

    public void initTextureRender(SurfaceTexture surfaceTexture, int width, int height) {
        if (null == this.mTextureViewRender) {
            this.mTextureViewRender = new TextureViewRender(surfaceTexture, width, height, this.mRenderer);
        } else {
            this.mTextureViewRender.updateSurfaceTexture(surfaceTexture, width, height);
        }
        this.mFilterSetting.resolveVideoDataPng(width, height);
        this.nViewWidth = width;
        this.nViewHeight = height;
    }

    public void changeSizeTextureRender(int width, int height) {
        this.mTextureViewRender.surfaceChange(width, height);
    }

    public void releaseTextureRender() {
        if (null != this.mTextureViewRender) {
            this.mTextureViewRender.release();
        }
        if (null != this.mGpuFilterDataRead) {
            this.mGpuFilterDataRead.releaseSendThread();
        }
        this.mFilterSetting.release();
    }

    public void switchBeauty(boolean bOpen) {
        this.mGpuFilterDataRead.switchBeauty(bOpen);
        this.mFilterSetting.switchBeauty(bOpen);
    }

    private void setGLSurfaceView(GLSurfaceView view) {
        view.setEGLContextClientVersion(2);
        view.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        view.getHolder().setFormat(1);
        view.setRenderer((GLSurfaceView.Renderer)this.mRenderer);
        view.setRenderMode(0);
        view.requestRender();
    }

    private boolean supportsOpenGLES2(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return configurationInfo.reqGlEsVersion >= 131072;
    }

    private boolean supportsOpenGLES3(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean isSupport = configurationInfo.reqGlEsVersion >= 196608;
        GenseeLog.w((String)TAG, (String)("supportsOpenGLES3 = " + isSupport));
        return isSupport;
    }

    public void caculateRotate(boolean bCameraFront, int result, int orientation) {
        boolean flipHorizontal = false;
        boolean flipVertical = false;
        Rotation rotation = Rotation.NORMAL;
        switch (result) {
            case 0: {
                flipHorizontal = bCameraFront;
                break;
            }
            case 90: {
                rotation = Rotation.ROTATION_90;
                flipVertical = bCameraFront;
                break;
            }
            case 180: {
                rotation = Rotation.ROTATION_180;
                flipHorizontal = bCameraFront;
                break;
            }
            case 270: {
                rotation = Rotation.ROTATION_270;
                flipVertical = bCameraFront;
            }
        }
        this.mRenderer.setRotationCamera(rotation, flipHorizontal, flipVertical);
        if (null != this.mGpuFilterDataRead) {
            this.mGpuFilterDataRead.setOrientation(orientation);
        }
    }

    public void release() {
        if (null != this.mRenderer) {
            this.mRenderer.clearRunOnDraw();
        }
        if (null != this.mLocalVideoViewImp) {
            if (this.mLocalVideoViewImp instanceof GSGlSurfaceView) {
                ((GSGlSurfaceView)this.mLocalVideoViewImp).requestRender();
            } else if (this.mLocalVideoViewImp instanceof GSTextureView) {
                if (null != this.mTextureViewRender) {
                    this.mTextureViewRender.requestRender();
                } else {
                    GenseeLog.w((String)TAG, (String)" toStartPreview mTextureViewRender is null");
                }
            }
        }
    }

    @Override
    public void onSendData(byte[] yuv12, int realWidth, int realHeigth) {
        if (null != this.onSendDataListener) {
            this.onSendDataListener.onSendData(yuv12, realWidth, realHeigth);
        }
    }

    public void notifyData(byte[] data, int width, int height) {
        if (null == data) {
            return;
        }
        this.mRenderer.notifyData(data, width, height);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.mRenderer.setSurfaceTexture(surfaceTexture);
    }

    public void toStartPreview(VideoParam videoParam) {
        if (null != this.mLocalVideoViewImp) {
            if (this.mLocalVideoViewImp instanceof GSGlSurfaceView) {
                ((GSGlSurfaceView)this.mLocalVideoViewImp).requestRender();
            } else if (this.mLocalVideoViewImp instanceof GSTextureView) {
                if (null != this.mTextureViewRender) {
                    this.mTextureViewRender.requestRender();
                } else {
                    GenseeLog.w((String)TAG, (String)" toStartPreview mTextureViewRender is null");
                }
            }
        }
        if (null != this.mGpuFilterDataRead) {
            this.mGpuFilterDataRead.startSendThread();
            this.mGpuFilterDataRead.setVideoParam(videoParam);
        }
    }

    public static interface OnSendDataListener {
        public void onSendData(byte[] var1, int var2, int var3);
    }
}

