/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import com.gensee.view.VideoCameraCapture;
import com.gensee.view.beauty.GSVideoProcess;
import com.gensee.view.beauty.IGSLocalVideoViewImp;
import com.gensee.view.beauty.IGSVideoCapture;
import java.io.IOException;
import java.util.Calendar;

class GSVideoCapture
extends VideoCameraCapture
implements GSVideoProcess.OnSendDataListener,
IGSVideoCapture {
    private static final String TAG = "GSVideoCapture";
    private GSVideoProcess videoProcess;
    private Camera.Size previewSize;
    long nTime1 = Calendar.getInstance().getTimeInMillis();
    int nFrameCount = 0;
    long nFrameCountTime = Calendar.getInstance().getTimeInMillis();

    public GSVideoCapture(Context mContext, IGSLocalVideoViewImp mLocalVideoViewImp) {
        this.videoProcess = new GSVideoProcess(mContext, mLocalVideoViewImp);
        this.videoProcess.setOnSendDataListener(this);
    }

    @Override
    public void releaseGlViewRender() {
        this.videoProcess.releaseGlViewRender();
    }

    @Override
    public void setVideoDataPng(Bitmap mBitmap) {
        this.videoProcess.setVideoDataPng(mBitmap);
    }

    @Override
    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.videoProcess.setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight, desVideoLogoMarginTop, desVideoLogoMarginRight);
    }

    @Override
    public void initTextureRender(SurfaceTexture surfaceTexture, int width, int height) {
        this.videoProcess.initTextureRender(surfaceTexture, width, height);
    }

    @Override
    public void changeSizeTextureRender(int width, int height) {
        this.videoProcess.changeSizeTextureRender(width, height);
    }

    @Override
    public void releaseTextureRender() {
        this.videoProcess.releaseTextureRender();
    }

    @Override
    public void switchBeauty(boolean bOpen) {
        this.videoProcess.switchBeauty(bOpen);
    }

    @Override
    protected void caculateRotate() {
        Context context = this.captureCallBack.getContext();
        int result = 0;
        result = context instanceof Activity ? this.getCameraOrientation((Activity)context, this.cameraInfo) : (2 == this.orientation || 12 == this.orientation ? 0 : this.cameraInfo.orientation);
        boolean bCameraFront = this.cameraInfo.facing == 1;
        this.videoProcess.caculateRotate(bCameraFront, result, this.orientation);
    }

    @Override
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (null != this.previewSize) {
            this.videoProcess.notifyData(data, this.previewSize.width, this.previewSize.height);
        }
    }

    private void setUpSurfaceTexture(Camera camera) {
        try {
            SurfaceTexture mSurfaceTexture = new SurfaceTexture(36197);
            this.videoProcess.setSurfaceTexture(mSurfaceTexture);
            camera.setPreviewTexture(mSurfaceTexture);
            this.previewSize = camera.getParameters().getPreviewSize();
            camera.setPreviewCallback((Camera.PreviewCallback)this);
            camera.startPreview();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void toStartPreview(Camera mCamera, int cameraId) throws Exception {
        this.setUpSurfaceTexture(mCamera);
        this.videoProcess.toStartPreview(this.videoParam);
    }

    private int getCameraOrientation(Activity activity, Camera.CameraInfo info) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int result = info.facing == 1 ? (info.orientation + degrees) % 360 : (info.orientation - degrees + 360) % 360;
        return result;
    }

    @Override
    public void onSendData(byte[] yuv12, int realWidth, int realHeight) {
        this.sendOpenGlYuvData(yuv12, realWidth, realHeight);
    }

    @Override
    public boolean releaseCamera() {
        boolean bRelease = super.releaseCamera();
        this.videoProcess.release();
        return bRelease;
    }
}

