/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import com.gensee.utils.GenseeLog;
import com.gensee.view.VideoCamera2Capture;
import com.gensee.view.beauty.GSVideoProcess;
import com.gensee.view.beauty.IGSLocalVideoViewImp;
import com.gensee.view.beauty.IGSVideoCapture;

@TargetApi(value=21)
public class GSVideoCamera2Capture
extends VideoCamera2Capture
implements GSVideoProcess.OnSendDataListener,
IGSVideoCapture {
    private static final String TAG = "GSVideoCamera2Capture";
    private GSVideoProcess videoProcess;

    public GSVideoCamera2Capture(Context mContext, IGSLocalVideoViewImp mLocalVideoViewImp) {
        this.videoProcess = new GSVideoProcess(mContext, mLocalVideoViewImp);
        this.videoProcess.setOnSendDataListener(this);
    }

    @Override
    public void releaseGlViewRender() {
        this.videoProcess.releaseGlViewRender();
    }

    @Override
    public void setVideoDataPng(Bitmap mBitmap) {
        this.videoProcess.setVideoDataPng(mBitmap);
    }

    @Override
    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.videoProcess.setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight, desVideoLogoMarginTop, desVideoLogoMarginRight);
    }

    @Override
    public void initTextureRender(SurfaceTexture surfaceTexture, int width, int height) {
        this.videoProcess.initTextureRender(surfaceTexture, width, height);
    }

    @Override
    public void changeSizeTextureRender(int width, int height) {
        this.videoProcess.changeSizeTextureRender(width, height);
    }

    @Override
    public void releaseTextureRender() {
        this.videoProcess.releaseTextureRender();
    }

    @Override
    public void switchBeauty(boolean bOpen) {
        this.videoProcess.switchBeauty(bOpen);
    }

    @Override
    protected void caculateRotate() {
        if (null == this.characteristics) {
            return;
        }
        Context context = this.captureCallBack.getContext();
        int result = 0;
        result = context instanceof Activity ? this.getCameraOrientation((Activity)context) : (2 == this.orientation || 12 == this.orientation ? 0 : (Integer)this.characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION));
        boolean bCameraFront = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.videoProcess.caculateRotate(bCameraFront, result, this.orientation);
    }

    private int getCameraOrientation(Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int result = degrees;
        if (null != this.characteristics) {
            result = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING) == 0 ? ((Integer)this.characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION) + degrees) % 360 : ((Integer)this.characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION) - degrees + 360) % 360;
        } else {
            GenseeLog.w((String)TAG, (String)"getCameraOrientation characteristics == null");
        }
        return result;
    }

    @Override
    protected void processVideoData(byte[] data, int mWidth, int mHeight) {
        this.videoProcess.notifyData(data, mWidth, mHeight);
    }

    @Override
    protected void toStartPreview() {
        this.videoProcess.setSurfaceTexture(null);
        this.videoProcess.toStartPreview(this.videoParam);
    }

    @Override
    public void onSendData(byte[] yuv12, int realWidth, int realHeight) {
        this.sendOpenGlYuvData(yuv12, realWidth, realHeight);
    }

    @Override
    public boolean releaseCamera() {
        boolean bRelease = super.releaseCamera();
        this.videoProcess.release();
        return bRelease;
    }
}

