/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.gensee.view.beauty.IGSLocalVideoViewImp;

class GSTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
IGSLocalVideoViewImp {
    private OnTextureViewListener mOnTextureViewListener;

    public void setOnTextureViewListener(OnTextureViewListener mOnTextureViewListener) {
        this.mOnTextureViewListener = mOnTextureViewListener;
    }

    public GSTextureView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.setSurfaceTextureListener(this);
    }

    public GSTextureView(Context context) {
        this(context, null);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (null != this.mOnTextureViewListener) {
            this.mOnTextureViewListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (null != this.mOnTextureViewListener) {
            this.mOnTextureViewListener.onSurfaceTextureSizeChanged(width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (null != this.mOnTextureViewListener) {
            this.mOnTextureViewListener.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public static interface OnTextureViewListener {
        public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3);

        public void onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onSurfaceTextureSizeChanged(int var1, int var2);
    }
}

