/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.TextureView;
import com.gensee.camera.CameraProvider;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.beauty.IGSLocalVideoView;

public class GSLocalVideoViewAdv
extends TextureView
implements IGSLocalVideoView,
TextureView.SurfaceTextureListener {
    private static final String TAG = "GSLocalVideoView";
    private CameraProvider cameraProvider;
    private int orientation;

    public GSLocalVideoViewAdv(Context context) {
        this(context, null);
    }

    public GSLocalVideoViewAdv(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSLocalVideoViewAdv(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        ResourceUtil.getIns().attachCtx(this.getContext());
        this.setSurfaceTextureListener(this);
        this.cameraProvider = CameraProvider.create();
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        GenseeLog.i((String)TAG, (String)("onSurfaceTextureAvailable width=" + width + ",height=" + height));
        ResourceUtil.getIns().attachCtx(this.getContext());
        this.cameraProvider.onSurfaceTextureAvailable(surface, width, height);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GenseeLog.i((String)TAG, (String)("onSurfaceTextureSizeChanged width=" + width + ",height=" + height));
        this.cameraProvider.onSurfaceTextureSizeChanged(surface, width, height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GenseeLog.i((String)TAG, (String)"onSurfaceTextureDestroyed");
        this.cameraProvider.onSurfaceTextureDestroyed();
        ResourceUtil.getIns().detachCtx();
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void reOpenCamera() {
        this.cameraProvider.reOpenCamera();
    }

    public boolean isCameraSwitchEnable() {
        return this.cameraProvider.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        this.cameraProvider.doCameraSwitch();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isHolderCreated() {
        return false;
    }

    public boolean close() {
        this.cameraProvider.close();
        return false;
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        GenseeLog.i((String)"");
        if (null != this.cameraProvider) {
            this.cameraProvider.setVideoParams(param, iVideoCoreInterface);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (GSLocalVideoViewAdv.this.getVisibility() != 0) {
                    GSLocalVideoViewAdv.this.setVisibility(0);
                }
                if (null != GSLocalVideoViewAdv.this.cameraProvider) {
                    GSLocalVideoViewAdv.this.cameraProvider.open();
                }
            }
        });
        return false;
    }

    public Camera getCamera() {
        return null;
    }

    public void release() {
        this.cameraProvider.release();
    }

    public void setHardEncode(boolean b) {
        this.cameraProvider.setHardEncode(b);
    }

    public boolean isVideoHardEncode() {
        return this.cameraProvider.getHardEncode();
    }

    public void setVideoSize(int width, int height) {
        this.cameraProvider.setVideoSize(this.getContext(), width, height);
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.cameraProvider.setOnCameraPermissionListener(onCameraPermissionListener);
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.cameraProvider.setOnCameraInfoListener(onCameraInfoListener);
    }

    public void setVideoCore(IVideoCoreInterface iVideoCoreInterface) {
        if (null != this.cameraProvider) {
            this.cameraProvider.setVideoCore(iVideoCoreInterface);
        }
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback onVideoHardEncodeDataCallback) {
        this.cameraProvider.setHardEncodeDataCallback(onVideoHardEncodeDataCallback);
    }

    public void setFps(int fps) {
        this.cameraProvider.setFps(fps);
    }

    public void setBitRate(int bitRate) {
        this.cameraProvider.setBitRate(bitRate);
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        this.cameraProvider.switchFlashOnOrOff(bOpen);
    }

    public boolean isSupportFlashOnOrOff() {
        return this.cameraProvider.isSupportFlashOnOrOff();
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        this.cameraProvider.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
    }

    public boolean isSupportFocusAuto() {
        return this.cameraProvider.isSupportFocusAuto();
    }

    public void forceKeyFrame() {
        this.cameraProvider.forceKeyFrame();
    }

    public void switchBeauty(boolean isBeauty) {
        this.cameraProvider.setBeauty(isBeauty);
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.cameraProvider.setVideoDataPng(mBitmap);
    }

    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.cameraProvider.setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight, desVideoLogoMarginTop, desVideoLogoMarginRight);
    }
}

