/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.beauty;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.VideoCapture;
import com.gensee.view.beauty.GSGlSurfaceView;
import com.gensee.view.beauty.GSTextureView;
import com.gensee.view.beauty.GSVideoCamera2Capture;
import com.gensee.view.beauty.GSVideoCapture;
import com.gensee.view.beauty.IGSLocalVideoView;
import com.gensee.view.beauty.IGSLocalVideoViewImp;
import com.gensee.view.beauty.IGSLocalVideoViewType;
import com.gensee.view.beauty.IGSVideoCapture;
import java.io.IOException;

public class GSLocalVideoView
extends RelativeLayout
implements IGSLocalVideoView,
VideoCapture.OnCaptureCallBack,
GSTextureView.OnTextureViewListener,
GSGlSurfaceView.OnGlSurfaceViewListener {
    private static final String TAG = "GSLocalVideoView";
    private IGSLocalVideoViewType type = IGSLocalVideoViewType.TYPE_TEXTUREVIEW;
    private IGSLocalVideoViewImp mVideoViewImp;
    private VideoCapture mVideoCapture;

    public GSLocalVideoView(Context context) {
        this(context, null);
    }

    public GSLocalVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSLocalVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        ResourceUtil.getIns().attachCtx(context);
        this.init();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ResourceUtil.getIns().detachCtx();
    }

    public void switchBeauty(boolean bOpen) {
        if (this.mVideoCapture != null) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).switchBeauty(bOpen);
        }
    }

    private void init() {
        this.setBackgroundColor(-16777216);
        if (this.type == IGSLocalVideoViewType.TYPE_TEXTUREVIEW) {
            this.mVideoViewImp = new GSTextureView(this.getContext());
            ((GSTextureView)this.mVideoViewImp).setOnTextureViewListener(this);
        } else {
            this.mVideoViewImp = new GSGlSurfaceView(this.getContext());
            ((GSGlSurfaceView)this.mVideoViewImp).setOnGlSurfaceViewListener(this);
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(13);
        this.addView((View)this.mVideoViewImp, (ViewGroup.LayoutParams)lp);
        this.mVideoCapture = VideoCapture.isUseCamera2() ? new GSVideoCamera2Capture(this.getContext(), this.mVideoViewImp) : new GSVideoCapture(this.getContext(), this.mVideoViewImp);
        this.mVideoCapture.setOnCaptureCallBack(this);
    }

    public boolean isCameraSwitchEnable() {
        return null == this.mVideoCapture ? false : this.mVideoCapture.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.doCameraSwitch();
        }
    }

    public int getOrientation() {
        return null == this.mVideoCapture ? -1 : this.mVideoCapture.getOrientation();
    }

    public void setOrientation(int orientation) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setOrientation(orientation);
        }
    }

    @Override
    public boolean isHolderCreated() {
        return true;
    }

    public boolean close() {
        if (this.mVideoCapture != null) {
            return this.mVideoCapture.close();
        }
        GenseeLog.w((String)TAG, (String)"close but videoCapture is null");
        return false;
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.open(param, iVideoCoreInterface);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (GSLocalVideoView.this.getVisibility() != 0) {
                    GSLocalVideoView.this.setVisibility(0);
                }
                if (null != GSLocalVideoView.this.mVideoCapture) {
                    GSLocalVideoView.this.mVideoCapture.cameraOpen();
                }
            }
        });
        return false;
    }

    public Camera getCamera() {
        return null == this.mVideoCapture ? null : this.mVideoCapture.getCamera();
    }

    public void setHardEncode(boolean isHardEncode) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setHardEncode(isHardEncode);
        }
    }

    public boolean isVideoHardEncode() {
        return null == this.mVideoCapture ? false : this.mVideoCapture.isVideoHardEncode();
    }

    public void setVideoSize(int width, int height) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setVideoSize(this.getContext(), width, height);
        }
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setOnCameraPermissionListener(onCameraPermissionListener);
        }
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setOnCameraInfoListener(onCameraInfoListener);
        }
    }

    @Override
    public boolean onSetPreviewHolder(Camera camera) throws IOException {
        return false;
    }

    @Override
    public SurfaceTexture getSurfaceTexTure() {
        return null;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (null != this.mVideoCapture) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).initTextureRender(surface, width, height);
        }
        this.surfaceAvailable();
    }

    @Override
    public void onSurfaceTextureSizeChanged(int width, int height) {
        if (null != this.mVideoCapture) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).changeSizeTextureRender(width, height);
        }
    }

    @Override
    public void onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.releaseCamera();
    }

    @Override
    public void onGlDetachedFromWindow() {
        if (null != this.mVideoCapture) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).releaseGlViewRender();
        }
        this.releaseCamera();
    }

    @Override
    public void onGlAttachedToWindow() {
        this.surfaceAvailable();
    }

    private void releaseCamera() {
        if (null != this.mVideoCapture) {
            GenseeLog.d((String)TAG, (String)"videocapture releaseCamera");
            this.mVideoCapture.releaseCamera();
        }
    }

    private void surfaceAvailable() {
        if (null != this.mVideoCapture) {
            GenseeLog.d((String)TAG, (String)("videocapture surfaceAvailable capture.isPreviewing() = " + this.mVideoCapture.isPreviewing()));
            this.mVideoCapture.surfaceAvailable();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        ((View)this.mVideoViewImp).setVisibility(visibility);
    }

    public void setZOrderMediaOverlay(boolean bTrue) {
        if (this.mVideoViewImp instanceof GSGlSurfaceView) {
            ((GSGlSurfaceView)this.mVideoViewImp).setZOrderMediaOverlay(true);
        }
    }

    public void setZOrderOnTop(boolean bTrue) {
        if (this.mVideoViewImp instanceof GSGlSurfaceView) {
            ((GSGlSurfaceView)this.mVideoViewImp).setZOrderOnTop(true);
        }
    }

    public void release() {
        GenseeLog.d((String)TAG, (String)("release " + this.mVideoCapture));
        if (null != this.mVideoCapture) {
            this.mVideoCapture.release();
            if (this.mVideoViewImp instanceof GSTextureView && null != this.mVideoCapture) {
                ((IGSVideoCapture)((Object)this.mVideoCapture)).releaseTextureRender();
            }
            this.mVideoCapture = null;
        }
    }

    public void setVideoCore(IVideoCoreInterface iVideoCoreInterface) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setVideoCore(iVideoCoreInterface);
        }
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        if (null != this.mVideoCapture) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).setVideoDataPng(mBitmap);
        }
    }

    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        if (null != this.mVideoCapture) {
            ((IGSVideoCapture)((Object)this.mVideoCapture)).setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight, desVideoLogoMarginTop, desVideoLogoMarginRight);
        }
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setHardEncodeDataCallback(callback);
        }
    }

    public void setFps(int fps) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setFps(fps);
        }
    }

    public void setBitRate(int bitRate) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.setBitRate(bitRate);
        }
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.switchFlashOnOrOff(bOpen);
        }
    }

    public boolean isSupportFlashOnOrOff() {
        return null == this.mVideoCapture ? false : this.mVideoCapture.isSupportFlashOnOrOff();
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
        }
    }

    public boolean isSupportFocusAuto() {
        return null == this.mVideoCapture ? false : this.mVideoCapture.isSupportFocusAuto();
    }

    public void forceKeyFrame() {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.forceKeyFrame();
        }
    }

    @Override
    public void reOpenCamera() {
        if (null != this.mVideoCapture) {
            this.mVideoCapture.reOpenCamera();
        }
    }
}

