/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import com.gensee.media.ViEncoder;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.videoparam.VideoParam;
import java.util.Calendar;

public class VideoHardEncoded {
    private static final String TAG = "VideoHardEncoded";
    private ViEncoder viEncoder;
    private IVideoCoreInterface iVideoCoreInterface;
    private OnVideoHardEncodeDataCallback mOnVideoHardEncodeDataCallback;
    private OnVideoHardEncodeDataCallback mDataCallbackFormLocalView;
    long nCountStartTime = Calendar.getInstance().getTimeInMillis();
    private byte[] configBuf;
    private boolean bNeedIFrame = false;

    public void sendEncodeFrame(byte[] data, int width, int height, int flag) {
        if (this.viEncoder != null) {
            this.viEncoder.encodeFrame(data, width, height, data.length, 0);
        }
    }

    public VideoHardEncoded(int width, int height, IVideoCoreInterface iVideoCoreInterface) {
        this.iVideoCoreInterface = iVideoCoreInterface;
        this.viEncoder = new ViEncoder(){

            public void onEncode(byte[] tmp, int i, int size, int flags, int width, int height) {
                VideoHardEncoded.this.onEncode(tmp, i, size, flags, width, height);
            }
        };
    }

    public void start() {
        this.viEncoder.start();
    }

    public void setBitRate(int mBitRate) {
        if (null != this.viEncoder) {
            this.viEncoder.setBitRate(mBitRate);
        }
    }

    public void setFps(int mFps) {
        if (null != this.viEncoder) {
            this.viEncoder.setFps(mFps);
        }
    }

    private void onEncode(byte[] outputBuffer, int i, int length, int flag, int width, int height) {
        VideoParam p = new VideoParam();
        p.width = width;
        p.height = height;
        p.fmt = 2002;
        p.fps = 15;
        p.bitCount = 125000;
        int headSec = 0;
        if (outputBuffer[0] == 0 && outputBuffer[1] == 0) {
            if (outputBuffer[2] == 0 && outputBuffer[3] == 1) {
                headSec = 4;
            } else if (outputBuffer[2] == 1) {
                headSec = 3;
            }
        }
        if (headSec == 0) {
            GenseeLog.w((String)TAG, (String)"onFrame UC_PIX_FMT_H264_KEY fileter not 264 data");
            this.bNeedIFrame = true;
            return;
        }
        int frameType = outputBuffer[headSec] & 0x1F;
        if (this.bNeedIFrame && frameType != 5) {
            return;
        }
        this.bNeedIFrame = false;
        switch (frameType) {
            case 1: {
                p.fmt = 2002;
                break;
            }
            case 5: {
                p.fmt = 2001;
                break;
            }
            case 7: 
            case 8: {
                this.configBuf = null;
                byte[] temp = null;
                for (int j = headSec; j < outputBuffer.length - headSec; ++j) {
                    if (outputBuffer[j] != 0 || outputBuffer[j + 1] != 0 || (headSec != 4 || outputBuffer[j + 2] != 0 || outputBuffer[j + 3] != 1) && (headSec != 3 || outputBuffer[j + 2] != 1)) continue;
                    frameType = outputBuffer[j + headSec] & 0x1F;
                    if (frameType == 7 || frameType == 8) {
                        j += headSec;
                        continue;
                    }
                    if (this.configBuf == null) {
                        this.configBuf = new byte[j];
                        System.arraycopy(outputBuffer, 0, this.configBuf, 0, j);
                    }
                    temp = new byte[length - j];
                    System.arraycopy(outputBuffer, j, temp, 0, length - j);
                    break;
                }
                if (this.configBuf == null) {
                    this.configBuf = outputBuffer;
                }
                if (null != this.configBuf) {
                    p.fmt = 2000;
                    if (null != this.mOnVideoHardEncodeDataCallback) {
                        this.mOnVideoHardEncodeDataCallback.onVideoHardEncodeData(this.configBuf, p);
                    } else {
                        if (this.mDataCallbackFormLocalView != null) {
                            byte[] tmpBack = new byte[this.configBuf.length];
                            System.arraycopy(this.configBuf, 0, tmpBack, 0, this.configBuf.length);
                            this.mDataCallbackFormLocalView.onVideoHardEncodeData(tmpBack, p);
                        }
                        if (null != this.iVideoCoreInterface) {
                            this.iVideoCoreInterface.sendVideoData(this.configBuf, p);
                        }
                    }
                }
                if (temp != null) {
                    this.onEncode(temp, 0, temp.length, flag, width, height);
                }
                return;
            }
            default: {
                GenseeLog.w((String)TAG, (String)("onFrame UC_PIX_FMT_H264_KEY fileter non data flag = " + flag + " pixFMT = " + p.fmt + " width = " + width + " height = " + height));
                this.bNeedIFrame = true;
                return;
            }
        }
        if (null != this.mOnVideoHardEncodeDataCallback) {
            this.mOnVideoHardEncodeDataCallback.onVideoHardEncodeData(outputBuffer, p);
        } else {
            if (this.mDataCallbackFormLocalView != null) {
                byte[] tmpBack = new byte[outputBuffer.length];
                System.arraycopy(outputBuffer, 0, tmpBack, 0, outputBuffer.length);
                this.mDataCallbackFormLocalView.onVideoHardEncodeData(tmpBack, p);
            }
            this.iVideoCoreInterface.sendVideoData(outputBuffer, p);
        }
    }

    public void release() {
        if (this.viEncoder != null) {
            this.viEncoder.release();
        }
        this.configBuf = null;
    }

    public void setOnVideoHardEncodeDataCallback(OnVideoHardEncodeDataCallback mOnVideoHardEncodeDataCallback) {
        this.mOnVideoHardEncodeDataCallback = mOnVideoHardEncodeDataCallback;
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback mOnVideoHardEncodeDataCallback) {
        this.mDataCallbackFormLocalView = mOnVideoHardEncodeDataCallback;
    }

    public void setVideoCore(IVideoCoreInterface videoCoreInterface) {
        this.iVideoCoreInterface = videoCoreInterface;
    }

    public void forceKeyFrame() {
        this.viEncoder.forceKeyFrame();
    }
}

